/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.xsocket.ClosedConnectionException;
import org.xsocket.Dispatcher;
import org.xsocket.datagram.AbstractNioBasedEndpoint;
import org.xsocket.datagram.ConnectedEventHandler;
import org.xsocket.datagram.IConnectedEndpoint;
import org.xsocket.datagram.IConnectedEndpointHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalConnectedEndpoint
extends AbstractNioBasedEndpoint
implements IConnectedEndpoint {
    private static Dispatcher<AbstractNioBasedEndpoint.EndpointHandle> defaultDispatcher = null;
    private IConnectedEndpointHandler appHandler = null;
    private SocketAddress remoteAddress = null;
    private long connectionOpenedTime = -1L;

    public LocalConnectedEndpoint(int localePort, int receiveDatasize, IConnectedEndpointHandler appHandler, SocketAddress remoteAddress) throws IOException {
        this(localePort, receiveDatasize, appHandler, 0, remoteAddress);
    }

    public LocalConnectedEndpoint(int localePort, int receiveDatasize, IConnectedEndpointHandler appHandler, int instanceWorkerPoolSize, SocketAddress remoteAddress) throws IOException {
        super(receiveDatasize, instanceWorkerPoolSize, localePort, appHandler == null);
        this.appHandler = appHandler;
        this.connect(remoteAddress);
    }

    @Override
    public long getConnectionOpenedTime() {
        return this.connectionOpenedTime;
    }

    public boolean isConnected() {
        return this.remoteAddress != null;
    }

    private void connect(SocketAddress remoteAddress) throws IOException {
        this.remoteAddress = remoteAddress;
        this.connectionOpenedTime = System.currentTimeMillis();
    }

    @Override
    public void close() {
        this.remoteAddress = null;
        super.close();
    }

    @Override
    protected Dispatcher<AbstractNioBasedEndpoint.EndpointHandle> createDispatcher() throws IOException {
        return this.createAndStartDispatcher(new ConnectedEventHandler());
    }

    @Override
    protected Dispatcher<AbstractNioBasedEndpoint.EndpointHandle> getDefaultDispatcher() throws IOException {
        if (defaultDispatcher == null) {
            defaultDispatcher = this.createAndStartDispatcher(new ConnectedEventHandler());
        }
        return defaultDispatcher;
    }

    @Override
    public void send(ByteBuffer data) throws ClosedConnectionException, IOException {
        this.sendDatagram(this.remoteAddress, data);
    }

    IConnectedEndpointHandler getAppHandler() {
        return this.appHandler;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }
}

