/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.xsocket.Dispatcher;
import org.xsocket.datagram.AbstractNioBasedEndpoint;
import org.xsocket.datagram.DisconnectedEventHandler;
import org.xsocket.datagram.IDisconnectedEndpoint;
import org.xsocket.datagram.IDisconnectedEndpointHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalDisconnectedEndpoint
extends AbstractNioBasedEndpoint
implements IDisconnectedEndpoint {
    private static Dispatcher<AbstractNioBasedEndpoint.EndpointHandle> defaultDispatcher = null;
    private IDisconnectedEndpointHandler appHandler = null;

    public LocalDisconnectedEndpoint() throws IOException {
        this(0, 0, null);
    }

    public LocalDisconnectedEndpoint(int localePort, int receiveDatasize, IDisconnectedEndpointHandler appHandler) throws IOException {
        this(localePort, receiveDatasize, appHandler, 0);
    }

    public LocalDisconnectedEndpoint(int localePort, int receiveDatasize, IDisconnectedEndpointHandler appHandler, int instanceWorkerPoolSize) throws IOException {
        super(receiveDatasize, instanceWorkerPoolSize, localePort, appHandler == null);
        this.appHandler = appHandler;
    }

    @Override
    protected Dispatcher<AbstractNioBasedEndpoint.EndpointHandle> createDispatcher() throws IOException {
        return this.createAndStartDispatcher(new DisconnectedEventHandler());
    }

    @Override
    protected Dispatcher<AbstractNioBasedEndpoint.EndpointHandle> getDefaultDispatcher() throws IOException {
        if (defaultDispatcher == null) {
            defaultDispatcher = this.createAndStartDispatcher(new DisconnectedEventHandler());
        }
        return defaultDispatcher;
    }

    @Override
    public void send(SocketAddress remoteAddress, ByteBuffer data) throws IOException {
        this.sendDatagram(remoteAddress, data);
    }

    public static void sendData(SocketAddress remoteAddress, ByteBuffer data) throws IOException {
        LocalDisconnectedEndpoint endpoint = new LocalDisconnectedEndpoint();
        endpoint.send(remoteAddress, data);
        endpoint.close();
    }

    IDisconnectedEndpointHandler getAppHandler() {
        return this.appHandler;
    }
}

