/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ClosedConnectionException;
import org.xsocket.datagram.AbstractEndpoint;
import org.xsocket.datagram.IConnectedEndpoint;
import org.xsocket.datagram.IConnectedEndpointHandler;

public final class LocalMulticastEndpoint
extends AbstractEndpoint
implements IConnectedEndpoint {
    private static Logger LOG = Logger.getLogger(LocalMulticastEndpoint.class.getName());
    private boolean isRunning = true;
    private IConnectedEndpointHandler appHandler = null;
    private MulticastSocket socket = null;
    private InetAddress group = null;
    private int port = 0;
    private long connectionOpenedTime = -1L;

    public LocalMulticastEndpoint(String address, int port) throws IOException {
        this(address, port, 0, null);
    }

    public LocalMulticastEndpoint(String address, int port, int receiveDatasize, IConnectedEndpointHandler appHandler) throws IOException {
        this(address, port, receiveDatasize, appHandler, 0);
    }

    public LocalMulticastEndpoint(String address, int port, int receiveDatasize, IConnectedEndpointHandler appHandler, int instanceWorkerPoolSize) throws IOException {
        super(receiveDatasize, instanceWorkerPoolSize);
        this.group = InetAddress.getByName(address);
        this.port = port;
        this.appHandler = appHandler;
        this.connectionOpenedTime = System.currentTimeMillis();
        this.socket = new MulticastSocket(port);
        this.socket.joinGroup(this.group);
        if (appHandler != null) {
            this.startReceiver();
        }
        if (LOG.isLoggable(Level.FINE)) {
            if (appHandler != null) {
                LOG.fine("upd multicast endpoint bound to " + this.group.getCanonicalHostName() + "/" + port + " (server mode: receiveDataSize=" + receiveDatasize + ", appHandler=" + appHandler.toString() + ")");
            } else {
                LOG.fine("upd multicast endpoint bound to " + this.group.getCanonicalHostName() + "/" + port + " (client mode)");
            }
        }
    }

    public long getConnectionOpenedTime() {
        return this.connectionOpenedTime;
    }

    private void startReceiver() {
        Thread receiverThread = new Thread(){

            public void run() {
                while (LocalMulticastEndpoint.this.isRunning) {
                    LocalMulticastEndpoint.this.receive();
                }
            }
        };
        receiverThread.start();
    }

    private void receive() {
        block3: {
            assert (this.appHandler != null);
            try {
                byte[] buf = new byte[this.getReceivePacketSize()];
                final DatagramPacket packet = new DatagramPacket(buf, buf.length);
                this.socket.receive(packet);
                this.incNumberOfHandledIncomingDatagram();
                this.logFine("datagram package received (size=" + buf.length + ")");
                this.getWorkerPool().execute(new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                LocalMulticastEndpoint.this.appHandler.onData(LocalMulticastEndpoint.this, ByteBuffer.wrap(packet.getData()));
                            }
                            catch (Exception e) {
                                if (!LOG.isLoggable(Level.FINE)) break block2;
                                LOG.fine("error occured by handling data. Reason: " + e.toString());
                            }
                        }
                    }
                });
            }
            catch (IOException e) {
                if (this.socket.isClosed()) break block3;
                e.printStackTrace();
            }
        }
    }

    public String toCompactString() {
        return "MulticastEndpoint " + this.socket.getLocalAddress().getCanonicalHostName() + "/" + this.socket.getLocalPort();
    }

    public void close() {
        if (this.isRunning) {
            this.isRunning = false;
            this.stopWorkerPool();
            this.socket.close();
        }
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    public final void logFine(String msg) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[/:" + this.getLocalPort() + " " + this.getId() + "] " + msg);
        }
    }

    public void send(ByteBuffer data) throws ClosedConnectionException, IOException {
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        DatagramPacket dataPacket = new DatagramPacket(bytes, bytes.length, this.group, this.port);
        this.logFine("sending datagram package (size=" + bytes.length + ")");
        this.socket.send(dataPacket);
        this.incNumberOfHandledOutgoingDatagram();
    }
}

