/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.Dispatcher;
import org.xsocket.WorkerPool;
import org.xsocket.stream.IConnectionScoped;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.IoSocketHandler;
import org.xsocket.stream.MemoryManager;
import org.xsocket.stream.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Acceptor {
    private static final Logger LOG = Logger.getLogger(Acceptor.class.getName());
    private boolean isRunning = true;
    private String appDomain = null;
    private ServerSocketChannel serverChannel = null;
    private IHandler appHandlerPrototype = null;
    private boolean isConnectionScoped = false;
    private boolean isConnectHandler = false;
    private boolean isDisconnectHandler = false;
    private boolean isDataHandler = false;
    private boolean isTimeoutHandler = false;
    private boolean sslOn = false;
    private SSLContext sslContext = null;
    private String localIdPrefix = null;
    private ConnectionDispatcherPool dispatcherPool = null;
    private WorkerPool workerPool = null;
    private long idleTimeout = Long.MAX_VALUE;
    private long connectionTimeout = Long.MAX_VALUE;
    private Timer watchdogTimer = new Timer(true);
    private WatchdogTask watchdogTask = null;
    private int preallocationSize = 65536;
    private long handledConnections = 0L;
    private int numberOfConnectionTimeout = 0;
    private int numberOfIdleTimeout = 0;

    public Acceptor(int serverPort, WorkerPool workerPool, SSLContext sslContext, boolean sslOn, String localIdPrefix) throws IOException {
        this.sslContext = sslContext;
        this.workerPool = workerPool;
        this.sslOn = sslOn;
        this.localIdPrefix = localIdPrefix;
        try {
            LOG.fine("try to bind server on port " + serverPort);
            this.serverChannel = ServerSocketChannel.open();
            this.serverChannel.configureBlocking(true);
            this.serverChannel.socket().bind(new InetSocketAddress(serverPort));
            this.dispatcherPool = new ConnectionDispatcherPool();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("acceptor has been bound on port " + this.serverChannel.socket().getLocalPort());
            }
        }
        catch (BindException be) {
            if (this.serverChannel != null) {
                this.serverChannel.close();
            }
            LOG.info("error occured while binding server on port " + serverPort + ". Reason: " + be.toString());
            throw be;
        }
    }

    void setAppDomain(String appDomain) {
        this.appDomain = appDomain;
    }

    int getLocalePort() {
        return this.serverChannel.socket().getLocalPort();
    }

    void setHandler(IHandler appHandler, boolean isConnectionScoped, boolean isConnectHandler, boolean isDisconnectHandler, boolean isDataHandler, boolean isTimeoutHandler) {
        this.appHandlerPrototype = appHandler;
        this.isConnectionScoped = isConnectionScoped;
        this.isConnectHandler = isConnectHandler;
        this.isDisconnectHandler = isDisconnectHandler;
        this.isDataHandler = isDataHandler;
        this.isTimeoutHandler = isTimeoutHandler;
    }

    public final void shutdown() {
        if (this.isRunning) {
            this.isRunning = false;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing acceptor");
            }
            try {
                this.serverChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dispatcherPool.shutdown();
        }
    }

    public final void run() {
        this.dispatcherPool.run();
        while (this.isRunning) {
            try {
                SocketChannel channel = this.serverChannel.accept();
                IHandler appHandler = null;
                appHandler = this.isConnectionScoped ? (IHandler)((IConnectionScoped)((Object)this.appHandlerPrototype)).clone() : this.appHandlerPrototype;
                ConnectionDispatcher dispatcher = this.dispatcherPool.nextDispatcher();
                IoSocketHandler socketIOHandler = new IoSocketHandler(channel, "s." + this.localIdPrefix + ".", dispatcher.getMemoryManager(), dispatcher.getNativeDispatcher(), this.workerPool);
                new NonBlockingConnection(socketIOHandler, this.sslContext, this.sslOn, dispatcher.getSSLMemoryManager(), false, appHandler, this.isConnectHandler, this.isDisconnectHandler, this.isDataHandler, this.isTimeoutHandler, false);
                ++this.handledConnections;
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINE) || !this.serverChannel.isOpen()) continue;
                LOG.fine("error occured while accepting connection: " + t.toString());
            }
        }
    }

    int getReceiveBufferPreallocationSize() {
        return this.preallocationSize;
    }

    void setReceiveBufferPreallocationSize(int size) {
        this.preallocationSize = size;
    }

    void setIdleTimeout(long idleTimeout) {
        if (idleTimeout <= 0L) {
            throw new RuntimeException("idle timeout must be larger than 0");
        }
        this.idleTimeout = idleTimeout;
        this.dispatcherPool.updateTimeoutCheckPeriod();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("idle time out has been update to " + DataConverter.toFormatedDuration(this.idleTimeout));
        }
    }

    long getIdleTimeout() {
        return this.idleTimeout;
    }

    void setConnectionTimeout(long connectionTimeout) {
        if (connectionTimeout <= 0L) {
            throw new RuntimeException("connection timeout must be larger than 0");
        }
        this.connectionTimeout = connectionTimeout;
        this.dispatcherPool.updateTimeoutCheckPeriod();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection time out has ben update to " + DataConverter.toFormatedDuration(this.connectionTimeout));
        }
    }

    long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    int getNumberOfConnectionTimeout() {
        return this.numberOfConnectionTimeout;
    }

    int getNumberOfIdleTimeout() {
        return this.numberOfIdleTimeout;
    }

    List<String> getOpenConnections() {
        return this.dispatcherPool.getOpenConnections();
    }

    int getNumberOfOpenConnections() {
        return this.dispatcherPool.getNumberOfOpenConnections();
    }

    long getNumberOfHandledConnections() {
        return this.dispatcherPool.getNumberOfHandledConnections();
    }

    void setDispatcherPoolSize(int size) {
        this.dispatcherPool.setSize(size);
    }

    int getDispatcherPoolSize() {
        return this.dispatcherPool.getSize();
    }

    private void checkConnectionTimeout(IoSocketHandler ioSocketHandler, long current, long idleTimeout, long connectionTimeout) {
        if (ioSocketHandler.checkIdleTimeout(current, idleTimeout)) {
            ++this.numberOfIdleTimeout;
        }
        if (ioSocketHandler.checkConnectionTimeout(current, connectionTimeout)) {
            ++this.numberOfConnectionTimeout;
        }
    }

    private void setTimeoutCheckPeriod(long period) {
        if (this.watchdogTask != null) {
            this.watchdogTask.cancel();
        }
        this.watchdogTask = new WatchdogTask();
        this.watchdogTimer.schedule((TimerTask)this.watchdogTask, period, period);
    }

    private final class SingleThreadedMemoryManager
    implements IMemoryManager {
        private ByteBuffer freeBuffer = null;

        private SingleThreadedMemoryManager() {
        }

        public int getCurrentPreallocationBufferSize() {
            ByteBuffer b = this.freeBuffer;
            if (b == null) {
                return 0;
            }
            return b.remaining();
        }

        public void recycleMemory(ByteBuffer buffer) {
            if (buffer.hasRemaining()) {
                this.freeBuffer = buffer;
            }
        }

        public final ByteBuffer acquireMemory(int minSize) {
            ByteBuffer buffer = null;
            if (this.freeBuffer != null) {
                if (this.freeBuffer.remaining() >= minSize) {
                    buffer = this.freeBuffer;
                }
                this.freeBuffer = null;
            }
            if (buffer == null) {
                buffer = this.newBuffer(Acceptor.this.preallocationSize);
            }
            return buffer;
        }

        final ByteBuffer newBuffer(int preallocationSize) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("allocate new physical memory (size: " + preallocationSize + ") by thread " + Thread.currentThread().getName());
            }
            return ByteBuffer.allocateDirect(preallocationSize);
        }

        public int getFreeBufferSize() {
            if (this.freeBuffer != null) {
                return this.freeBuffer.remaining();
            }
            return 0;
        }
    }

    private final class MultiThreadedMemoryManager
    extends MemoryManager {
        MultiThreadedMemoryManager() {
            super(Acceptor.this.preallocationSize, true);
        }

        int getPreallocationSize() {
            return Acceptor.this.preallocationSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConnectionDispatcher
    implements DispatcherMBean,
    Runnable {
        private Dispatcher<IoSocketHandler> dispatcher = null;
        private IMemoryManager memoryManager = new SingleThreadedMemoryManager();
        private IMemoryManager sslMemoryManager = new MultiThreadedMemoryManager();
        private ObjectName mbeanName = null;

        ConnectionDispatcher(String appDomain, int number) {
            this.dispatcher = IoSocketHandler.createDispatcher(Integer.toString(number));
            try {
                String name = "Dispatcher_" + number;
                StandardMBean mbean = new StandardMBean(this, DispatcherMBean.class);
                this.mbeanName = new ObjectName(appDomain + ":type=Dispatcher,name=" + name);
                ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, this.mbeanName);
            }
            catch (Exception mbe) {
                LOG.warning("error " + mbe.toString() + " occured while registering mbean");
            }
        }

        Dispatcher<IoSocketHandler> getNativeDispatcher() {
            return this.dispatcher;
        }

        IMemoryManager getMemoryManager() {
            return this.memoryManager;
        }

        IMemoryManager getSSLMemoryManager() {
            return this.sslMemoryManager;
        }

        @Override
        public void run() {
            this.dispatcher.run();
        }

        void shutdown() {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.mbeanName);
            }
            catch (Exception mbe) {
                LOG.warning("error " + mbe.toString() + " occured while unregistering mbean");
            }
            this.dispatcher.shutdown();
        }

        @Override
        public long getNumberOfHandledReads() {
            return this.dispatcher.getNumberOfHandledReads();
        }

        @Override
        public long getNumberOfHandledRegistrations() {
            return this.dispatcher.getNumberOfHandledRegistrations();
        }

        @Override
        public long getNumberOfHandledWrites() {
            return this.dispatcher.getNumberOfHandledWrites();
        }

        @Override
        public int getNumberOfRegistered() {
            return this.dispatcher.getRegistered().size();
        }

        @Override
        public int getFreeReceiveBufferSize() {
            return this.memoryManager.getFreeBufferSize();
        }

        @Override
        public int getFreeSSLBufferSize() {
            return this.sslMemoryManager.getFreeBufferSize();
        }
    }

    public static interface DispatcherMBean {
        public long getNumberOfHandledRegistrations();

        public long getNumberOfHandledReads();

        public long getNumberOfHandledWrites();

        public int getNumberOfRegistered();

        public int getFreeReceiveBufferSize();

        public int getFreeSSLBufferSize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConnectionDispatcherPool {
        private final LinkedList<ConnectionDispatcher> dispatchers = new LinkedList();
        private int size = 0;
        private int pointer = 0;

        private ConnectionDispatcherPool() {
        }

        void updateTimeoutCheckPeriod() {
            long period = Acceptor.this.getIdleTimeout();
            if (Acceptor.this.getConnectionTimeout() < Acceptor.this.getIdleTimeout()) {
                period = Acceptor.this.getConnectionTimeout();
            }
            Acceptor.this.setTimeoutCheckPeriod((int)((double)period / 5.0));
        }

        int getSize() {
            return this.size;
        }

        void setSize(int size) {
            this.size = size;
            this.updateDisptacher();
        }

        void run() {
            Acceptor.this.isRunning = true;
            this.updateDisptacher();
        }

        private void updateDisptacher() {
            block2: {
                int currentRunning;
                block3: {
                    if (!Acceptor.this.isRunning || (currentRunning = this.dispatchers.size()) == this.size) break block2;
                    if (currentRunning <= this.size) break block3;
                    for (int i = this.size; i < currentRunning; ++i) {
                        ConnectionDispatcher dispatcher = this.dispatchers.getLast();
                        this.dispatchers.remove(dispatcher);
                        dispatcher.shutdown();
                    }
                    break block2;
                }
                if (currentRunning >= this.size) break block2;
                for (int i = currentRunning; i < this.size; ++i) {
                    ConnectionDispatcher dispatcher = new ConnectionDispatcher(Acceptor.this.appDomain, i);
                    this.dispatchers.addLast(dispatcher);
                    Thread t = new Thread(dispatcher);
                    t.setDaemon(false);
                    t.start();
                }
            }
        }

        void shutdown() {
            Acceptor.this.isRunning = false;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.fine("terminate dispatchers");
            }
            for (ConnectionDispatcher dispatcher : this.dispatchers) {
                dispatcher.shutdown();
            }
            this.dispatchers.clear();
        }

        public ConnectionDispatcher nextDispatcher() {
            ++this.pointer;
            if (this.pointer >= this.size) {
                this.pointer = 0;
            }
            return this.dispatchers.get(this.pointer);
        }

        List<String> getOpenConnections() {
            ArrayList<String> result = new ArrayList<String>();
            for (ConnectionDispatcher dispatcher : this.dispatchers) {
                for (IoSocketHandler selectable : dispatcher.getNativeDispatcher().getRegistered()) {
                    result.add(((Object)selectable).toString());
                }
            }
            return result;
        }

        int getNumberOfOpenConnections() {
            int result = 0;
            for (ConnectionDispatcher dispatcher : this.dispatchers) {
                result += dispatcher.getNumberOfRegistered();
            }
            return result;
        }

        long getNumberOfHandledConnections() {
            long result = 0L;
            for (ConnectionDispatcher dispatcher : this.dispatchers) {
                result += dispatcher.getNativeDispatcher().getNumberOfHandledRegistrations();
            }
            return result;
        }

        private void checkDispatcherTimeout() {
            block4: {
                try {
                    long current = System.currentTimeMillis();
                    LinkedList disps = (LinkedList)this.dispatchers.clone();
                    for (ConnectionDispatcher dispatcher : disps) {
                        Set<IoSocketHandler> openConnections = dispatcher.getNativeDispatcher().getRegistered();
                        for (IoSocketHandler ioSocketHandler : openConnections) {
                            Acceptor.this.checkConnectionTimeout(ioSocketHandler, current, Acceptor.this.idleTimeout, Acceptor.this.connectionTimeout);
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("error occured: " + e.toString());
                }
            }
        }
    }

    private final class WatchdogTask
    extends TimerTask {
        private WatchdogTask() {
        }

        public void run() {
            if (Acceptor.this.isRunning) {
                Acceptor.this.dispatcherPool.checkDispatcherTimeout();
            }
        }
    }
}

