/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.TimeoutException;
import org.xsocket.WorkerPool;
import org.xsocket.stream.ByteBufferOutputChannel;
import org.xsocket.stream.Connection;
import org.xsocket.stream.IBlockingConnection;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.IoHandler;
import org.xsocket.stream.IoSSLHandler;
import org.xsocket.stream.IoSocketHandler;
import org.xsocket.stream.MemoryManager;

public final class BlockingConnection
extends Connection
implements IBlockingConnection {
    private static final WorkerPool WORKER_POOL = new WorkerPool(1);
    private final Set<Thread> waitingReadThreads = new HashSet<Thread>();
    private long readTimeout = 0L;
    private long sleepDuration = 0L;

    public BlockingConnection(String hostname, int port) throws IOException {
        this(hostname, port, null, false, null, null);
    }

    public BlockingConnection(InetAddress address, int port) throws IOException {
        this(address.getHostAddress(), port, null, false, null, null);
    }

    public BlockingConnection(String hostname, int port, int memoryPreallocationSize) throws IOException {
        this(hostname, port, new MemoryManager(memoryPreallocationSize, true));
    }

    private BlockingConnection(String hostname, int port, IMemoryManager memoryManager) throws IOException {
        this(hostname, port, null, false, memoryManager, memoryManager);
    }

    public BlockingConnection(String hostname, int port, SSLContext sslContext, boolean startSSL) throws IOException {
        this(hostname, port, sslContext, startSSL, null, null);
    }

    private BlockingConnection(String hostname, int port, SSLContext sslContext, boolean startSSL, IMemoryManager memoryManager, IMemoryManager sslMemoryManager) throws IOException {
        this(new InetSocketAddress(hostname, port), sslContext, startSSL, memoryManager, sslMemoryManager);
    }

    private BlockingConnection(InetSocketAddress inetAddress, SSLContext sslContext, boolean startSSL, IMemoryManager memoryManager, IMemoryManager sslMemoryManager) throws IOException {
        this(new IoSocketHandler(SocketChannel.open(inetAddress), "c.", memoryManager, null, WORKER_POOL), sslContext, startSSL);
    }

    private BlockingConnection(IoSocketHandler socketHandler, SSLContext sslContext, boolean startSSL) throws IOException {
        this(socketHandler, sslContext, startSSL, socketHandler.getMemoryManager());
    }

    private BlockingConnection(IoSocketHandler socketHandler, SSLContext sslContext, boolean startSSL, IMemoryManager sslMemoryManager) throws IOException {
        super(true);
        socketHandler.setIOEventHandler(new IOEventHandler());
        if (sslContext != null) {
            IoSSLHandler sslHandler = new IoSSLHandler(socketHandler, sslContext, startSSL, true, sslMemoryManager);
            this.setIOHandler(sslHandler);
            this.open();
        } else {
            this.setIOHandler(socketHandler);
            this.open();
        }
        this.setReceiveTimeout(60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte receiveByte() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        do {
            Set<Thread> set = this.waitingReadThreads;
            synchronized (set) {
                try {
                    return this.extractByteFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    this.waitingReadThreads.add(Thread.currentThread());
                }
            }
            this.sleep(this.sleepDuration);
        } while (System.currentTimeMillis() < start + this.readTimeout);
        throw new TimeoutException("timeout " + DataConverter.toFormatedDuration(this.readTimeout) + " reached");
    }

    public final void setReceiveTimeout(long timeout) {
        this.readTimeout = timeout;
        this.sleepDuration = this.readTimeout / 5L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer[] receiveByteBufferByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
        ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
        long start = System.currentTimeMillis();
        do {
            Set<Thread> set = this.waitingReadThreads;
            synchronized (set) {
                try {
                    this.extractBytesByDelimiterFromReadQueue(delimiter, channel);
                    return channel.toByteBufferArray();
                }
                catch (BufferUnderflowException bue) {
                    this.waitingReadThreads.add(Thread.currentThread());
                }
            }
            this.sleep(this.sleepDuration);
        } while (System.currentTimeMillis() < start + this.readTimeout);
        throw new TimeoutException("timeout " + DataConverter.toFormatedDuration(this.readTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer[] receiveByteBufferByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
        long start = System.currentTimeMillis();
        do {
            Set<Thread> set = this.waitingReadThreads;
            synchronized (set) {
                try {
                    this.extractBytesByLength(length, channel);
                    return channel.toByteBufferArray();
                }
                catch (BufferUnderflowException bue) {
                    this.waitingReadThreads.add(Thread.currentThread());
                }
            }
            this.sleep(this.sleepDuration);
        } while (System.currentTimeMillis() < start + this.readTimeout);
        throw new TimeoutException("timeout " + DataConverter.toFormatedDuration(this.readTimeout) + " reached");
    }

    public byte[] receiveBytesByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return DataConverter.toArray(this.receiveByteBufferByDelimiter(delimiter));
    }

    public byte[] receiveBytesByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return DataConverter.toArray(this.receiveByteBufferByLength(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double receiveDouble() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        do {
            Set<Thread> set = this.waitingReadThreads;
            synchronized (set) {
                try {
                    return this.extractDoubleFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    this.waitingReadThreads.add(Thread.currentThread());
                }
            }
            this.sleep(this.sleepDuration);
        } while (System.currentTimeMillis() < start + this.readTimeout);
        throw new TimeoutException("timeout " + DataConverter.toFormatedDuration(this.readTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveInt() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        do {
            Set<Thread> set = this.waitingReadThreads;
            synchronized (set) {
                try {
                    return this.extractIntFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    this.waitingReadThreads.add(Thread.currentThread());
                }
            }
            this.sleep(this.sleepDuration);
        } while (System.currentTimeMillis() < start + this.readTimeout);
        throw new TimeoutException("timeout " + DataConverter.toFormatedDuration(this.readTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long receiveLong() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        do {
            Set<Thread> set = this.waitingReadThreads;
            synchronized (set) {
                try {
                    return this.extractLongFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    this.waitingReadThreads.add(Thread.currentThread());
                }
            }
            this.sleep(this.sleepDuration);
        } while (System.currentTimeMillis() < start + this.readTimeout);
        throw new TimeoutException("timeout " + DataConverter.toFormatedDuration(this.readTimeout) + " reached");
    }

    public String receiveStringByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.receiveStringByDelimiter(delimiter, this.getDefaultEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String receiveStringByDelimiter(String delimiter, String encoding) throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        do {
            Set<Thread> set = this.waitingReadThreads;
            synchronized (set) {
                try {
                    ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
                    this.extractBytesByDelimiterFromReadQueue(delimiter, channel);
                    return DataConverter.toString(channel.toByteBufferArray(), encoding);
                }
                catch (BufferUnderflowException bue) {
                    this.waitingReadThreads.add(Thread.currentThread());
                }
            }
            this.sleep(this.sleepDuration);
        } while (System.currentTimeMillis() < start + this.readTimeout);
        throw new TimeoutException("timeout " + DataConverter.toFormatedDuration(this.readTimeout) + " reached");
    }

    public String receiveStringByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.receiveStringByLength(length, this.getDefaultEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String receiveStringByLength(int length, String encoding) throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        do {
            Set<Thread> set = this.waitingReadThreads;
            synchronized (set) {
                try {
                    ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
                    this.extractBytesByLength(length, channel);
                    return DataConverter.toString(channel.toByteBufferArray(), encoding);
                }
                catch (BufferUnderflowException bue) {
                    this.waitingReadThreads.add(Thread.currentThread());
                }
            }
            this.sleep(this.sleepDuration);
        } while (System.currentTimeMillis() < start + this.readTimeout);
        throw new TimeoutException("timeout " + DataConverter.toFormatedDuration(this.readTimeout) + " reached");
    }

    private void sleep(long duration) throws ClosedConnectionException, IOException {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final class IOEventHandler
    implements IoHandler.IIOEventHandler {
        private IOEventHandler() {
        }

        public boolean listenForData() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDataEvent() {
            BlockingConnection.this.receive();
            Set set = BlockingConnection.this.waitingReadThreads;
            synchronized (set) {
                if (!BlockingConnection.this.waitingReadThreads.isEmpty()) {
                    for (Thread waitingThread : BlockingConnection.this.waitingReadThreads) {
                        waitingThread.interrupt();
                    }
                    BlockingConnection.this.waitingReadThreads.clear();
                }
            }
        }

        public boolean listenForConnect() {
            return false;
        }

        public void onConnectEvent() {
        }

        public boolean listenForDisconnect() {
            return false;
        }

        public void onDisconnectEvent() {
        }

        public void onConnectionTimeout() {
        }

        public void onIdleTimeout() {
        }
    }
}

