/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ByteBufferOutputChannel
implements WritableByteChannel {
    private boolean isOpen = true;
    private ByteBuffer[] buffers = new ByteBuffer[0];

    ByteBufferOutputChannel() {
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        if (buffer.limit() - buffer.position() > 0) {
            this.buffers = ByteBufferOutputChannel.incArray(this.buffers, buffer);
            return buffer.limit() - buffer.position();
        }
        return 0;
    }

    public ByteBuffer[] toByteBufferArray() {
        return this.buffers;
    }

    private static ByteBuffer[] incArray(ByteBuffer[] original, ByteBuffer newElement) {
        ByteBuffer[] newArray = (ByteBuffer[])ByteBufferOutputChannel.copyOf(original, original.length + 1, original.getClass());
        newArray[original.length] = newElement;
        return newArray;
    }

    private static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

