/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.xsocket.DataConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ByteBufferQueue {
    private LinkedList<ByteBuffer> buffers = null;

    ByteBufferQueue() {
    }

    synchronized boolean isEmpty() {
        if (this.buffers == null) {
            return true;
        }
        return this.buffers.isEmpty();
    }

    synchronized int getSize() {
        if (this.isEmpty()) {
            return 0;
        }
        int size = 0;
        for (ByteBuffer buffer : this.buffers) {
            size += buffer.remaining();
        }
        return size;
    }

    synchronized void append(ByteBuffer data) {
        if (data != null && data.hasRemaining()) {
            if (this.buffers == null) {
                this.buffers = new LinkedList();
            }
            this.buffers.add(data);
        }
    }

    synchronized void append(LinkedList<ByteBuffer> datas) {
        if (datas != null) {
            if (this.buffers == null) {
                this.buffers = datas;
            } else {
                this.buffers.addAll(datas);
            }
        }
    }

    synchronized void addFirst(ByteBuffer data) {
        if (data != null && data.hasRemaining()) {
            if (this.buffers == null) {
                this.buffers = new LinkedList();
            }
            this.buffers.addFirst(data);
        }
    }

    synchronized void addFirst(LinkedList<ByteBuffer> datas) {
        if (datas != null) {
            if (this.buffers == null) {
                this.buffers = new LinkedList();
            }
            datas.addAll(this.buffers);
            this.buffers = datas;
        }
    }

    synchronized LinkedList<ByteBuffer> drain() {
        LinkedList<ByteBuffer> result = this.buffers;
        this.buffers = null;
        return result;
    }

    synchronized int getFirstBufferSize() {
        if (this.buffers == null) {
            return 0;
        }
        if (this.buffers.isEmpty()) {
            return 0;
        }
        ByteBuffer buffer = this.buffers.getFirst();
        return buffer.remaining();
    }

    public synchronized ByteBuffer removeFirst() {
        if (this.buffers == null) {
            return null;
        }
        return this.buffers.removeFirst();
    }

    public synchronized byte[] read(int length) throws BufferUnderflowException {
        if (this.buffers == null) {
            throw new BufferUnderflowException();
        }
        byte[] bytes = new byte[length];
        int pointer = 0;
        if (!this.isSizeEqualsOrLargerThan(length)) {
            throw new BufferUnderflowException();
        }
        ByteBuffer buffer = this.buffers.removeFirst();
        while (true) {
            if (buffer.hasRemaining()) {
                bytes[pointer] = buffer.get();
                if (++pointer != length) continue;
                if (buffer.position() < buffer.limit()) {
                    this.buffers.addFirst(buffer.slice());
                }
                return bytes;
            }
            buffer = this.buffers.poll();
        }
    }

    private boolean isSizeEqualsOrLargerThan(int size) {
        if (this.buffers == null) {
            return false;
        }
        int l = 0;
        for (ByteBuffer buffer : this.buffers) {
            if ((l += buffer.remaining()) < size) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.buffers == null) {
            return "";
        }
        return DataConverter.toTextOrHexString(this.buffers.toArray(new ByteBuffer[this.buffers.size()]), "US-ASCII", 500);
    }
}

