/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.stream.ByteBufferParser;
import org.xsocket.stream.ByteBufferQueue;
import org.xsocket.stream.IConnection;
import org.xsocket.stream.IoHandler;
import org.xsocket.stream.IoSSLHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Connection
implements IConnection {
    private static final ByteBufferParser PARSER = new ByteBufferParser();
    private final ByteBufferQueue writeQueue = new ByteBufferQueue();
    private final ByteBufferQueue readQueue = new ByteBufferQueue();
    private IoHandler ioHandler = null;
    private String defaultEncoding = "UTF-8";
    private boolean autoflush = true;
    private ByteBufferParser.Index cachedIndex = null;

    Connection(boolean autoflush) {
        this.autoflush = autoflush;
    }

    void open() throws IOException {
        this.ioHandler.open();
    }

    final ByteBufferQueue getReadQueue() {
        return this.readQueue;
    }

    final IoHandler getIOHandler() {
        return this.ioHandler;
    }

    final void setIOHandler(IoHandler ioHdl) {
        this.ioHandler = ioHdl;
    }

    @Override
    public final void close() throws IOException {
        this.flushStrong();
        this.ioHandler.close();
    }

    @Override
    public final boolean isOpen() {
        return this.ioHandler.isOpen();
    }

    final void writeIncoming(ByteBuffer data) {
        this.readQueue.append(data);
    }

    final void writeOutgoing(ByteBuffer data) {
        this.writeQueue.append(data);
    }

    void writeOutgoing(LinkedList<ByteBuffer> datas) {
        this.writeQueue.append(datas);
    }

    @Override
    public final void flush() throws ClosedConnectionException, IOException {
        if (!this.writeQueue.isEmpty()) {
            LinkedList<ByteBuffer> buffer = this.writeQueue.drain();
            this.ioHandler.writeOutgoing(buffer);
        }
    }

    private void flushStrong() throws ClosedConnectionException, IOException {
        this.flush();
        this.getIOHandler().flushOutgoing();
    }

    @Override
    public final String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public final void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    @Override
    public boolean getAutoflush() {
        return this.autoflush;
    }

    @Override
    public final String getId() {
        return this.ioHandler.getId();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.ioHandler.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.ioHandler.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.ioHandler.getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.ioHandler.getRemotePort();
    }

    void onIdleTimeout() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void onConnectionTimeout() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    final void receive() {
        LinkedList<ByteBuffer> buffer = this.getIOHandler().drainIncoming();
        this.getReadQueue().append(buffer);
    }

    @Override
    public void startSSL() throws IOException {
        IoHandler ioHandler = this.getIOHandler();
        this.flushStrong();
        do {
            if (!(ioHandler instanceof IoSSLHandler)) continue;
            ((IoSSLHandler)ioHandler).startSSL();
            return;
        } while ((ioHandler = ioHandler.getSuccessor()) != null);
        throw new IOException("couldn't startSSL, because no SSLHandler (SSLContext) is set");
    }

    @Override
    public final int write(String s) throws ClosedConnectionException, IOException {
        return this.write(s, this.defaultEncoding);
    }

    @Override
    public final int write(String s, String encoding) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = DataConverter.toByteBuffer(s, encoding);
        return this.write(buffer);
    }

    @Override
    public final int write(byte b) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1).put(b);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(byte ... bytes) throws ClosedConnectionException, IOException {
        return this.write(ByteBuffer.wrap(bytes));
    }

    @Override
    public final int write(byte[] bytes, int offset, int length) throws ClosedConnectionException, IOException {
        return this.write(ByteBuffer.wrap(bytes, offset, length));
    }

    @Override
    public final long write(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        long written = 0L;
        for (ByteBuffer buffer : buffers) {
            written += (long)(buffer.limit() - buffer.position());
        }
        for (ByteBuffer buffer : buffers) {
            this.writeQueue.append(buffer);
        }
        if (this.autoflush) {
            this.flush();
        }
        return written;
    }

    @Override
    public final int write(ByteBuffer buffer) throws ClosedConnectionException, IOException {
        int written = buffer.limit() - buffer.position();
        this.writeQueue.append(buffer);
        if (this.autoflush) {
            this.flush();
        }
        return written;
    }

    @Override
    public final int write(int i) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4).putInt(i);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(long l) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putLong(l);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(double d) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putDouble(d);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        ByteBuffer[] bufs = new ByteBuffer[length];
        System.arraycopy(srcs, offset, bufs, 0, length);
        return this.write(bufs);
    }

    protected final LinkedList<ByteBuffer> extractAvailableFromReadQueue() {
        this.resetCachedIndex();
        return this.readQueue.drain();
    }

    protected final int extractBytesByDelimiterFromReadQueue(String delimiter, WritableByteChannel outChannel) throws IOException, BufferUnderflowException {
        if (!this.readQueue.isEmpty()) {
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, delimiter);
            if (index.hasDelimiterFound()) {
                PARSER.extract(buffers, index, outChannel);
                this.readQueue.addFirst(buffers);
                this.resetCachedIndex();
                return index.getReadBytes();
            }
            this.readQueue.addFirst(buffers);
            this.cachedIndex = index;
        }
        throw new BufferUnderflowException();
    }

    protected final void extractBytesByLength(int length, WritableByteChannel outChannel) throws IOException, BufferUnderflowException {
        LinkedList<ByteBuffer> buffers;
        if (this.readQueue.getSize() >= length) {
            buffers = this.readQueue.drain();
            assert (buffers != null);
        } else {
            throw new BufferUnderflowException();
        }
        PARSER.extract(buffers, length, outChannel);
        this.readQueue.addFirst(buffers);
        this.resetCachedIndex();
    }

    protected final boolean extractAvailableFromReadQueue(String delimiter, WritableByteChannel outChannel) throws IOException {
        if (!this.readQueue.isEmpty()) {
            int availableBytes;
            int readBytes;
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, delimiter);
            if (index.hasDelimiterFound()) {
                PARSER.extract(buffers, index, outChannel);
                this.readQueue.addFirst(buffers);
                this.resetCachedIndex();
                return true;
            }
            if (index.getDelimiterPos() == 0 && (readBytes = index.getReadBytes()) > 0 && (availableBytes = readBytes - index.getDelimiterPos()) > 0) {
                PARSER.extract(buffers, availableBytes, outChannel);
                this.resetCachedIndex();
            }
            this.readQueue.addFirst(buffers);
            return false;
        }
        return false;
    }

    private ByteBufferParser.Index scanByDelimiter(LinkedList<ByteBuffer> buffers, String delimiter) {
        if (this.cachedIndex != null) {
            if (this.cachedIndex.getDelimiter().equals(delimiter)) {
                return PARSER.find(buffers, this.cachedIndex);
            }
            this.cachedIndex = null;
        }
        return PARSER.find(buffers, delimiter);
    }

    protected final byte[] extractBytesFromReadQueue(int length) throws BufferUnderflowException {
        this.resetCachedIndex();
        return this.readQueue.read(length);
    }

    protected final int extractIntFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        if (this.readQueue.getFirstBufferSize() >= 4) {
            ByteBuffer buf = this.readQueue.removeFirst();
            assert (buf != null);
            int i = buf.getInt();
            this.readQueue.addFirst(buf.slice());
            return i;
        }
        return ByteBuffer.wrap(this.readQueue.read(4)).getInt();
    }

    protected final byte extractByteFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        if (this.readQueue.getFirstBufferSize() >= 1) {
            ByteBuffer buf = this.readQueue.removeFirst();
            assert (buf != null);
            byte b = buf.get();
            this.readQueue.addFirst(buf.slice());
            return b;
        }
        throw new BufferUnderflowException();
    }

    protected final double extractDoubleFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        if (this.readQueue.getFirstBufferSize() >= 8) {
            ByteBuffer buf = this.readQueue.removeFirst();
            assert (buf != null);
            double d = buf.getDouble();
            this.readQueue.addFirst(buf.slice());
            return d;
        }
        return ByteBuffer.wrap(this.readQueue.read(8)).getDouble();
    }

    protected final long extractLongFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        if (this.readQueue.getFirstBufferSize() >= 8) {
            ByteBuffer buf = this.readQueue.removeFirst();
            assert (buf != null);
            long l = buf.getLong();
            this.readQueue.addFirst(buf.slice());
            return l;
        }
        return ByteBuffer.wrap(this.readQueue.read(8)).getLong();
    }

    private void resetCachedIndex() {
        this.cachedIndex = null;
    }

    @Override
    public String toCompactString() {
        return "id=" + this.getId() + ", caller=" + this.getRemoteAddress().getCanonicalHostName() + "(" + this.getRemoteAddress() + ":" + this.getRemotePort() + ")";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.toCompactString());
        return sb.toString();
    }
}

