/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.Resource;
import org.xsocket.stream.IConnectHandler;
import org.xsocket.stream.IConnectionScoped;
import org.xsocket.stream.IDataHandler;
import org.xsocket.stream.IDisconnectHandler;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.IHandlerServerContext;
import org.xsocket.stream.ILifeCycle;
import org.xsocket.stream.INonBlockingConnection;
import org.xsocket.stream.ITimeoutHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HandlerChain
implements IConnectHandler,
IDisconnectHandler,
IDataHandler,
ITimeoutHandler,
IConnectionScoped,
ILifeCycle {
    private static final Logger LOG = Logger.getLogger(HandlerChain.class.getName());
    private IHandler[] handlers = new IHandler[0];
    private Integer[] connectionScopedIndex = new Integer[0];
    private Integer[] connectHandlerChain = new Integer[0];
    private Integer[] disconnectHandlerChain = new Integer[0];
    private Integer[] dataHandlerChain = new Integer[0];
    private Integer[] timeoutHandlerChain = new Integer[0];
    private Integer[] lifeCycleChain = new Integer[0];
    private List<HandlerChain> enclosingChains = new ArrayList<HandlerChain>();
    @Resource
    private IHandlerServerContext ctx = null;

    public HandlerChain() {
    }

    public HandlerChain(List<IHandler> handlers) {
        for (IHandler hdl : handlers) {
            this.addLast(hdl);
        }
    }

    public void addLast(IHandler handler) {
        int pos = this.handlers.length;
        this.handlers = HandlerChain.incArray(this.handlers, handler);
        if (handler instanceof IConnectHandler) {
            this.connectHandlerChain = HandlerChain.incArray(this.connectHandlerChain, pos);
        }
        if (handler instanceof IDisconnectHandler) {
            this.disconnectHandlerChain = HandlerChain.incArray(this.disconnectHandlerChain, pos);
        }
        if (handler instanceof IDataHandler) {
            this.dataHandlerChain = HandlerChain.incArray(this.dataHandlerChain, pos);
        }
        if (handler instanceof ITimeoutHandler) {
            this.timeoutHandlerChain = HandlerChain.incArray(this.timeoutHandlerChain, pos);
        }
        if (handler instanceof ILifeCycle) {
            this.lifeCycleChain = HandlerChain.incArray(this.lifeCycleChain, pos);
        }
        if (handler instanceof HandlerChain) {
            ((HandlerChain)handler).addEnclosingChain(this);
        }
        if (handler instanceof IConnectionScoped) {
            this.updateScope(pos, true);
        } else {
            this.updateScope(pos, false);
        }
    }

    private void addEnclosingChain(HandlerChain enclosingChain) {
        if (this.enclosingChains == null) {
            this.enclosingChains = new ArrayList<HandlerChain>();
        }
        this.enclosingChains.add(enclosingChain);
    }

    private void updateScope(IHandler handler, boolean isConnectionScoped) {
        for (int i = 0; i < this.handlers.length; ++i) {
            if (this.handlers[i] != handler) continue;
            this.updateScope(i, isConnectionScoped);
            return;
        }
    }

    private void updateScope(int pos, boolean isConnectionScoped) {
        if (isConnectionScoped) {
            this.connectionScopedIndex = HandlerChain.incArray(this.connectionScopedIndex, pos);
            if (this.enclosingChains != null) {
                for (HandlerChain chain : this.enclosingChains) {
                    chain.updateScope(this, true);
                }
            }
        }
    }

    @Override
    public void onInit() {
        for (IHandler handler : this.handlers) {
            Field[] fields;
            for (Field field : fields = handler.getClass().getDeclaredFields()) {
                if (field.getAnnotation(Resource.class) == null) continue;
                field.setAccessible(true);
                try {
                    field.set(handler, this.ctx);
                }
                catch (IllegalAccessException iae) {
                    LOG.warning("couldn't set HandlerContext for attribute " + field.getName() + ". Reason " + iae.toString());
                }
            }
        }
        for (Integer pos : this.lifeCycleChain) {
            ((ILifeCycle)this.handlers[pos]).onInit();
        }
    }

    @Override
    public void onDestroy() {
        for (Integer pos : this.lifeCycleChain) {
            ((ILifeCycle)this.handlers[pos]).onDestroy();
        }
    }

    @Override
    public boolean onConnect(INonBlockingConnection connection) throws IOException {
        for (Integer pos : this.connectHandlerChain) {
            boolean result = ((IConnectHandler)this.handlers[pos]).onConnect(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onDisconnect(String connectionId) throws IOException {
        for (Integer pos : this.disconnectHandlerChain) {
            boolean result = ((IDisconnectHandler)this.handlers[pos]).onDisconnect(connectionId);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onData(INonBlockingConnection connection) throws IOException {
        for (Integer pos : this.dataHandlerChain) {
            boolean result = ((IDataHandler)this.handlers[pos]).onData(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
        for (Integer pos : this.timeoutHandlerChain) {
            boolean result = ((ITimeoutHandler)this.handlers[pos]).onConnectionTimeout(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
        for (Integer pos : this.timeoutHandlerChain) {
            boolean result = ((ITimeoutHandler)this.handlers[pos]).onIdleTimeout(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    IHandler getHandler(int pos) {
        return this.handlers[pos];
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this.connectionScopedIndex.length > 0) {
            HandlerChain clone = (HandlerChain)super.clone();
            clone.handlers = (IHandler[])this.handlers.clone();
            for (int i = 0; i < this.connectionScopedIndex.length; ++i) {
                int position = this.connectionScopedIndex[i];
                clone.handlers[position] = (IHandler)((IConnectionScoped)((Object)this.handlers[position])).clone();
            }
            return clone;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(this.getClass().getSimpleName() + " doesn't contain connection-specific handlers. return current instance as clone");
        }
        return this;
    }

    private static <T> T[] incArray(T[] original, T newElement) {
        T[] newArray = HandlerChain.copyOf(original, original.length + 1, original.getClass());
        newArray[original.length] = newElement;
        return newArray;
    }

    private static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

