/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.stream.ByteBufferQueue;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.IoHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSSLHandler
extends IoHandler {
    private static final Logger LOG = Logger.getLogger(IoSSLHandler.class.getName());
    private final ByteBufferQueue writeQueue = new ByteBufferQueue();
    private final ByteBufferQueue receiveQueue = new ByteBufferQueue();
    private IoHandler.IIOEventHandler ioEventHandler = null;
    private boolean isStarted = false;
    private boolean isConnected = false;
    private SSLProcessor sslProcessor = null;
    private SSLContext sslContext = null;
    private boolean startSSL = false;
    private boolean isClientMode = false;
    private IMemoryManager memoryManager = null;

    IoSSLHandler(IoHandler successor, SSLContext sslContext, boolean startSSL, boolean isClientMode, IMemoryManager memoryManager) throws IOException {
        super(successor);
        this.memoryManager = memoryManager;
        this.sslContext = sslContext;
        this.startSSL = startSSL;
        this.isClientMode = isClientMode;
        this.sslProcessor = new SSLProcessor();
        this.setIOEventHandler(successor.getIOEventHandler());
    }

    @Override
    void open() throws IOException {
        if (this.startSSL & !this.isClientMode) {
            this.startSSL();
        }
        this.getSuccessor().open();
        if (this.startSSL & this.isClientMode) {
            this.startSSL();
        }
    }

    void startSSL() throws IOException {
        if (!this.isStarted) {
            this.isStarted = true;
            this.sslProcessor.start();
        }
    }

    @Override
    String getId() {
        return this.getSuccessor().getId();
    }

    @Override
    InetAddress getLocalAddress() {
        return this.getSuccessor().getLocalAddress();
    }

    @Override
    int getLocalPort() {
        return this.getSuccessor().getLocalPort();
    }

    @Override
    InetAddress getRemoteAddress() {
        return this.getSuccessor().getRemoteAddress();
    }

    @Override
    int getRemotePort() {
        return this.getSuccessor().getRemotePort();
    }

    @Override
    boolean isOpen() {
        return this.getSuccessor().isOpen();
    }

    @Override
    void setIOEventHandler(IoHandler.IIOEventHandler ioEventHandler) {
        this.ioEventHandler = ioEventHandler;
        this.getSuccessor().setIOEventHandler(new IOEventHandler());
    }

    @Override
    IoHandler.IIOEventHandler getIOEventHandler() {
        return this.ioEventHandler;
    }

    @Override
    LinkedList<ByteBuffer> drainIncoming() {
        if (this.isStarted) {
            return this.receiveQueue.drain();
        }
        return this.getSuccessor().drainIncoming();
    }

    @Override
    void close() throws IOException {
        this.getSuccessor().close();
    }

    @Override
    void writeOutgoing(ByteBuffer buffer) throws ClosedConnectionException, IOException {
        if (this.isStarted) {
            LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
            buffers.add(buffer);
            this.writeOutgoing(buffers);
        } else {
            this.getSuccessor().writeOutgoing(buffer);
        }
    }

    @Override
    void writeOutgoing(LinkedList<ByteBuffer> buffers) throws ClosedConnectionException, IOException {
        if (this.isStarted) {
            if (this.sslProcessor.isHandshaking()) {
                this.writeQueue.append(buffers);
            } else {
                this.sslProcessor.write(buffers);
            }
        } else {
            this.getSuccessor().writeOutgoing(buffers);
        }
    }

    @Override
    void flushOutgoing() {
        this.getSuccessor().flushOutgoing();
    }

    private void readIncoming() throws ClosedConnectionException, IOException {
        if (this.isStarted) {
            LinkedList<ByteBuffer> buffers = this.getSuccessor().drainIncoming();
            if (buffers != null) {
                this.sslProcessor.readIncoming(buffers);
            }
        } else {
            this.ioEventHandler.onDataEvent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SSLProcessor {
        private SSLEngine sslEngine = null;
        private int minPacketBufferSize = 0;
        private int minAppBufferSize = 0;

        SSLProcessor() {
            this.sslEngine = IoSSLHandler.this.sslContext.createSSLEngine();
            this.minAppBufferSize = this.sslEngine.getSession().getApplicationBufferSize();
            this.minPacketBufferSize = this.sslEngine.getSession().getPacketBufferSize();
            this.sslEngine.setUseClientMode(IoSSLHandler.this.isClientMode);
        }

        void start() throws IOException {
            try {
                this.sslEngine.beginHandshake();
            }
            catch (SSLException sslEx) {
                throw new RuntimeException(sslEx);
            }
            if (IoSSLHandler.this.isClientMode) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + IoSSLHandler.this.getId() + "] initate ssl handshake");
                }
                this.write();
            }
        }

        final void destroy() {
            this.sslEngine.closeOutbound();
        }

        final void readIncoming(LinkedList<ByteBuffer> buffers) throws IOException, ClosedConnectionException {
            this.read(buffers);
            if (this.needWrap()) {
                this.write();
            }
        }

        final void read(LinkedList<ByteBuffer> inNetBufferList) throws IOException, ClosedConnectionException {
            for (ByteBuffer inNetBuffer : inNetBufferList) {
                LinkedList<ByteBuffer> inAppDataList = this.unwrap(inNetBuffer);
                boolean appData = false;
                for (ByteBuffer inAppData : inAppDataList) {
                    if (inAppData.remaining() <= 0) continue;
                    appData = true;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + IoSSLHandler.this.getId() + "] ssl -> data (data size " + inAppData.remaining() + "), data:" + DataConverter.toString(new ByteBuffer[]{inAppData.duplicate()}, "UTF-8", 500));
                    }
                    if (this.isHandshaking()) continue;
                    IoSSLHandler.this.receiveQueue.append(inAppData);
                }
                if (!LOG.isLoggable(Level.FINE) || appData) continue;
                LOG.fine("received ssl system packet");
            }
            if (!IoSSLHandler.this.receiveQueue.isEmpty()) {
                IoSSLHandler.this.ioEventHandler.onDataEvent();
            }
        }

        final void write(LinkedList<ByteBuffer> buffers) throws ClosedConnectionException, IOException {
            for (ByteBuffer outAppData : buffers) {
                LinkedList<ByteBuffer> outNetDataList;
                if (LOG.isLoggable(Level.FINE) && outAppData.remaining() > 0) {
                    LOG.fine("data -> ssl (data size " + outAppData.remaining() + "), data: " + DataConverter.toString(new ByteBuffer[]{outAppData.duplicate()}, "UTF-8", 500));
                }
                if ((outNetDataList = this.wrap(outAppData)).size() <= 0) continue;
                IoSSLHandler.this.getSuccessor().writeOutgoing(outNetDataList);
            }
        }

        final void write() throws ClosedConnectionException, IOException {
            ByteBuffer outAppData;
            LinkedList<ByteBuffer> outNetDataList;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + IoSSLHandler.this.getId() + "] send ssl system packet");
            }
            if ((outNetDataList = this.wrap(outAppData = ByteBuffer.allocate(0))).size() > 0) {
                IoSSLHandler.this.getSuccessor().writeOutgoing(outNetDataList);
            }
        }

        final boolean needWrap() {
            return this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }

        final boolean needUnwrap() {
            return this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }

        final boolean isHandshaking() {
            return this.sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }

        final LinkedList<ByteBuffer> unwrap(ByteBuffer inNetData) throws SSLException, ClosedConnectionException, IOException {
            LinkedList<ByteBuffer> inAppDataList = new LinkedList<ByteBuffer>();
            boolean repeat = false;
            int minSize = this.minAppBufferSize;
            try {
                do {
                    repeat = false;
                    SSLEngineResult engineResult = null;
                    ByteBuffer inAppData = IoSSLHandler.this.memoryManager.acquireMemory(minSize);
                    engineResult = this.sslEngine.unwrap(inNetData, inAppData);
                    if (engineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + IoSSLHandler.this.getId() + "] BUFFER_UNDERFLOW within unwrap shouldn't occur");
                        }
                    } else {
                        if (engineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                            IoSSLHandler.this.memoryManager.recycleMemory(inAppData);
                            repeat = true;
                            minSize += minSize;
                            continue;
                        }
                        if (engineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                            IoSSLHandler.this.memoryManager.recycleMemory(inAppData);
                            ClosedConnectionException cce = new ClosedConnectionException("Couldn't unwrap, because connection is closed");
                            throw cce;
                        }
                        if (engineResult.getStatus() == SSLEngineResult.Status.OK) {
                            if (inNetData.position() < inNetData.limit()) {
                                inNetData = inNetData.slice();
                            }
                            inAppData.flip();
                            inAppData = this.extractAndRecycleMemory(inAppData);
                            if (inAppData.remaining() > 0) {
                                inAppDataList.add(inAppData);
                            }
                        }
                    }
                    if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        Runnable task = null;
                        while ((task = this.sslEngine.getDelegatedTask()) != null) {
                            task.run();
                        }
                    }
                    if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && inNetData.hasRemaining()) {
                        repeat = true;
                    }
                    if (engineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + IoSSLHandler.this.getId() + "] handshake finished");
                    }
                    if (!IoSSLHandler.this.writeQueue.isEmpty()) {
                        LinkedList<ByteBuffer> buffers = IoSSLHandler.this.writeQueue.drain();
                        IoSSLHandler.this.writeOutgoing(buffers);
                    }
                    if (IoSSLHandler.this.isConnected) continue;
                    IoSSLHandler.this.isConnected = true;
                    if (!IoSSLHandler.this.ioEventHandler.listenForConnect()) continue;
                    IoSSLHandler.this.ioEventHandler.onConnectEvent();
                } while (repeat);
            }
            catch (SSLException ssles) {
                ssles.printStackTrace();
                throw ssles;
            }
            return inAppDataList;
        }

        private ByteBuffer extractAndRecycleMemory(ByteBuffer buffer) {
            if (buffer.limit() == buffer.capacity()) {
                return buffer;
            }
            int savedLimit = buffer.limit();
            ByteBuffer slicedPart = buffer.slice();
            buffer.position(savedLimit);
            buffer.limit(buffer.capacity());
            ByteBuffer unused = buffer.slice();
            IoSSLHandler.this.memoryManager.recycleMemory(unused);
            return slicedPart;
        }

        final LinkedList<ByteBuffer> wrap(ByteBuffer outAppData) throws SSLException, ClosedConnectionException, IOException {
            LinkedList<ByteBuffer> outNetDataList = new LinkedList<ByteBuffer>();
            boolean repeat = false;
            int minSize = this.minPacketBufferSize;
            do {
                repeat = false;
                SSLEngineResult engineResult = null;
                ByteBuffer outNetData = IoSSLHandler.this.memoryManager.acquireMemory(minSize);
                engineResult = this.sslEngine.wrap(outAppData, outNetData);
                if (engineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    IoSSLHandler.this.memoryManager.recycleMemory(outNetData);
                    repeat = true;
                    minSize += minSize;
                    continue;
                }
                if (engineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                    IoSSLHandler.this.memoryManager.recycleMemory(outNetData);
                    ClosedConnectionException cce = new ClosedConnectionException("Couldn't unwrap, because connection is closed");
                    throw cce;
                }
                if (engineResult.getStatus() == SSLEngineResult.Status.OK) {
                    if (outAppData.position() < outAppData.limit()) {
                        outAppData = outAppData.slice();
                    }
                    outNetData.flip();
                    outNetData = this.extractAndRecycleMemory(outNetData);
                    outNetDataList.add(outNetData);
                }
                if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    Runnable task = null;
                    while ((task = this.sslEngine.getDelegatedTask()) != null) {
                        task.run();
                    }
                }
                if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    repeat = true;
                }
                if (engineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + IoSSLHandler.this.getId() + "] handshake finished");
                }
                if (!IoSSLHandler.this.writeQueue.isEmpty()) {
                    LinkedList<ByteBuffer> buffers = IoSSLHandler.this.writeQueue.drain();
                    IoSSLHandler.this.writeOutgoing(buffers);
                }
                if (IoSSLHandler.this.isConnected) break;
                IoSSLHandler.this.isConnected = true;
                if (!IoSSLHandler.this.ioEventHandler.listenForConnect()) break;
                IoSSLHandler.this.ioEventHandler.onConnectEvent();
                break;
            } while (repeat);
            return outNetDataList;
        }
    }

    private final class IOEventHandler
    implements IoHandler.IIOEventHandler {
        private IOEventHandler() {
        }

        public boolean listenForData() {
            return IoSSLHandler.this.ioEventHandler.listenForData();
        }

        public void onDataEvent() {
            block2: {
                try {
                    IoSSLHandler.this.readIncoming();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("[" + IoSSLHandler.this.getId() + "] error occured while receiving data. Reason: " + e.toString());
                }
            }
        }

        public boolean listenForConnect() {
            return false;
        }

        public void onConnectEvent() {
        }

        public boolean listenForDisconnect() {
            return IoSSLHandler.this.ioEventHandler.listenForDisconnect();
        }

        public void onDisconnectEvent() {
            IoSSLHandler.this.sslProcessor.destroy();
            IoSSLHandler.this.ioEventHandler.onDisconnectEvent();
        }

        public void onConnectionTimeout() {
            IoSSLHandler.this.ioEventHandler.onConnectionTimeout();
        }

        public void onIdleTimeout() {
            IoSSLHandler.this.ioEventHandler.onIdleTimeout();
        }
    }
}

