/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.Dispatcher;
import org.xsocket.IEventHandler;
import org.xsocket.IHandle;
import org.xsocket.WorkerPool;
import org.xsocket.stream.ByteBufferQueue;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.IoHandler;
import org.xsocket.stream.MemoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSocketHandler
extends IoHandler
implements IHandle {
    private static final Logger LOG = Logger.getLogger(IoSocketHandler.class.getName());
    private static final int DEFAULT_MEMORY_PREALLOCATION_SIZE = 65536;
    private static IMemoryManager defaultMemoryManager = null;
    private static Dispatcher<IoSocketHandler> defaultDispatcher = null;
    public static final int DEFAULT_READ_MEMORY_MIN_SIZE = 128;
    private boolean isLogicalOpen = true;
    private boolean isDisconnectNotified = false;
    private SocketChannel channel = null;
    private Dispatcher dispatcher = null;
    private IoHandler.IIOEventHandler ioEventHandler = null;
    private final ByteBufferQueue sendQueue = new ByteBufferQueue();
    private final ByteBufferQueue receiveQueue = new ByteBufferQueue();
    private WorkerPool workerPool = null;
    private IMemoryManager memoryManager = null;
    private String id = null;
    private static long nextId = 0L;
    private static String idPrefix = null;
    private long openTime = -1L;
    private long lastTimeReceived = System.currentTimeMillis();
    private long receivedBytes = 0L;
    private long sendBytes = 0L;

    IoSocketHandler(SocketChannel channel, String idLocalPrefix, IMemoryManager memoryManager, Dispatcher<IoSocketHandler> dispatcher, WorkerPool workerPool) throws IOException {
        super(null);
        assert (channel != null);
        this.channel = channel;
        this.openTime = System.currentTimeMillis();
        this.memoryManager = memoryManager != null ? memoryManager : IoSocketHandler.getDefaultMemoryManager();
        this.dispatcher = dispatcher != null ? dispatcher : IoSocketHandler.getDefaultDispatcher();
        this.workerPool = workerPool;
        channel.configureBlocking(false);
        this.id = idPrefix + "." + idLocalPrefix + this.nextLocalId();
    }

    @Override
    void open() throws IOException {
        assert (this.ioEventHandler != null) : "ioHandler hasn't been set";
        this.dispatcher.register(this);
    }

    IMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    void setIOEventHandler(IoHandler.IIOEventHandler ioEventHandler) {
        this.ioEventHandler = ioEventHandler;
    }

    @Override
    IoHandler.IIOEventHandler getIOEventHandler() {
        return this.ioEventHandler;
    }

    private synchronized long nextLocalId() {
        if (++nextId < 0L) {
            nextId = 1L;
        }
        return nextId;
    }

    @Override
    final String getId() {
        return this.id;
    }

    boolean checkIdleTimeout(Long current, long timeout) {
        boolean timeoutReached;
        boolean bl = timeoutReached = this.lastTimeReceived + timeout < current;
        if (timeoutReached) {
            this.ioEventHandler.onIdleTimeout();
        }
        return timeoutReached;
    }

    boolean checkConnectionTimeout(Long current, long timeout) {
        boolean timeoutReached;
        boolean bl = timeoutReached = this.openTime + timeout < current;
        if (timeoutReached) {
            this.ioEventHandler.onConnectionTimeout();
        }
        return timeoutReached;
    }

    int getIncomingQueueSize() {
        return this.receiveQueue.getSize();
    }

    @Override
    void writeOutgoing(ByteBuffer buffer) {
        if (buffer != null) {
            this.sendQueue.append(buffer);
            this.dispatcher.announceWriteNeed(this);
        }
    }

    @Override
    void writeOutgoing(LinkedList<ByteBuffer> buffers) {
        if (buffers != null) {
            this.sendQueue.append(buffers);
            this.dispatcher.announceWriteNeed(this);
        }
    }

    @Override
    LinkedList<ByteBuffer> drainIncoming() {
        return this.receiveQueue.drain();
    }

    @Override
    void close() throws IOException {
        this.isLogicalOpen = false;
        this.dispatcher.announceWriteNeed(this);
    }

    @Override
    boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public SelectableChannel getChannel() {
        return this.channel;
    }

    protected final int readSocketIntoReceiveQueue() throws IOException {
        int read = 0;
        this.lastTimeReceived = System.currentTimeMillis();
        if (this.isOpen()) {
            ByteBuffer readBuffer = this.memoryManager.acquireMemory(128);
            int pos = readBuffer.position();
            int limit = readBuffer.limit();
            try {
                read = this.channel.read(readBuffer);
            }
            catch (IOException ioe) {
                readBuffer.position(pos);
                readBuffer.limit(limit);
                this.memoryManager.recycleMemory(readBuffer);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured while reading channel: " + ioe.toString());
                }
                throw ioe;
            }
            switch (read) {
                case -1: {
                    this.memoryManager.recycleMemory(readBuffer);
                    ClosedConnectionException cce = new ClosedConnectionException("[" + this.id + "] End of stream reached");
                    throw cce;
                }
                case 0: {
                    this.memoryManager.recycleMemory(readBuffer);
                    break;
                }
                default: {
                    int savePos = readBuffer.position();
                    int saveLimit = readBuffer.limit();
                    readBuffer.position(savePos - read);
                    readBuffer.limit(savePos);
                    ByteBuffer readData = readBuffer.slice();
                    this.receiveQueue.append(readData);
                    if (readBuffer.hasRemaining()) {
                        readBuffer.position(savePos);
                        readBuffer.limit(saveLimit);
                        this.memoryManager.recycleMemory(readBuffer);
                    }
                    if (!LOG.isLoggable(Level.FINE)) break;
                    LOG.fine("[" + this.getId() + "] received (" + (readData.limit() - readData.position()) + " bytes): " + DataConverter.toTextOrHexString(new ByteBuffer[]{readData.duplicate()}, "UTF-8", 500));
                }
            }
        }
        this.receivedBytes += (long)read;
        return read;
    }

    protected final void writeSendQueueDataToSocket() throws IOException {
        if (this.isOpen() && !this.sendQueue.isEmpty()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] sending: " + this.sendQueue.toString());
            }
            LinkedList<ByteBuffer> data = this.sendQueue.drain();
            this.sendBytes += this.channel.write(data.toArray(new ByteBuffer[data.size()]));
            ListIterator<ByteBuffer> it = data.listIterator(data.size());
            while (it.hasPrevious()) {
                ByteBuffer buf = it.previous();
                if (!buf.hasRemaining()) continue;
                this.sendQueue.addFirst(buf);
            }
            if (!this.sendQueue.isEmpty()) {
                this.dispatcher.announceWriteNeed(this);
            }
        }
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.channel.socket().getLocalAddress();
    }

    @Override
    public final int getLocalPort() {
        return this.channel.socket().getLocalPort();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.channel.socket().getInetAddress();
    }

    @Override
    public final int getRemotePort() {
        return this.channel.socket().getPort();
    }

    @Override
    void flushOutgoing() {
    }

    static Dispatcher<IoSocketHandler> createDispatcher(String disptacherName) {
        return new Dispatcher<IoSocketHandler>(disptacherName, new DispatcherEventHandler());
    }

    private static Dispatcher<IoSocketHandler> getDefaultDispatcher() {
        if (defaultDispatcher == null) {
            defaultDispatcher = IoSocketHandler.createDispatcher("default");
            new Thread(defaultDispatcher).start();
        }
        return defaultDispatcher;
    }

    private static IMemoryManager getDefaultMemoryManager() {
        if (defaultMemoryManager == null) {
            defaultMemoryManager = new MemoryManager(65536, true);
        }
        return defaultMemoryManager;
    }

    public String toString() {
        return this.channel.socket().getInetAddress().toString() + ":" + this.channel.socket().getPort() + " received=" + DataConverter.toFormatedBytesSize(this.receivedBytes) + ", sent=" + DataConverter.toFormatedBytesSize(this.sendBytes) + ", age=" + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.openTime) + ", lastReceived=" + DataConverter.toFormatedDate(this.lastTimeReceived) + " [" + this.id + "]";
    }

    static {
        String base = null;
        try {
            base = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            base = "locale";
        }
        int random = 0;
        while ((random = new Random().nextInt()) < 0) {
        }
        idPrefix = Integer.toHexString(base.hashCode()) + "." + Long.toHexString(System.currentTimeMillis()) + "." + Integer.toHexString(random);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DispatcherEventHandler
    implements IEventHandler<IoSocketHandler> {
        private DispatcherEventHandler() {
        }

        @Override
        public void onHandleReadableEvent(final IoSocketHandler socketIOHandler) throws IOException {
            try {
                socketIOHandler.readSocketIntoReceiveQueue();
                if (socketIOHandler.ioEventHandler.listenForData() && !socketIOHandler.receiveQueue.isEmpty()) {
                    socketIOHandler.workerPool.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            IoSocketHandler ioSocketHandler = socketIOHandler;
                            synchronized (ioSocketHandler) {
                                if (socketIOHandler.receiveQueue.getSize() > 0) {
                                    socketIOHandler.ioEventHandler.onDataEvent();
                                }
                            }
                        }
                    });
                }
            }
            catch (Throwable t) {
                socketIOHandler.close();
            }
        }

        @Override
        public void onHandleWriteableEvent(final IoSocketHandler socketIOHandler) throws IOException {
            socketIOHandler.writeSendQueueDataToSocket();
            if (!socketIOHandler.isLogicalOpen) {
                if (socketIOHandler.sendQueue.isEmpty()) {
                    block5: {
                        try {
                            socketIOHandler.dispatcher.deregister(socketIOHandler);
                            socketIOHandler.channel.close();
                        }
                        catch (Exception e) {
                            if (!LOG.isLoggable(Level.FINE)) break block5;
                            LOG.fine("error occured by closing connection. reason: " + e.toString());
                        }
                    }
                    socketIOHandler.workerPool.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            IoSocketHandler ioSocketHandler = socketIOHandler;
                            synchronized (ioSocketHandler) {
                                if (socketIOHandler.ioEventHandler.listenForDisconnect() & !socketIOHandler.isDisconnectNotified) {
                                    socketIOHandler.isDisconnectNotified = true;
                                    socketIOHandler.ioEventHandler.onDisconnectEvent();
                                }
                            }
                        }
                    });
                } else {
                    socketIOHandler.dispatcher.announceWriteNeed(socketIOHandler);
                }
            }
        }

        @Override
        public void onDispatcherCloseEvent(final IoSocketHandler socketIOHandler) {
            socketIOHandler.workerPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    IoSocketHandler ioSocketHandler = socketIOHandler;
                    synchronized (ioSocketHandler) {
                        try {
                            socketIOHandler.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }

        @Override
        public void onHandleRegisterEvent(final IoSocketHandler socketIOHandler) throws IOException {
            if (socketIOHandler.ioEventHandler.listenForConnect()) {
                socketIOHandler.workerPool.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        IoSocketHandler ioSocketHandler = socketIOHandler;
                        synchronized (ioSocketHandler) {
                            socketIOHandler.ioEventHandler.onConnectEvent();
                        }
                    }
                });
            }
        }
    }
}

