/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.Resource;
import org.xsocket.WorkerPool;
import org.xsocket.stream.Acceptor;
import org.xsocket.stream.IConnectHandler;
import org.xsocket.stream.IConnectionScoped;
import org.xsocket.stream.IDataHandler;
import org.xsocket.stream.IDisconnectHandler;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.IHandlerServerContext;
import org.xsocket.stream.ILifeCycle;
import org.xsocket.stream.IMultithreadedServer;
import org.xsocket.stream.ITimeoutHandler;
import org.xsocket.stream.MultithreadedServerMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultithreadedServer
implements IMultithreadedServer,
MultithreadedServerMBean {
    private static final Logger LOG = Logger.getLogger(MultithreadedServer.class.getName());
    private boolean isRunning = true;
    private int port = 0;
    private InetAddress localAddress = null;
    private IHandler appHandler = null;
    private boolean isLifeCycleHandler = false;
    private boolean isConnectionScoped = false;
    private boolean isConnectHandler = false;
    private boolean isDisconnectHandler = false;
    private boolean isDataHandler = false;
    private boolean isTimeoutHandler = false;
    private WorkerPool workerPool = new WorkerPool();
    private Acceptor acceptor = null;
    private String hostname = null;
    private String appDomain = null;
    private ObjectName mbeanName = null;

    public MultithreadedServer(IHandler handler) throws UnknownHostException, IOException {
        this(0, handler);
    }

    public MultithreadedServer(int port, IHandler handler) throws UnknownHostException, IOException {
        this(port, handler, "xsocket.tcp", false, null);
    }

    public MultithreadedServer(IHandler handler, String applicationDomain) throws UnknownHostException, IOException {
        this(0, handler, applicationDomain, false, null);
    }

    public MultithreadedServer(int port, IHandler handler, String applicationDomain) throws UnknownHostException, IOException {
        this(port, handler, applicationDomain, false, null);
    }

    public MultithreadedServer(int port, IHandler handler, String applicationDomain, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this.localAddress = InetAddress.getLocalHost();
        this.setWorkerPoolSize(Runtime.getRuntime().availableProcessors() * 10);
        this.acceptor = new Acceptor(port, this.workerPool, sslContext, sslOn, Integer.toString(port));
        this.port = this.acceptor.getLocalePort();
        this.hostname = this.localAddress.getCanonicalHostName() + "." + this.port;
        this.appDomain = applicationDomain + "." + this.port;
        this.acceptor.setAppDomain(this.appDomain);
        this.setDispatcherPoolSize(Runtime.getRuntime().availableProcessors() + 1);
        this.setConnectionTimeoutSec(Integer.MAX_VALUE);
        this.setIdleTimeoutSec(3600);
        if (handler != null) {
            this.setHandler(handler);
        }
    }

    WorkerPool getWorkerPool() {
        return this.workerPool;
    }

    @Override
    public final void shutdown() {
        if (this.isRunning) {
            this.isRunning = false;
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.mbeanName);
            }
            catch (Exception mbe) {
                LOG.warning("error " + mbe.toString() + " occured while unregistering mbean");
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.fine("close acceptor");
            }
            this.acceptor.shutdown();
            this.workerPool.stopPooling();
            this.destroyCurrentHandler();
        }
    }

    @Override
    public final void run() {
        if (this.appHandler == null) {
            LOG.warning("no handler has been set. Call setHandler-method to set an assigned handler");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                MultithreadedServer.this.shutdown();
            }
        });
        try {
            StandardMBean mbean = new StandardMBean(this, MultithreadedServerMBean.class);
            this.mbeanName = new ObjectName(this.appDomain + ":type=MultithreadedServer,name=" + this.hostname);
            ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, this.mbeanName);
        }
        catch (Exception mbe) {
            LOG.warning("error " + mbe.toString() + " occured while registering mbean");
        }
        LOG.info("server " + this.appDomain + " listening on port " + this.port + " (" + this.getVersionInfo() + ")");
        LOG.fine("dispatcherPoolSize=" + this.getDispatcherPoolSize() + " workerPoolsize=" + this.getWorkerPoolSize());
        LOG.fine("preallocationSize=" + this.getReceiveBufferPreallocationSize());
        LOG.fine("connectionTimeout=" + DataConverter.toFormatedDuration(this.acceptor.getConnectionTimeout()) + "; idleTimeout=" + DataConverter.toFormatedDuration(this.acceptor.getIdleTimeout()));
        this.acceptor.run();
    }

    @Override
    public final void setDispatcherPoolSize(int size) {
        this.acceptor.setDispatcherPoolSize(size);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void setHandler(IHandler appHandler) {
        if (appHandler == null) {
            throw new NullPointerException("handler have to be not null");
        }
        this.destroyCurrentHandler();
        this.appHandler = appHandler;
        this.isConnectHandler = appHandler instanceof IConnectHandler;
        this.isDisconnectHandler = appHandler instanceof IDisconnectHandler;
        this.isDataHandler = appHandler instanceof IDataHandler;
        this.isTimeoutHandler = appHandler instanceof ITimeoutHandler;
        this.isConnectionScoped = appHandler instanceof IConnectionScoped;
        this.isLifeCycleHandler = appHandler instanceof ILifeCycle;
        this.initCurrentHandler();
    }

    private void initCurrentHandler() {
        this.injectContext(this.appHandler);
        this.acceptor.setHandler(this.appHandler, this.isConnectionScoped, this.isConnectHandler, this.isDisconnectHandler, this.isDataHandler, this.isTimeoutHandler);
        if (this.isLifeCycleHandler) {
            ((ILifeCycle)this.appHandler).onInit();
        }
    }

    private void injectContext(IHandler hdl) {
        Field[] fields;
        HandlerContext ctx = null;
        for (Field field : fields = hdl.getClass().getDeclaredFields()) {
            if (field.getType() != IHandlerServerContext.class || field.getAnnotation(Resource.class) == null) continue;
            field.setAccessible(true);
            try {
                if (ctx == null) {
                    ctx = new HandlerContext();
                }
                field.set(hdl, ctx);
            }
            catch (IllegalAccessException iae) {
                LOG.warning("couldn't set HandlerContext for attribute " + field.getName() + ". Reason " + iae.toString());
            }
        }
    }

    private void destroyCurrentHandler() {
        if (this.appHandler != null) {
            if (this.isLifeCycleHandler) {
                ((ILifeCycle)this.appHandler).onDestroy();
            }
            this.appHandler = null;
        }
    }

    @Override
    public final int getLocalPort() {
        return this.port;
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public void setWorkerPoolSize(int workerSize) {
        this.workerPool.setSize(workerSize);
    }

    @Override
    public int getWorkerPoolSize() {
        return this.workerPool.getSize();
    }

    @Override
    public final int getReceiveBufferPreallocationSize() {
        return this.acceptor.getReceiveBufferPreallocationSize();
    }

    @Override
    public void setReceiveBufferPreallocationSize(int size) {
        this.acceptor.setReceiveBufferPreallocationSize(size);
    }

    @Override
    public void setConnectionTimeoutSec(int timeoutSec) {
        this.acceptor.setConnectionTimeout((long)timeoutSec * 1000L);
    }

    @Override
    public void setIdleTimeoutSec(int timeoutInSec) {
        this.acceptor.setIdleTimeout((long)timeoutInSec * 1000L);
    }

    @Override
    public final int getDispatcherPoolSize() {
        return this.acceptor.getDispatcherPoolSize();
    }

    @Override
    public final int getConnectionTimeoutSec() {
        return (int)(this.getConnectionTimeout() / 1000L);
    }

    private long getConnectionTimeout() {
        return this.acceptor.getConnectionTimeout();
    }

    @Override
    public final int getIdleTimeoutSec() {
        return (int)(this.getIdleTimeout() / 1000L);
    }

    private long getIdleTimeout() {
        return this.acceptor.getIdleTimeout();
    }

    @Override
    public int getNumberOfConnectionTimeout() {
        return this.acceptor.getNumberOfConnectionTimeout();
    }

    @Override
    public final int getNumberOfIdleTimeout() {
        return this.acceptor.getNumberOfIdleTimeout();
    }

    @Override
    public final List<String> getOpenConnections() {
        return this.acceptor.getOpenConnections();
    }

    @Override
    public int getNumberOfOpenConnections() {
        return this.acceptor.getNumberOfOpenConnections();
    }

    @Override
    public final long getNumberOfHandledConnections() {
        return this.acceptor.getNumberOfHandledConnections();
    }

    private String getVersionInfo() {
        Package p = Package.getPackage("org.xsocket");
        if (p != null) {
            return p.getSpecificationTitle() + " " + p.getImplementationVersion();
        }
        return "";
    }

    private final class HandlerContext
    implements IHandlerServerContext {
        private HandlerContext() {
        }

        public int getLocalePort() {
            return MultithreadedServer.this.getLocalPort();
        }

        public InetAddress getLocaleAddress() {
            return MultithreadedServer.this.localAddress;
        }

        public String getApplicationDomain() {
            return MultithreadedServer.this.appDomain;
        }
    }
}

