/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.WorkerPool;
import org.xsocket.stream.BlockingConnection;
import org.xsocket.stream.ByteBufferOutputChannel;
import org.xsocket.stream.Connection;
import org.xsocket.stream.IConnectHandler;
import org.xsocket.stream.IDataHandler;
import org.xsocket.stream.IDisconnectHandler;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.INonBlockingConnection;
import org.xsocket.stream.ITimeoutHandler;
import org.xsocket.stream.IoDelayWriteHandler;
import org.xsocket.stream.IoHandler;
import org.xsocket.stream.IoSSLHandler;
import org.xsocket.stream.IoSocketHandler;

public final class NonBlockingConnection
extends Connection
implements INonBlockingConnection {
    private static final Logger LOG = Logger.getLogger(BlockingConnection.class.getName());
    private static WorkerPool defaultWorkerPool = null;
    private IHandler appHandler = null;
    private boolean isConnectHandler = false;
    private boolean isDisconnectHandler = false;
    private boolean isDataHandler = false;
    private boolean isTimeoutHandler = false;

    public NonBlockingConnection(String hostname, int port) throws IOException {
        this(hostname, port, null, false);
    }

    public NonBlockingConnection(String hostname, int port, IDataHandler appHandler, int workerPoolSize) throws IOException {
        this(new IoSocketHandler(SocketChannel.open(new InetSocketAddress(hostname, port)), "c.", null, null, new WorkerPool(workerPoolSize)), null, false, null, true, appHandler, false, false, true, false, true);
    }

    public NonBlockingConnection(String hostname, int port, SSLContext sslContext, boolean startSSL) throws IOException {
        this(new IoSocketHandler(SocketChannel.open(new InetSocketAddress(hostname, port)), "c.", null, null, NonBlockingConnection.getDefaultWorkerPool()), sslContext, startSSL);
    }

    private NonBlockingConnection(IoSocketHandler socketHandler, SSLContext sslContext, boolean startSSL) throws IOException {
        this(socketHandler, sslContext, startSSL, socketHandler.getMemoryManager(), true, null, false, false, true, false, true);
    }

    NonBlockingConnection(IoSocketHandler socketHandler, SSLContext sslContext, boolean startSSL, IMemoryManager sslMemoryManager, boolean isClient, IHandler appHandler, boolean isConnectHandler, boolean isDisconnectHandler, boolean isDataHandler, boolean isTimeoutHandler, boolean autoflush) throws IOException {
        super(autoflush);
        this.appHandler = appHandler;
        this.isConnectHandler = isConnectHandler;
        this.isDataHandler = isDataHandler;
        this.isTimeoutHandler = isTimeoutHandler;
        this.isDisconnectHandler = isDisconnectHandler;
        socketHandler.setIOEventHandler(new IOEventHandler());
        if (sslContext != null) {
            IoSSLHandler sslHandler = new IoSSLHandler(socketHandler, sslContext, startSSL, isClient, sslMemoryManager);
            this.setIOHandler(sslHandler);
            this.open();
        } else {
            this.setIOHandler(socketHandler);
            this.open();
        }
    }

    private static WorkerPool getDefaultWorkerPool() {
        if (defaultWorkerPool == null) {
            defaultWorkerPool = new WorkerPool(1);
        }
        return defaultWorkerPool;
    }

    public void setWriteTransferRate(int bytesPerSecond) throws ClosedConnectionException, IOException {
        IoDelayWriteHandler delayHandler = this.getDelayIOHandler();
        if (bytesPerSecond == Integer.MAX_VALUE) {
            if (delayHandler != null) {
                delayHandler.flushOutgoing();
                IoHandler ioHandler = delayHandler.getSuccessor();
                this.setIOHandler(ioHandler);
            }
        } else {
            if (delayHandler == null) {
                delayHandler = new IoDelayWriteHandler(this.getIOHandler());
                this.setIOHandler(delayHandler);
            }
            delayHandler.setWriteRateSec(bytesPerSecond);
        }
    }

    private IoDelayWriteHandler getDelayIOHandler() {
        IoHandler ioHandler = this.getIOHandler();
        do {
            if (!(ioHandler instanceof IoDelayWriteHandler)) continue;
            return (IoDelayWriteHandler)ioHandler;
        } while ((ioHandler = ioHandler.getSuccessor()) != null);
        return null;
    }

    public int getNumberOfAvailableBytes() {
        return this.getReadQueue().getSize();
    }

    public ByteBuffer[] readAvailable() throws IOException, ClosedConnectionException {
        LinkedList<ByteBuffer> queue = this.extractAvailableFromReadQueue();
        if (queue != null) {
            return queue.toArray(new ByteBuffer[queue.size()]);
        }
        return new ByteBuffer[0];
    }

    public boolean readAvailableByDelimiter(String delimiter, WritableByteChannel outputChannel) throws IOException, ClosedConnectionException {
        return this.extractAvailableFromReadQueue(delimiter, outputChannel);
    }

    public byte readByte() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractByteFromReadQueue();
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, ClosedConnectionException, BufferUnderflowException {
        ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
        this.extractBytesByDelimiterFromReadQueue(delimiter, channel);
        return channel.toByteBufferArray();
    }

    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException {
        ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
        this.extractBytesByLength(length, channel);
        return channel.toByteBufferArray();
    }

    public byte[] readBytesByDelimiter(String delimiter) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return DataConverter.toArray(this.readByteBufferByDelimiter(delimiter));
    }

    public byte[] readBytesByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return DataConverter.toArray(this.readByteBufferByLength(length));
    }

    public double readDouble() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractDoubleFromReadQueue();
    }

    public int readInt() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractIntFromReadQueue();
    }

    public long readLong() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractLongFromReadQueue();
    }

    public String readStringByDelimiter(String delimiter) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByDelimiter(delimiter, this.getDefaultEncoding());
    }

    public String readStringByDelimiter(String delimiter, String encoding) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
        this.extractBytesByDelimiterFromReadQueue(delimiter, channel);
        return DataConverter.toString(channel.toByteBufferArray(), encoding);
    }

    public String readStringByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByLength(length, this.getDefaultEncoding());
    }

    public String readStringByLength(int length, String encoding) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        ByteBufferOutputChannel channel = new ByteBufferOutputChannel();
        this.extractBytesByLength(length, channel);
        return DataConverter.toString(channel.toByteBufferArray(), encoding);
    }

    void onConnectionTimeout() {
        block5: {
            try {
                if (this.isTimeoutHandler) {
                    boolean handled = ((ITimeoutHandler)this.appHandler).onConnectionTimeout(this);
                    this.flush();
                    if (!handled) {
                        this.close();
                    }
                } else {
                    this.close();
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.fine("error occured by handling connection timeout event. Reason: " + e.toString());
            }
        }
    }

    void onIdleTimeout() {
        block5: {
            try {
                if (this.isTimeoutHandler) {
                    boolean handled = ((ITimeoutHandler)this.appHandler).onIdleTimeout(this);
                    this.flush();
                    if (!handled) {
                        this.close();
                    }
                } else {
                    this.close();
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.fine("error occured by handling idle timeout event. Reason: " + e.toString());
            }
        }
    }

    private final class IOEventHandler
    implements IoHandler.IIOEventHandler {
        private IOEventHandler() {
        }

        public boolean listenForData() {
            return NonBlockingConnection.this.isDataHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDataEvent() {
            NonBlockingConnection.this.receive();
            if (NonBlockingConnection.this.isDataHandler) {
                try {
                    ((IDataHandler)NonBlockingConnection.this.appHandler).onData(NonBlockingConnection.this);
                }
                catch (BufferUnderflowException bue) {
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling data. Reason: " + e.toString());
                    }
                }
                finally {
                    try {
                        NonBlockingConnection.this.flush();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        public boolean listenForConnect() {
            return NonBlockingConnection.this.isConnectHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnectEvent() {
            if (NonBlockingConnection.this.isConnectHandler) {
                try {
                    ((IConnectHandler)NonBlockingConnection.this.appHandler).onConnect(NonBlockingConnection.this);
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling connect. Reason: " + e.toString());
                    }
                }
                finally {
                    try {
                        NonBlockingConnection.this.flush();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        public boolean listenForDisconnect() {
            return NonBlockingConnection.this.isDisconnectHandler;
        }

        public void onDisconnectEvent() {
            block3: {
                if (NonBlockingConnection.this.isDisconnectHandler) {
                    try {
                        ((IDisconnectHandler)NonBlockingConnection.this.appHandler).onDisconnect(NonBlockingConnection.this.getId());
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling connect. Reason: " + e.toString());
                    }
                }
            }
        }

        public void onConnectionTimeout() {
            block3: {
                if (NonBlockingConnection.this.isTimeoutHandler) {
                    try {
                        ((ITimeoutHandler)NonBlockingConnection.this.appHandler).onConnectionTimeout(NonBlockingConnection.this);
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling onConnectionTimeout. Reason: " + e.toString());
                    }
                }
            }
        }

        public void onIdleTimeout() {
            block3: {
                if (NonBlockingConnection.this.isTimeoutHandler) {
                    try {
                        ((ITimeoutHandler)NonBlockingConnection.this.appHandler).onIdleTimeout(NonBlockingConnection.this);
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling onIdleTimeout. Reason: " + e.toString());
                    }
                }
            }
        }
    }
}

