/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataConverter {
    private static final SimpleDateFormat DATE = new SimpleDateFormat("MMM.dd HH:mm");
    private static final Map<String, CharsetEncoder> encoders = new HashMap<String, CharsetEncoder>();
    private static final Map<String, CharsetDecoder> decoders = new HashMap<String, CharsetDecoder>();

    public static String toFormatedBytesSize(long bytes) {
        if (bytes > 5000000L) {
            return bytes / 1000000L + " mb";
        }
        if (bytes > 10000L) {
            return bytes / 1000L + " kb";
        }
        return bytes + " bytes";
    }

    public static String toFormatedDate(long time) {
        return DATE.format(new Date(time));
    }

    public static String toFormatedDuration(long duration) {
        if (duration < 5000L) {
            return duration + " millis";
        }
        if (duration < 60000L) {
            return (int)(duration / 1000L) + " sec";
        }
        if (duration < 3600000L) {
            return (int)(duration / 60000L) + " min";
        }
        return (int)(duration / 3600000L) + " h";
    }

    public static ByteBuffer toByteBuffer(String s, String encoding) {
        CharsetEncoder encoder = encoders.get(encoding);
        if (encoder == null) {
            Charset charset = Charset.forName(encoding);
            if (charset != null) {
                encoder = charset.newEncoder();
                encoders.put(encoding, encoder);
                decoders.put(encoding, charset.newDecoder());
            } else {
                return null;
            }
        }
        try {
            return encoder.encode(CharBuffer.wrap(s));
        }
        catch (CharacterCodingException cce) {
            throw new RuntimeException(cce);
        }
    }

    public static String toString(ByteBuffer buffer) throws UnsupportedEncodingException {
        return DataConverter.toString(buffer, "UTF-8");
    }

    public static String toString(ByteBuffer[] buffer) throws UnsupportedEncodingException {
        return DataConverter.toString(buffer, "UTF-8");
    }

    public static String toString(ByteBuffer buffer, String encoding) throws UnsupportedEncodingException {
        try {
            CharsetDecoder decoder = decoders.get(encoding);
            if (decoder == null) {
                Charset charset = Charset.forName(encoding);
                if (charset != null) {
                    decoder = charset.newDecoder();
                    decoders.put(encoding, decoder);
                    encoders.put(encoding, charset.newEncoder());
                } else {
                    throw new UnsupportedEncodingException("charset '" + encoding + "' has not been found");
                }
            }
            return decoder.decode(buffer).toString();
        }
        catch (CharacterCodingException cce) {
            RuntimeException re = new RuntimeException("coding exception for '" + encoding + "' occured: " + cce.toString(), cce);
            throw re;
        }
    }

    public static String toByteString(ByteBuffer buffer) {
        StringBuilder sb = new StringBuilder();
        while (buffer.hasRemaining()) {
            String hex = Integer.toHexString(256 + (buffer.get() & 0xFF)).substring(1);
            sb.append((hex.length() < 2 ? "0" : "") + hex + " ");
        }
        return sb.toString();
    }

    public static String toString(List<ByteBuffer> buffers, String encoding) throws UnsupportedEncodingException {
        return DataConverter.toString(buffers.toArray(new ByteBuffer[buffers.size()]), encoding);
    }

    public static String toString(ByteBuffer[] buffers, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) continue;
            sb.append(DataConverter.toString(buffer, encoding));
        }
        return sb.toString();
    }

    public static String toString(ByteBuffer[] buffers, String encoding, int maxOutSize) {
        String postfix = "";
        int size = 0;
        ArrayList<ByteBuffer> copies = new ArrayList<ByteBuffer>();
        for (ByteBuffer buffer : buffers) {
            ByteBuffer copy = buffer.duplicate();
            if (size + copy.limit() > maxOutSize) {
                copy.limit(maxOutSize - size);
                copies.add(copy);
                postfix = " [output has been cut]";
                break;
            }
            copies.add(copy);
        }
        StringBuilder result = new StringBuilder();
        try {
            for (ByteBuffer buffer : copies) {
                result.append(DataConverter.toString(buffer, encoding));
                buffer.flip();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        result.append(postfix);
        return result.toString();
    }

    public static ByteBuffer toByteBuffer(ByteBuffer[] buffers) {
        byte[] bytes = DataConverter.toBytes(buffers);
        return ByteBuffer.wrap(bytes);
    }

    public static byte[] toBytes(ByteBuffer[] buffers) {
        byte[] result = null;
        if (buffers == null) {
            return null;
        }
        int size = 0;
        for (ByteBuffer buffer : buffers) {
            size += buffer.remaining();
            if (result == null) {
                byte[] bytes = DataConverter.toBytes(buffer);
                if (bytes.length <= 0) continue;
                result = bytes;
                continue;
            }
            byte[] additionalBytes = DataConverter.toBytes(buffer);
            byte[] newResult = new byte[result.length + additionalBytes.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(additionalBytes, 0, newResult, result.length, additionalBytes.length);
            result = newResult;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(ByteBuffer buffer) {
        int savedPos = buffer.position();
        int savedLimit = buffer.limit();
        try {
            byte[] array = new byte[buffer.limit() - buffer.position()];
            if (buffer.hasArray()) {
                int offset = buffer.arrayOffset();
                byte[] bufferArray = buffer.array();
                System.arraycopy(bufferArray, offset, array, 0, array.length);
                byte[] byArray = array;
                return byArray;
            }
            buffer.get(array);
            byte[] byArray = array;
            return byArray;
        }
        finally {
            buffer.position(savedPos);
            buffer.limit(savedLimit);
        }
    }

    public static String toHexString(byte[] buffers, int maxOutSize) {
        return DataConverter.toHexString(new ByteBuffer[]{ByteBuffer.wrap(buffers)}, maxOutSize);
    }

    public static String toHexString(ByteBuffer[] buffers, int maxOutSize) {
        String postfix = "";
        int size = 0;
        ArrayList<ByteBuffer> copies = new ArrayList<ByteBuffer>();
        for (ByteBuffer buffer : buffers) {
            ByteBuffer copy = buffer.duplicate();
            if (size + copy.limit() > maxOutSize) {
                copy.limit(maxOutSize - size);
                copies.add(copy);
                postfix = " [output has been cut]";
                break;
            }
            copies.add(copy);
        }
        StringBuilder result = new StringBuilder();
        result.append("[hex:] ");
        for (ByteBuffer buffer : copies) {
            result.append(DataConverter.toByteString(buffer));
        }
        result.append(postfix);
        return result.toString();
    }

    public static String toTextOrHexString(ByteBuffer buffer, String encoding, int maxOutSize) {
        return DataConverter.toTextOrHexString(new ByteBuffer[]{buffer}, encoding, maxOutSize);
    }

    public static String toTextOrHexString(ByteBuffer[] buffers, String encoding, int maxOutSize) {
        String result = DataConverter.toString(buffers, encoding, maxOutSize);
        if (result.length() > 0) {
            return result;
        }
        return DataConverter.toHexString(buffers, maxOutSize);
    }

    public static String toTextAndHexString(ByteBuffer[] buffers, String encoding, int maxOutSize) {
        StringBuilder sb = new StringBuilder();
        sb.append(DataConverter.toHexString(buffers, 500));
        sb.append("\n");
        try {
            sb.append("[txt:] " + DataConverter.toString(buffers, "US-ASCII", 500));
        }
        catch (Exception ignore) {
            sb.append("[txt:] ... content not printable ...");
        }
        return sb.toString();
    }
}

