/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.IWorkerPool;

public final class DynamicWorkerPool
implements IWorkerPool {
    private static final Logger LOG = Logger.getLogger(DynamicWorkerPool.class.getName());
    public static final int DEFAULT_LOAD_THRESHOLD_DECREASE = 20;
    public static final int DEFAULT_LOAD_THRESHOLD_INCREASE = 80;
    public static final int DEFAULT_ADJUST_CHECK_PERIOD = 1000;
    private static final int SLUGGISH_PERIOD = 30000;
    private static final Timer TIMER = new Timer("DynamicWorkerPoolTimer", true);
    private ThreadPoolExecutor executor = null;
    private final Object decLock = new Object();
    private SizeManager sizeManager = null;
    private int minSize = 0;
    private int maxSize = 0;

    public DynamicWorkerPool(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        int initial = minSize;
        if (initial < 1) {
            initial = 1;
        }
        this.executor = new ThreadPoolExecutor(initial, initial, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new WorkerThreadFactory());
        this.sizeManager = new SizeManager(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable command) {
        try {
            if (this.minSize < 1) {
                Object object = this.decLock;
                synchronized (object) {
                    if (this.getPoolSize() < 1) {
                        this.sizeManager.timeLastChange = System.currentTimeMillis();
                        this.executor.setCorePoolSize(1);
                    }
                }
            }
            this.executor.execute(command);
        }
        catch (RejectedExecutionException e) {
            if (this.executor.isShutdown()) {
                Thread t = new Thread(command);
                t.setDaemon(true);
                t.start();
            }
            LOG.warning("couldn't process command " + command + ". Reason: " + e.toString());
        }
    }

    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    public int getPoolSize() {
        return this.executor.getCorePoolSize();
    }

    public int getLoad() {
        return (int)this.sizeManager.load.getValue();
    }

    private int currentLoad() {
        int currentSize = this.getPoolSize();
        if (currentSize == 0) {
            return 0;
        }
        int activeCount = this.getActiveCount();
        if (activeCount == 0) {
            return 0;
        }
        return activeCount * 100 / currentSize;
    }

    public int getMaximumPoolSize() {
        return this.maxSize;
    }

    public int getMinimumPoolSize() {
        return this.minSize;
    }

    public boolean isOpen() {
        return !this.executor.isShutdown();
    }

    public void close() {
        this.sizeManager.shutdown();
        this.executor.shutdownNow();
    }

    public void setAdjustPeriod(int adjustPeriodSec) {
        this.sizeManager.setAdjustPeriod(adjustPeriodSec);
    }

    public int getAdjustPeriod() {
        return this.sizeManager.getAdjustPeriod();
    }

    public int getThresholdIncrease() {
        return this.sizeManager.getIncThreshold();
    }

    public void setThresholdIncrease(int incThreshold) {
        this.sizeManager.setIncThreshold(incThreshold);
    }

    public int getThresholdDecrease() {
        return this.sizeManager.getDecThreshold();
    }

    public void setThresholdDecrease(int decThreshold) {
        this.sizeManager.setDecThreshold(decThreshold);
    }

    int getLoadSluggish() {
        return (int)this.sizeManager.sluggishLoad.getValue();
    }

    long getDecRate() {
        return this.sizeManager.getDecRate();
    }

    public String toString() {
        return "DynamicWorkerPool (size=" + this.getPoolSize() + ", running=" + this.getActiveCount() + ", load=" + this.getLoad() + ", minSize=" + this.getMinimumPoolSize() + ", maxSize=" + this.getMaximumPoolSize() + ")";
    }

    static {
        TIMER.schedule(new TimerTask(){

            public void run() {
                Thread.currentThread().setPriority(1);
            }
        }, 0L);
    }

    private static final class Average {
        private LinkedList<Double> list = new LinkedList();
        private int capacity = 0;

        Average(int capacity) {
            this.capacity = capacity;
        }

        public void add(double size) {
            this.list.addLast(size);
            if (this.list.size() > this.capacity) {
                this.list.removeFirst();
            }
        }

        public void clear() {
            this.list.clear();
        }

        public double getValue() {
            if (this.list.size() == 0) {
                return 0.0;
            }
            double i = 0.0;
            LinkedList copy = (LinkedList)this.list.clone();
            Iterator i$ = copy.iterator();
            while (i$.hasNext()) {
                double size = (Double)i$.next();
                i += size;
            }
            if (i <= 0.0) {
                return 0.0;
            }
            return i /= (double)copy.size();
        }
    }

    private final class SizeManager {
        private long timeLastChange = System.currentTimeMillis();
        private int adjustPeriodSec = 0;
        private int decRate = 0;
        private Average load = new Average(3);
        private Average sluggishLoad = null;
        private int incThreshold = 80;
        private int decThreshold = 20;
        private TimerTask task = null;

        public SizeManager(int period) {
            this.sluggishLoad = new Average(30000 / period);
            this.decRate = 5 * period;
            this.setAdjustPeriod(period);
        }

        public int getDecThreshold() {
            return this.decThreshold;
        }

        public int getIncThreshold() {
            return this.incThreshold;
        }

        public long getDecRate() {
            return this.decRate;
        }

        public void setDecThreshold(int decThreshold) {
            this.decThreshold = decThreshold;
        }

        public void setIncThreshold(int incThreshold) {
            this.incThreshold = incThreshold;
        }

        public void setAdjustPeriod(int period) {
            this.adjustPeriodSec = period;
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = new TimerTask(){

                public void run() {
                    SizeManager.this.adjustWorkerSize();
                }
            };
            TIMER.schedule(this.task, period, (long)period);
        }

        public int getAdjustPeriod() {
            return this.adjustPeriodSec;
        }

        public void shutdown() {
            if (this.task != null) {
                this.task.cancel();
            }
        }

        private void adjustWorkerSize() {
            block2: {
                try {
                    int size = DynamicWorkerPool.this.getPoolSize();
                    double load = DynamicWorkerPool.this.currentLoad();
                    this.checkForInc(size, load);
                    this.checkForDec(size, load);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured vy adjusting pool size. Reason: " + e.toString());
                }
            }
        }

        private void checkForInc(int size, double currentLoad) {
            this.load.add((int)currentLoad);
            if (this.load.getValue() >= (double)this.incThreshold && size < DynamicWorkerPool.this.maxSize) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("average load is " + this.load.getValue() + " increase pool size. new size is " + (size + 1) + " minSize=" + DynamicWorkerPool.this.getMinimumPoolSize() + ", maxSize=" + DynamicWorkerPool.this.getMaximumPoolSize() + ")");
                }
                DynamicWorkerPool.this.executor.setCorePoolSize(size + 1);
                this.timeLastChange = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkForDec(int size, double currentLoad) {
            this.sluggishLoad.add((int)currentLoad);
            if (this.load.getValue() <= (double)this.decThreshold && this.sluggishLoad.getValue() <= (double)this.decThreshold && size > DynamicWorkerPool.this.minSize && System.currentTimeMillis() > this.timeLastChange + (long)this.decRate && size == 1) {
                Object object = DynamicWorkerPool.this.decLock;
                synchronized (object) {
                    if (!DynamicWorkerPool.this.executor.getQueue().isEmpty()) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("average load is " + this.sluggishLoad.getValue() + " decrease pool size. new size is " + (size - 1) + " minSize=" + DynamicWorkerPool.this.getMinimumPoolSize() + ", maxSize=" + DynamicWorkerPool.this.getMaximumPoolSize() + ")");
                        }
                        DynamicWorkerPool.this.executor.setCorePoolSize(size - 1);
                        this.timeLastChange = System.currentTimeMillis();
                    }
                }
            }
        }
    }

    private static final class WorkerThreadFactory
    implements ThreadFactory {
        private static int poolCounter = 0;
        private int threadCounter = 0;
        private String namePrefix = "group-" + ++poolCounter + "-worker-";

        WorkerThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName(this.namePrefix + ++this.threadCounter);
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }
}

