/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.Dispatcher;
import org.xsocket.IEventHandler;
import org.xsocket.IHandle;
import org.xsocket.datagram.AbstractEndpoint;
import org.xsocket.datagram.IDatagramHandler;
import org.xsocket.datagram.IEndpoint;
import org.xsocket.datagram.MemoryManager;
import org.xsocket.datagram.UserDatagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractChannelBasedEndpoint
extends AbstractEndpoint
implements IEndpoint {
    private static final Logger LOG = Logger.getLogger(AbstractChannelBasedEndpoint.class.getName());
    private static final MemoryManager memoryManager = new MemoryManager(65536, false);
    private static Dispatcher<DispatcherHandle> dispatcher = AbstractChannelBasedEndpoint.createDispatcher();
    private DatagramSocket socket = null;
    private DatagramChannel channel = null;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private final List<UserDatagram> sendQueue = Collections.synchronizedList(new LinkedList());
    private DispatcherHandle dispatcherHandle = null;

    AbstractChannelBasedEndpoint(InetAddress address, int port, IDatagramHandler datagramHandler, int receivePacketSize) throws IOException {
        super(datagramHandler, receivePacketSize);
        this.channel = DatagramChannel.open();
        this.channel.configureBlocking(false);
        this.socket = this.channel.socket();
        this.socket.setReuseAddress(true);
        InetSocketAddress addr = new InetSocketAddress(address, port);
        this.socket.bind(addr);
        this.dispatcherHandle = new DispatcherHandle(this);
        dispatcher.register(this.dispatcherHandle, 1);
        this.logFine("enpoint has been bound to locale port " + this.getLocalPort() + " (server mode)");
    }

    private static Dispatcher<DispatcherHandle> createDispatcher() {
        Dispatcher<DispatcherHandle> disp = new Dispatcher<DispatcherHandle>(new DispatcherEventHandler());
        Thread t = new Thread(disp);
        t.start();
        return disp;
    }

    protected final DatagramChannel getChannel() {
        return this.channel;
    }

    @Override
    public final void close() {
        if (this.isOpen()) {
            try {
                this.logFine("closing " + this.toCompactString());
                this.channel.close();
            }
            catch (IOException ioe) {
                this.logFine("error occured by closing connection. Reason " + ioe.toString());
            }
            super.close();
        }
    }

    @Override
    public final SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public final int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public final boolean isOpen() {
        return this.channel.isOpen();
    }

    private void logFine(String msg) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[/:" + this.getLocalPort() + " " + this.getId() + "] " + msg);
        }
    }

    @Override
    public void send(UserDatagram packet) throws IOException {
        if (packet.getRemoteAddress() == null) {
            throw new IOException("remote socket adress has to be set");
        }
        this.logFine("add datagram packet (" + packet + ") to write queue");
        packet.prepareForSend();
        this.sendQueue.add(packet);
        this.logFine("update interest ops to write");
        this.updateInteresSet(4);
    }

    @Override
    public String toString() {
        return this.socket.getLocalSocketAddress().toString() + " (ID=" + this.getId() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePhysical() {
        if (!this.sendQueue.isEmpty()) {
            List<UserDatagram> list = this.sendQueue;
            synchronized (list) {
                for (UserDatagram packet : this.sendQueue) {
                    try {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[/:" + this.getLocalPort() + " " + this.getId() + "] sending datagram " + packet.toString());
                        }
                        int dataToSend = packet.getSize();
                        int written = this.channel.send(packet.getData(), packet.getRemoteSocketAddress());
                        if (LOG.isLoggable(Level.FINE) && dataToSend != written) {
                            LOG.fine("Error occured by sending datagram. Size DataToSend=" + dataToSend + ", written=" + written);
                        }
                        this.incNumberOfHandledOutgoingDatagram();
                    }
                    catch (IOException ioe) {
                        LOG.warning("couldn't write datagram to " + packet.getRemoteAddress() + " .Reason: " + ioe.toString());
                    }
                }
                this.sendQueue.clear();
            }
        }
    }

    private void updateInteresSet(int intOps) throws IOException {
        dispatcher.updateInterestSet(this.dispatcherHandle, intOps);
    }

    public String toCompactString() {
        return this.getClass().getSimpleName() + " " + this.socket.getLocalAddress().getCanonicalHostName() + ":" + this.getLocalPort();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DispatcherEventHandler<T extends IEndpoint>
    implements IEventHandler<DispatcherHandle> {
        private DispatcherEventHandler() {
        }

        @Override
        public void onHandleRegisterEvent(DispatcherHandle handle) throws IOException {
        }

        @Override
        public void onHandleReadableEvent(DispatcherHandle handle) {
            if (handle.endpoint.isOpen()) {
                try {
                    if (handle.endpoint.getReceiveSize() > 0) {
                        ByteBuffer readBuffer = memoryManager.acquireMemory(handle.endpoint.getReceiveSize());
                        readBuffer.order(handle.endpoint.byteOrder);
                        SocketAddress address = handle.endpoint.channel.receive(readBuffer);
                        if (address == null) {
                            return;
                        }
                        if (readBuffer.position() == 0) {
                            return;
                        }
                        readBuffer.flip();
                        handle.endpoint.onData(address, readBuffer);
                    }
                }
                catch (IOException ioe) {
                    handle.endpoint.logFine("error occured while receiving. Reason: " + ioe.toString());
                }
            }
        }

        @Override
        public void onHandleWriteableEvent(DispatcherHandle handle) throws IOException {
            handle.endpoint.writePhysical();
            handle.endpoint.updateInteresSet(1);
        }

        @Override
        public void onDispatcherCloseEvent(DispatcherHandle handle) {
            handle.endpoint.close();
        }
    }

    private static final class DispatcherHandle
    implements IHandle {
        private AbstractChannelBasedEndpoint endpoint = null;

        DispatcherHandle(AbstractChannelBasedEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        public SelectableChannel getChannel() {
            return this.endpoint.channel;
        }
    }
}

