/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.DynamicWorkerPool;
import org.xsocket.IWorkerPool;
import org.xsocket.datagram.IDatagramHandler;
import org.xsocket.datagram.IEndpoint;
import org.xsocket.datagram.UserDatagram;

abstract class AbstractEndpoint
implements IEndpoint {
    private static final Logger LOG = Logger.getLogger(AbstractEndpoint.class.getName());
    private static IWorkerPool GLOBAL_WORKERPOOL = new DynamicWorkerPool(0, 250);
    private static long nextId = 0L;
    private long id = 0L;
    private String defaultEncoding = "UTF-8";
    private final Object readGuard = new Object();
    private final List<UserDatagram> receiveQueue = Collections.synchronizedList(new ArrayList());
    private int receiveSize = -1;
    private IDatagramHandler datagramHandler = null;
    private IWorkerPool workerPool = null;
    private long handleIncomingDatagrams = 0L;
    private long handleOutgoingDatagrams = 0L;

    AbstractEndpoint(IDatagramHandler datagramHandler, int receiveSize) {
        this.datagramHandler = datagramHandler;
        this.receiveSize = receiveSize;
        this.id = ++nextId;
        this.workerPool = GLOBAL_WORKERPOOL;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                AbstractEndpoint.this.close();
            }
        });
    }

    public void close() {
        if (this.workerPool != GLOBAL_WORKERPOOL && this.workerPool instanceof DynamicWorkerPool) {
            ((DynamicWorkerPool)this.workerPool).close();
        }
    }

    public void setWorkerPool(IWorkerPool workerPool) {
        this.workerPool = workerPool;
    }

    public final void setReceiveSize(int receivePacketSize) {
        this.receiveSize = receivePacketSize;
    }

    public final int getReceiveSize() {
        return this.receiveSize;
    }

    protected final void onData(SocketAddress address, ByteBuffer data) {
        UserDatagram packet = new UserDatagram(address, data, this.getDefaultEncoding());
        this.receiveQueue.add(packet);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[/:" + this.getLocalPort() + " " + this.getId() + "] datagram received: " + packet.toString());
        }
        ++this.handleIncomingDatagrams;
        if (this.datagramHandler != null) {
            this.workerPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block5: {
                        try {
                            AbstractEndpoint abstractEndpoint = AbstractEndpoint.this;
                            synchronized (abstractEndpoint) {
                                AbstractEndpoint.this.datagramHandler.onDatagram(AbstractEndpoint.this);
                            }
                        }
                        catch (Throwable e) {
                            if (!LOG.isLoggable(Level.FINE)) break block5;
                            LOG.fine("error occured by performing onData task. Reason: " + e.toString());
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UserDatagram receive(long timeoutMillis) throws IOException, SocketTimeoutException {
        if (this.getReceiveSize() == -1) {
            throw new IOException("the receive packet size hasn't been set");
        }
        UserDatagram datagram = null;
        if (timeoutMillis <= 0L) {
            datagram = this.receive();
        } else {
            long start = System.currentTimeMillis();
            Object object = this.readGuard;
            synchronized (object) {
                while ((datagram = this.receive()) == null) {
                    try {
                        this.readGuard.wait(timeoutMillis / 10L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < start + timeoutMillis) continue;
                }
            }
        }
        if (datagram == null) {
            throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(timeoutMillis) + " reached");
        }
        return datagram;
    }

    public UserDatagram receive() {
        if (this.receiveQueue.isEmpty()) {
            return null;
        }
        return this.receiveQueue.remove(0);
    }

    public final String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public final void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    protected final void incNumberOfHandledOutgoingDatagram() {
        ++this.handleOutgoingDatagrams;
    }

    protected final long getId() {
        return this.id;
    }

    public String toString() {
        return Long.toString(this.id);
    }
}

