/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ClosedConnectionException;
import org.xsocket.datagram.AbstractEndpoint;
import org.xsocket.datagram.IConnectedEndpoint;
import org.xsocket.datagram.IDatagramHandler;
import org.xsocket.datagram.UserDatagram;

public final class MulticastEndpoint
extends AbstractEndpoint
implements IConnectedEndpoint {
    private static Logger LOG = Logger.getLogger(MulticastEndpoint.class.getName());
    private boolean isRunning = true;
    private MulticastSocket socket = null;
    private InetSocketAddress multicastAddress = null;

    public MulticastEndpoint(String address, int port, int receiveSize, IDatagramHandler datagramHandler) throws IOException {
        this(InetAddress.getByName(address), port, receiveSize, datagramHandler);
    }

    public MulticastEndpoint(InetAddress address, int port, int receiveSize, IDatagramHandler datagramHandler) throws IOException {
        super(datagramHandler, receiveSize);
        this.socket = new MulticastSocket(port);
        this.socket.joinGroup(address);
        this.multicastAddress = new InetSocketAddress(address, port);
        this.startReceiver();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("upd multicast endpoint bound to " + address.getCanonicalHostName() + "/" + port);
        }
    }

    private void startReceiver() {
        Thread receiverThread = new Thread(){

            public void run() {
                while (MulticastEndpoint.this.isRunning) {
                    MulticastEndpoint.this.receiveData();
                }
            }
        };
        receiverThread.start();
    }

    private void receiveData() {
        block2: {
            try {
                byte[] buf = new byte[this.getReceiveSize()];
                DatagramPacket dp = new DatagramPacket(buf, buf.length);
                this.socket.receive(dp);
                ByteBuffer data = ByteBuffer.wrap(dp.getData());
                data.limit(dp.getLength());
                this.onData(new InetSocketAddress(dp.getAddress(), dp.getPort()), data);
            }
            catch (IOException e) {
                if (this.socket.isClosed() || !LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by receiving data. Reason: " + e.toString());
            }
        }
    }

    public String toString() {
        return this.multicastAddress.toString() + " (ID=" + this.getId() + ")";
    }

    public void close() {
        if (this.isRunning) {
            block3: {
                this.isRunning = false;
                try {
                    this.socket.leaveGroup(this.multicastAddress.getAddress());
                    this.socket.close();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("error occured by closing multicast socket. Reason: " + e.toString());
                }
            }
            super.close();
        }
    }

    public SocketAddress getLocalSocketAddress() {
        return this.multicastAddress;
    }

    public InetAddress getLocalAddress() {
        return this.multicastAddress.getAddress();
    }

    public int getLocalPort() {
        return this.multicastAddress.getPort();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.multicastAddress;
    }

    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    public void send(UserDatagram packet) throws ClosedConnectionException, IOException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("[/:" + this.getLocalPort() + " " + this.getId() + "] sending datagram " + packet.toString());
        }
        packet.prepareForSend();
        byte[] bytes = new byte[packet.getData().remaining()];
        packet.getData().get(bytes);
        DatagramPacket dataPacket = new DatagramPacket(bytes, bytes.length, this.multicastAddress);
        this.socket.send(dataPacket);
        this.incNumberOfHandledOutgoingDatagram();
    }
}

