/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.IDispatcher;
import org.xsocket.stream.IConnectionScoped;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.IoSocketDispatcher;
import org.xsocket.stream.IoSocketDispatcherPool;
import org.xsocket.stream.IoSocketHandler;
import org.xsocket.stream.NonBlockingConnection;

final class Acceptor {
    private static final Logger LOG = Logger.getLogger(Acceptor.class.getName());
    private boolean isRunning = true;
    private ServerSocketChannel serverChannel = null;
    private IHandler appHandlerPrototype = null;
    private boolean isConnectionScoped = false;
    private boolean isConnectHandler = false;
    private boolean isDisconnectHandler = false;
    private boolean isDataHandler = false;
    private boolean isTimeoutHandler = false;
    private boolean sslOn = false;
    private SSLContext sslContext = null;
    private String localIdPrefix = null;
    private IoSocketDispatcherPool dispatcherPool = null;
    private final TimeoutWatchdog timeoutWatchDog = new TimeoutWatchdog();
    private int idleTimeoutSec = Integer.MAX_VALUE;
    private int connectionTimeoutSec = Integer.MAX_VALUE;
    private long handledConnections = 0L;

    public Acceptor(InetAddress bindAddress, int port, SSLContext sslContext, boolean sslOn, String localIdPrefix, IoSocketDispatcherPool dispatcherPool) throws IOException {
        this.sslContext = sslContext;
        this.sslOn = sslOn;
        this.localIdPrefix = localIdPrefix;
        this.dispatcherPool = dispatcherPool;
        try {
            LOG.fine("try to bind server on " + bindAddress + ":" + port);
            this.serverChannel = ServerSocketChannel.open();
            this.serverChannel.configureBlocking(true);
            this.serverChannel.socket().bind(new InetSocketAddress(bindAddress, port));
            this.serverChannel.socket().setReuseAddress(true);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("acceptor has been bound on " + bindAddress + ":" + port);
            }
        }
        catch (BindException be) {
            if (this.serverChannel != null) {
                this.serverChannel.close();
            }
            LOG.info("error occured while binding server on on " + bindAddress + ":" + port + ". Reason: " + be.toString());
            throw be;
        }
    }

    int getLocalePort() {
        return this.serverChannel.socket().getLocalPort();
    }

    void setHandler(IHandler appHandler, boolean isConnectionScoped, boolean isConnectHandler, boolean isDisconnectHandler, boolean isDataHandler, boolean isTimeoutHandler) {
        this.appHandlerPrototype = appHandler;
        this.isConnectionScoped = isConnectionScoped;
        this.isConnectHandler = isConnectHandler;
        this.isDisconnectHandler = isDisconnectHandler;
        this.isDataHandler = isDataHandler;
        this.isTimeoutHandler = isTimeoutHandler;
    }

    void setConnectionTimeoutSec(int connectionTimeout) {
        if (connectionTimeout <= 0) {
            throw new RuntimeException("connection timeout must be larger than 0");
        }
        this.connectionTimeoutSec = connectionTimeout;
        this.updateTimeoutCheckPeriod();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection time out has ben update to " + DataConverter.toFormatedDuration(this.connectionTimeoutSec * 1000));
        }
    }

    int getConnectionTimeoutSec() {
        return this.connectionTimeoutSec;
    }

    void setIdleTimeoutSec(int idleTimeout) {
        if (idleTimeout <= 0) {
            throw new RuntimeException("idle timeout must be larger than 0");
        }
        this.idleTimeoutSec = idleTimeout;
        this.updateTimeoutCheckPeriod();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("idle time out has been update to " + DataConverter.toFormatedDuration(this.idleTimeoutSec * 1000));
        }
    }

    int getIdleTimeoutSec() {
        return this.idleTimeoutSec;
    }

    int getNumberOfIdleTimeout() {
        return this.timeoutWatchDog.getNumberOfIdleTimeout();
    }

    int getNumberOfConnectionTimeout() {
        return this.timeoutWatchDog.getNumberOfConnectionTimeout();
    }

    void updateTimeoutCheckPeriod() {
        this.timeoutWatchDog.updateTimeoutCheckPeriod((long)this.idleTimeoutSec * 1000L, (long)this.connectionTimeoutSec * 1000L);
    }

    long getNumberOfHandledConnections() {
        return this.handledConnections;
    }

    public final void shutdown() {
        if (this.isRunning) {
            this.isRunning = false;
            this.timeoutWatchDog.shutdown();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing acceptor");
            }
            try {
                this.serverChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dispatcherPool.shutdown();
        }
    }

    public final void run() {
        this.dispatcherPool.run();
        while (this.isRunning) {
            try {
                SocketChannel channel = this.serverChannel.accept();
                IHandler appHandler = null;
                appHandler = this.isConnectionScoped ? (IHandler)((IConnectionScoped)((Object)this.appHandlerPrototype)).clone() : this.appHandlerPrototype;
                IoSocketDispatcher dispatcher = this.dispatcherPool.nextDispatcher();
                IoSocketHandler socketIOHandler = new IoSocketHandler(channel, "s." + this.localIdPrefix + ".", dispatcher);
                NonBlockingConnection connection = new NonBlockingConnection(socketIOHandler, this.sslContext, this.sslOn, this.dispatcherPool.getMultithreadedMemoryManager(), false, appHandler, this.isConnectHandler, this.isDisconnectHandler, this.isDataHandler, this.isTimeoutHandler);
                connection.setIdleTimeoutSec(this.idleTimeoutSec);
                connection.setConnectionTimeoutSec(this.connectionTimeoutSec);
                ++this.handledConnections;
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINE) || !this.serverChannel.isOpen()) continue;
                LOG.fine("error occured while accepting connection: " + t.toString());
            }
        }
    }

    private final class TimeoutWatchdog {
        private final Timer watchdogTimer = new Timer("AcceptorWatchdogTimer", true);
        private TimerTask watchdogTimerTask = null;
        private int numberOfConnectionTimeout = 0;
        private int numberOfIdleTimeout = 0;

        public TimeoutWatchdog() {
            TimerTask task = new TimerTask(){

                public void run() {
                    Thread.currentThread().setPriority(1);
                }
            };
            this.watchdogTimer.schedule(task, 0L);
        }

        void updateTimeoutCheckPeriod(long idleTimeoutMillis, long connectionTimeoutMillis) {
            long period = idleTimeoutMillis;
            if (connectionTimeoutMillis < idleTimeoutMillis) {
                period = connectionTimeoutMillis;
            }
            this.setTimeoutCheckPeriod((int)((double)period / 5.0));
        }

        private void setTimeoutCheckPeriod(long period) {
            if (this.watchdogTimerTask != null) {
                this.watchdogTimerTask.cancel();
            }
            this.watchdogTimerTask = new TimerTask(){

                public void run() {
                    TimeoutWatchdog.this.checkDispatcherTimeout();
                }
            };
            this.watchdogTimer.schedule(this.watchdogTimerTask, period, period);
        }

        void shutdown() {
            if (this.watchdogTimerTask != null) {
                this.watchdogTimerTask.cancel();
            }
        }

        private synchronized void checkDispatcherTimeout() {
            block4: {
                try {
                    long current = System.currentTimeMillis();
                    for (IDispatcher<IoSocketHandler> dispatcher : Acceptor.this.dispatcherPool.getDispatchers()) {
                        Set<IoSocketHandler> socketHandlers = dispatcher.getRegistered();
                        for (IoSocketHandler socketHandler : socketHandlers) {
                            this.checkTimeout(socketHandler, current);
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("error occured: " + e.toString());
                }
            }
        }

        private void checkTimeout(IoSocketHandler ioSocketHandler, long current) {
            if (ioSocketHandler.checkIdleTimeout(current)) {
                ++this.numberOfIdleTimeout;
            }
            if (ioSocketHandler.checkConnectionTimeout(current)) {
                ++this.numberOfConnectionTimeout;
            }
        }

        public int getNumberOfConnectionTimeout() {
            return this.numberOfConnectionTimeout;
        }

        public int getNumberOfIdleTimeout() {
            return this.numberOfIdleTimeout;
        }
    }
}

