/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.Connection;
import org.xsocket.stream.IBlockingConnection;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.IoHandler;
import org.xsocket.stream.IoSSLHandler;
import org.xsocket.stream.IoSocketHandler;

public final class BlockingConnection
extends Connection
implements IBlockingConnection {
    private static final long SEND_TIMEOUT = 60000L;
    private final Object readGuard = new Object();
    private long receiveTimeout = 0L;
    private final Object writeGuard = new Object();
    private IOException writeException = null;

    public BlockingConnection(String hostname, int port) throws IOException {
        this(new InetSocketAddress(hostname, port), null, false);
    }

    public BlockingConnection(InetAddress address, int port) throws IOException {
        this(new InetSocketAddress(address, port), null, false);
    }

    public BlockingConnection(InetAddress address, int port, SSLContext sslContext, boolean startSSL) throws IOException {
        this(new InetSocketAddress(address, port), sslContext, startSSL);
    }

    public BlockingConnection(String hostname, int port, SSLContext sslContext, boolean startSSL) throws IOException {
        this(new InetSocketAddress(hostname, port), sslContext, startSSL);
    }

    private BlockingConnection(InetSocketAddress inetAddress, SSLContext sslContext, boolean startSSL) throws IOException {
        this(BlockingConnection.createcClientIoSocketHandler(inetAddress, BlockingConnection.getGlobalMemoryManager(), BlockingConnection.getGlobalDispatcher()), sslContext, startSSL, BlockingConnection.getGlobalMemoryManager());
    }

    private BlockingConnection(IoSocketHandler socketHandler, SSLContext sslContext, boolean startSSL, IMemoryManager sslMemoryManager) throws IOException {
        socketHandler.setIOEventHandler(new IOEventHandler());
        if (sslContext != null) {
            IoSSLHandler sslHandler = new IoSSLHandler(socketHandler, sslContext, startSSL, true, sslMemoryManager);
            this.setIOHandler(sslHandler);
            this.open();
        } else {
            this.setIOHandler(socketHandler);
            this.open();
        }
        this.setReceiveTimeoutMillis(60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.extractByteFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(this.receiveTimeout / 10L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < start + this.receiveTimeout) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    public final void setReceiveTimeoutMillis(long timeout) {
        this.receiveTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, SocketTimeoutException, MaxReadSizeExceededException {
        long start = System.currentTimeMillis();
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    LinkedList<ByteBuffer> result = this.extractBytesByDelimiterFromReadQueue(delimiter, maxLength);
                    return result.toArray(new ByteBuffer[result.size()]);
                }
                catch (MaxReadSizeExceededException mee) {
                    throw mee;
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(this.receiveTimeout / 10L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < start + this.receiveTimeout) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        if (length <= 0) {
            return null;
        }
        long start = System.currentTimeMillis();
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    LinkedList<ByteBuffer> result = this.extractBytesByLength(length);
                    return result.toArray(new ByteBuffer[result.size()]);
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(this.receiveTimeout / 10L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < start + this.receiveTimeout) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, SocketTimeoutException, MaxReadSizeExceededException {
        return DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, maxLength));
    }

    public byte[] readBytesByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return DataConverter.toBytes(this.readByteBufferByLength(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readDouble() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.extractDoubleFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(this.receiveTimeout / 10L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < start + this.receiveTimeout) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.extractIntFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(this.receiveTimeout / 10L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < start + this.receiveTimeout) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    public final int read(ByteBuffer buffer) throws IOException {
        ByteBuffer[] bufs;
        int savedPos = buffer.position();
        int savedLimit = buffer.limit();
        int size = buffer.remaining();
        for (ByteBuffer buf : bufs = this.readByteBufferByLength(size)) {
            buffer.put(buf);
        }
        buffer.position(savedPos);
        buffer.limit(savedLimit);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.extractLongFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(this.receiveTimeout / 10L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < start + this.receiveTimeout) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException, MaxReadSizeExceededException {
        return this.readStringByDelimiter(delimiter, this.getDefaultEncoding(), maxLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException, MaxReadSizeExceededException {
        long start = System.currentTimeMillis();
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    LinkedList<ByteBuffer> extracted = this.extractBytesByDelimiterFromReadQueue(delimiter, maxLength);
                    return DataConverter.toString(extracted, encoding);
                }
                catch (MaxReadSizeExceededException mle) {
                    throw mle;
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(this.receiveTimeout / 10L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < start + this.receiveTimeout) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    public String readStringByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.readStringByLength(length, this.getDefaultEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readStringByLength(int length, String encoding) throws IOException, ClosedConnectionException, SocketTimeoutException {
        if (length <= 0) {
            return null;
        }
        long start = System.currentTimeMillis();
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    LinkedList<ByteBuffer> extracted = this.extractBytesByLength(length);
                    return DataConverter.toString(extracted, encoding);
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(this.receiveTimeout / 10L);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < start + this.receiveTimeout) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws ClosedConnectionException, IOException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        Object object = this.writeGuard;
        synchronized (object) {
            super.flush();
            do {
                if (this.getIOHandler().isChainSendBufferEmpty()) {
                    return;
                }
                if (this.writeException != null) {
                    IOException ioe = this.writeException;
                    this.writeException = null;
                    throw ioe;
                }
                try {
                    this.writeGuard.wait(6000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            } while (System.currentTimeMillis() < start + 60000L);
        }
    }

    private final class IOEventHandler
    implements IoHandler.IIOEventHandler {
        private IOEventHandler() {
        }

        public boolean listenForWritten() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWrittenEvent() {
            Object object = BlockingConnection.this.writeGuard;
            synchronized (object) {
                BlockingConnection.this.writeGuard.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWriteExceptionEvent(IOException ioe) {
            Object object = BlockingConnection.this.writeGuard;
            synchronized (object) {
                BlockingConnection.this.writeException = ioe;
                BlockingConnection.this.writeGuard.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDataEvent() {
            Object object = BlockingConnection.this.readGuard;
            synchronized (object) {
                BlockingConnection.this.receive();
                BlockingConnection.this.readGuard.notify();
            }
        }

        public boolean listenForConnect() {
            return false;
        }

        public void onConnectEvent() {
        }

        public boolean listenForDisconnect() {
            return false;
        }

        public void onDisconnectEvent() {
        }

        public void onConnectionTimeout() {
        }

        public void onIdleTimeout() {
        }
    }
}

