/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ByteBufferParser {
    ByteBufferParser() {
    }

    public Index find(LinkedList<ByteBuffer> bufferQueue, String delimiter) {
        return this.find(bufferQueue, new Index(delimiter));
    }

    public Index find(LinkedList<ByteBuffer> bufferQueue, Index index) {
        int queueSize = bufferQueue.size();
        for (int bufNr = index.scannedBuffers; bufNr < queueSize && !index.hasDelimiterFound; ++bufNr) {
            ByteBuffer buffer = bufferQueue.get(bufNr);
            int savedPos = buffer.position();
            int savedLimit = buffer.limit();
            int pos = 0;
            while (buffer.hasRemaining() && !index.hasDelimiterFound) {
                byte b = buffer.get();
                index.readBytes++;
                if (index.delimiterPos > 0) {
                    if (b == index.delimiterBytes[index.delimiterPos]) {
                        if (index.delimiterPos + 1 == index.delimiterLength) {
                            index.hasDelimiterFound = true;
                            break;
                        }
                        index.delimiterPos++;
                    } else {
                        index.delimiterPos = 0;
                    }
                } else if (index.delimiterPos == 0 && b == index.delimiterBytes[index.delimiterPos]) {
                    index.delimiterPos++;
                    if (index.delimiterLength == 1) {
                        index.hasDelimiterFound = true;
                        break;
                    }
                }
                ++pos;
            }
            index.scannedBuffers++;
            buffer.position(savedPos);
            buffer.limit(savedLimit);
        }
        return index;
    }

    public LinkedList<ByteBuffer> extract(LinkedList<ByteBuffer> inOutBuffer, int length) throws IOException, BufferUnderflowException {
        int bufLength;
        LinkedList<ByteBuffer> result = new LinkedList<ByteBuffer>();
        int remainingToExtract = length;
        ByteBuffer buffer = null;
        do {
            if ((buffer = inOutBuffer.remove()) == null) {
                throw new BufferUnderflowException();
            }
            bufLength = buffer.limit() - buffer.position();
            if (remainingToExtract < bufLength) {
                int savedLimit = buffer.limit();
                buffer.limit(buffer.position() + remainingToExtract);
                ByteBuffer leftPart = buffer.slice();
                result.addLast(leftPart);
                buffer.position(buffer.limit());
                buffer.limit(savedLimit);
                ByteBuffer rightPart = buffer.slice();
                inOutBuffer.addFirst(rightPart);
                break;
            }
            result.addLast(buffer);
        } while ((remainingToExtract -= bufLength) > 0);
        return result;
    }

    public LinkedList<ByteBuffer> extract(LinkedList<ByteBuffer> inOutBuffer, Index index) throws IOException {
        assert (index.isValid) : "Index is invalid";
        assert (index.hasDelimiterFound());
        LinkedList<ByteBuffer> result = this.extract(inOutBuffer, index.getReadBytes() - index.getDelimiterLength());
        this.extract(inOutBuffer, index.getDelimiterLength());
        return result;
    }

    public static final class Index {
        public static final int NULL = -1;
        private boolean isValid = true;
        private boolean hasDelimiterFound = false;
        private String delimiter = null;
        private byte[] delimiterBytes = null;
        private int delimiterLength = 0;
        private int delimiterPos = 0;
        private int scannedBuffers = 0;
        private int readBytes = 0;

        Index(String delimiter) {
            this.delimiter = delimiter;
            this.delimiterBytes = delimiter.getBytes();
            this.delimiterLength = this.delimiterBytes.length;
        }

        public boolean hasDelimiterFound() {
            return this.hasDelimiterFound;
        }

        public int getReadBytes() {
            return this.readBytes;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        int getDelimiterLength() {
            return this.delimiterLength;
        }

        public int getDelimiterPos() {
            return this.delimiterPos;
        }
    }
}

