/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.DynamicWorkerPool;
import org.xsocket.IDispatcher;
import org.xsocket.IWorkerPool;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.ByteBufferParser;
import org.xsocket.stream.ByteBufferQueue;
import org.xsocket.stream.IConnection;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.IoHandler;
import org.xsocket.stream.IoSSLHandler;
import org.xsocket.stream.IoSocketDispatcher;
import org.xsocket.stream.IoSocketHandler;
import org.xsocket.stream.MemoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Connection
implements IConnection {
    private static final Logger LOG = Logger.getLogger(Connection.class.getName());
    private static final ByteBufferParser PARSER = new ByteBufferParser();
    private static IWorkerPool globalWorkerPool = null;
    private static IMemoryManager globalMemoryManager = null;
    private static IDispatcher<IoSocketHandler> globalDispatcher = null;
    private final ByteBufferQueue writeQueue = new ByteBufferQueue();
    private final ByteBufferQueue readQueue = new ByteBufferQueue();
    private IoHandler ioHandler = null;
    private String defaultEncoding = "UTF-8";
    private boolean autoflush = false;
    private ByteBufferParser.Index cachedIndex = null;
    private LinkedList<ByteBuffer> readMarkBuffer = null;
    private boolean isReadMarked = false;
    private WriteMarkBuffer writeMarkBuffer = null;
    private boolean isWriteMarked = false;

    Connection() {
    }

    void open() throws IOException {
        this.ioHandler.open();
    }

    final ByteBufferQueue getReadQueue() {
        return this.readQueue;
    }

    static final synchronized IWorkerPool getGlobalWorkerPool() {
        if (globalWorkerPool == null) {
            globalWorkerPool = new DynamicWorkerPool(0, 250);
        }
        return globalWorkerPool;
    }

    static synchronized IMemoryManager getGlobalMemoryManager() {
        if (globalMemoryManager == null) {
            globalMemoryManager = new MemoryManager(65536, true);
        }
        return globalMemoryManager;
    }

    static synchronized IDispatcher<IoSocketHandler> getGlobalDispatcher() {
        if (globalDispatcher == null) {
            globalDispatcher = Connection.newDispatcher("GlobalDispatcher", new MemoryManager(65536, true), Connection.getGlobalWorkerPool());
        }
        return globalDispatcher;
    }

    static IoSocketDispatcher newDispatcher(String name, IMemoryManager memoryManager, IWorkerPool workerPool) {
        IoSocketDispatcher dispatcher = new IoSocketDispatcher(memoryManager, workerPool);
        Thread t = new Thread(dispatcher);
        t.setName(name);
        t.setDaemon(true);
        t.start();
        return dispatcher;
    }

    static IoSocketHandler createcClientIoSocketHandler(InetSocketAddress inetAddress, IMemoryManager memoryManager, IDispatcher<IoSocketHandler> dispatcher) throws IOException {
        IoSocketHandler socketHdl = new IoSocketHandler(SocketChannel.open(inetAddress), "c.", dispatcher);
        socketHdl.setMemoryManager(memoryManager);
        while (!socketHdl.getChannel().finishConnect()) {
            try {
                Thread.sleep(25L);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Waiting to finish connection");
            }
            catch (InterruptedException ignore) {}
        }
        return socketHdl;
    }

    final IoHandler getIOHandler() {
        return this.ioHandler;
    }

    final void setIOHandler(IoHandler ioHdl) {
        this.ioHandler = ioHdl;
    }

    @Override
    public final void close() throws IOException {
        this.flushStrong();
        this.ioHandler.close();
    }

    @Override
    public final boolean isOpen() {
        return this.ioHandler.isOpen();
    }

    final void writeIncoming(ByteBuffer data) {
        this.readQueue.append(data);
    }

    final void writeOutgoing(ByteBuffer data) {
        this.writeQueue.append(data);
    }

    void writeOutgoing(LinkedList<ByteBuffer> datas) {
        this.writeQueue.append(datas);
    }

    @Override
    public void flush() throws ClosedConnectionException, IOException {
        this.removeWriteMark();
        if (!this.writeQueue.isEmpty()) {
            LinkedList<ByteBuffer> buffer = this.writeQueue.drain();
            this.ioHandler.writeOutgoing(buffer);
        }
    }

    private void flushStrong() throws ClosedConnectionException, IOException {
        this.flush();
        this.getIOHandler().flushOutgoing();
    }

    @Override
    public final String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public final void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    @Override
    public boolean getAutoflush() {
        return this.autoflush;
    }

    @Override
    public final String getId() {
        return this.ioHandler.getId();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.ioHandler.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.ioHandler.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.ioHandler.getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.ioHandler.getRemotePort();
    }

    void onIdleTimeout() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void onConnectionTimeout() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    final void receive() {
        LinkedList<ByteBuffer> buffers = this.getIOHandler().drainIncoming();
        if (LOG.isLoggable(Level.FINER)) {
            int received = 0;
            for (ByteBuffer buffer : buffers) {
                received += buffer.remaining();
            }
            LOG.finer("appending " + received + " bytes to connection's read queue");
        }
        this.getReadQueue().append(buffers);
    }

    @Override
    public void activateSecuredMode() throws IOException {
        IoHandler ioHandler = this.getIOHandler();
        this.flushStrong();
        do {
            if (!(ioHandler instanceof IoSSLHandler)) continue;
            ((IoSSLHandler)ioHandler).startSSL();
            return;
        } while ((ioHandler = ioHandler.getSuccessor()) != null);
        throw new IOException("couldn't startSSL, because no SSLHandler (SSLContext) is set");
    }

    @Override
    public final int write(String s) throws ClosedConnectionException, IOException {
        return this.write(s, this.defaultEncoding);
    }

    @Override
    public final int write(String s, String encoding) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = DataConverter.toByteBuffer(s, encoding);
        return this.write(buffer);
    }

    @Override
    public final int write(byte b) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1).put(b);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(byte ... bytes) throws ClosedConnectionException, IOException {
        return this.write(ByteBuffer.wrap(bytes));
    }

    @Override
    public final int write(byte[] bytes, int offset, int length) throws ClosedConnectionException, IOException {
        return this.write(ByteBuffer.wrap(bytes, offset, length));
    }

    @Override
    public final long write(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        long written = 0L;
        for (ByteBuffer buffer : buffers) {
            written += (long)(buffer.limit() - buffer.position());
        }
        if (this.isWriteMarked) {
            for (ByteBuffer buffer : buffers) {
                this.writeMarkBuffer.add(buffer);
            }
        } else {
            for (ByteBuffer buffer : buffers) {
                this.writeQueue.append(buffer);
            }
        }
        if (this.autoflush) {
            this.flush();
        }
        return written;
    }

    @Override
    public final int write(ByteBuffer buffer) throws ClosedConnectionException, IOException {
        int written = buffer.limit() - buffer.position();
        if (this.isWriteMarked) {
            this.writeMarkBuffer.add(buffer);
        } else {
            this.writeQueue.append(buffer);
        }
        if (this.autoflush) {
            this.flush();
        }
        return written;
    }

    @Override
    public final int write(int i) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4).putInt(i);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(long l) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putLong(l);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(double d) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putDouble(d);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        ByteBuffer[] bufs = new ByteBuffer[length];
        System.arraycopy(srcs, offset, bufs, 0, length);
        return this.write(bufs);
    }

    protected final LinkedList<ByteBuffer> extractAvailableFromReadQueue() {
        this.resetCachedIndex();
        LinkedList<ByteBuffer> buffers = this.readQueue.drain();
        this.onExtracted(buffers);
        return buffers;
    }

    protected final LinkedList<ByteBuffer> extractBytesByDelimiterFromReadQueue(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (!this.readQueue.isEmpty()) {
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, delimiter);
            if (index.getReadBytes() > maxLength) {
                throw new MaxReadSizeExceededException();
            }
            if (index.hasDelimiterFound()) {
                LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, index);
                this.onExtracted(extracted);
                this.readQueue.addFirst(buffers);
                this.resetCachedIndex();
                return extracted;
            }
            this.readQueue.addFirst(buffers);
            this.cachedIndex = index;
        }
        throw new BufferUnderflowException();
    }

    public int indexOf(String str) {
        int length = 0;
        if (!this.readQueue.isEmpty()) {
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, str);
            length = index.hasDelimiterFound() ? index.getReadBytes() - str.length() : -1;
            this.readQueue.addFirst(buffers);
            this.cachedIndex = index;
        }
        return length;
    }

    protected final LinkedList<ByteBuffer> extractBytesByLength(int length) throws IOException, BufferUnderflowException {
        if (this.readQueue.getSize() >= length) {
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, length);
            this.onExtracted(extracted);
            this.readQueue.addFirst(buffers);
            this.resetCachedIndex();
            return extracted;
        }
        throw new BufferUnderflowException();
    }

    protected final boolean extractAvailableFromReadQueue(String delimiter, WritableByteChannel outChannel) throws IOException {
        if (!this.readQueue.isEmpty()) {
            int availableBytes;
            int readBytes;
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, delimiter);
            if (index.hasDelimiterFound()) {
                LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, index);
                this.onExtracted(extracted);
                for (ByteBuffer buffer : extracted) {
                    outChannel.write(buffer);
                }
                this.readQueue.addFirst(buffers);
                this.resetCachedIndex();
                return true;
            }
            if (index.getDelimiterPos() == 0 && (readBytes = index.getReadBytes()) > 0 && (availableBytes = readBytes - index.getDelimiterPos()) > 0) {
                LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, availableBytes);
                this.onExtracted(extracted);
                for (ByteBuffer buffer : extracted) {
                    outChannel.write(buffer);
                }
                this.resetCachedIndex();
            }
            this.readQueue.addFirst(buffers);
            return false;
        }
        return false;
    }

    private ByteBufferParser.Index scanByDelimiter(LinkedList<ByteBuffer> buffers, String delimiter) {
        if (this.cachedIndex != null) {
            if (this.cachedIndex.getDelimiter().equals(delimiter)) {
                return PARSER.find(buffers, this.cachedIndex);
            }
            this.cachedIndex = null;
        }
        return PARSER.find(buffers, delimiter);
    }

    private void onExtracted(LinkedList<ByteBuffer> buffers) {
        for (ByteBuffer buffer : buffers) {
            this.onExtracted(buffer);
        }
    }

    private void onExtracted(ByteBuffer buffer) {
        if (this.isReadMarked) {
            this.readMarkBuffer.addLast(buffer.duplicate());
        }
    }

    protected final byte[] extractBytesFromReadQueue(int length) throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(length);
        this.onExtracted(buffer);
        return DataConverter.toBytes(buffer);
    }

    protected final int extractIntFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(4);
        this.onExtracted(buffer);
        return buffer.getInt();
    }

    protected final byte extractByteFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(1);
        this.onExtracted(buffer);
        return buffer.get();
    }

    protected final double extractDoubleFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(8);
        this.onExtracted(buffer);
        return buffer.getDouble();
    }

    protected final long extractLongFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(8);
        this.onExtracted(buffer);
        return buffer.getLong();
    }

    private void resetCachedIndex() {
        this.cachedIndex = null;
    }

    @Override
    public void markReadPosition() {
        this.removeReadMark();
        this.isReadMarked = true;
        this.readMarkBuffer = new LinkedList();
    }

    @Override
    public void markWritePosition() {
        this.removeWriteMark();
        this.isWriteMarked = true;
        this.writeMarkBuffer = new WriteMarkBuffer();
    }

    @Override
    public boolean resetToWriteMark() {
        if (this.isWriteMarked) {
            this.writeMarkBuffer.resetWritePosition();
            return true;
        }
        return false;
    }

    @Override
    public boolean resetToReadMark() {
        if (this.isReadMarked) {
            this.getReadQueue().addFirst(this.readMarkBuffer);
            this.removeReadMark();
            return true;
        }
        return false;
    }

    @Override
    public void removeReadMark() {
        this.isReadMarked = false;
        this.readMarkBuffer = null;
    }

    @Override
    public void removeWriteMark() {
        if (this.isWriteMarked) {
            this.isWriteMarked = false;
            this.writeQueue.append(this.writeMarkBuffer.drain());
            this.writeMarkBuffer = null;
        }
    }

    public String toCompactString() {
        return "id=" + this.getId() + ", caller=" + this.getRemoteAddress().getCanonicalHostName() + "(" + this.getRemoteAddress() + ":" + this.getRemotePort() + ")";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.toCompactString());
        return sb.toString();
    }

    private static class Entry {
        private ByteBuffer element = null;
        private Entry next = null;

        Entry(ByteBuffer element, Entry next) {
            this.element = element;
            this.next = next;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.element != null) {
                sb.append(DataConverter.toHexString(new ByteBuffer[]{this.element}, 100000));
            }
            if (this.next != null) {
                sb.append(this.next.toString());
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WriteMarkBuffer {
        private final Entry head;
        private Entry tail;

        private WriteMarkBuffer() {
            this.tail = this.head = new Entry(null, null);
        }

        public LinkedList<ByteBuffer> drain() {
            LinkedList<ByteBuffer> result = new LinkedList<ByteBuffer>();
            Entry entry = this.head;
            do {
                if ((entry = entry.next) == null) continue;
                result.add(entry.element);
            } while (entry != null);
            this.head.next = null;
            this.tail = this.head;
            return result;
        }

        public void add(ByteBuffer data) {
            int size = data.remaining();
            if (size == 0) {
                return;
            }
            Entry entry = new Entry(data, this.tail.next);
            this.tail.next = entry;
            this.tail = entry;
            while (size > 0 && this.tail.next != null) {
                int nextSize = this.tail.next.element.remaining();
                if (nextSize <= size) {
                    size -= nextSize;
                    this.tail.next = this.tail.next.next;
                    if (this.tail.next != null) continue;
                    break;
                }
                ByteBuffer buffer = this.tail.next.element;
                buffer.position(buffer.position() + size);
                ByteBuffer sliced = buffer.slice();
                Entry slicedEntry = new Entry(sliced, this.tail.next.next);
                this.tail.next = slicedEntry;
                break;
            }
        }

        public void resetWritePosition() {
            this.tail = this.head;
        }
    }
}

