/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.stream.IoHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoDelayWriteHandler
extends IoHandler {
    private static final Logger LOG = Logger.getLogger(IoDelayWriteHandler.class.getName());
    private final Queue<DelayQueueEntry> sendQueue = new LinkedList<DelayQueueEntry>();
    private int sendBytesPerSec = Integer.MAX_VALUE;
    private static Timer timer = null;
    private TimerTask delayedDelivererTask = null;

    @Override
    void open() throws IOException {
        this.getSuccessor().open();
    }

    IoDelayWriteHandler(IoHandler successor) {
        super(successor);
    }

    void setWriteRateSec(int writeRateSec) {
        this.sendBytesPerSec = writeRateSec;
    }

    @Override
    String getId() {
        return this.getSuccessor().getId();
    }

    @Override
    InetAddress getLocalAddress() {
        return this.getSuccessor().getLocalAddress();
    }

    @Override
    int getLocalPort() {
        return this.getSuccessor().getLocalPort();
    }

    @Override
    InetAddress getRemoteAddress() {
        return this.getSuccessor().getRemoteAddress();
    }

    @Override
    int getRemotePort() {
        return this.getSuccessor().getRemotePort();
    }

    @Override
    boolean isOpen() {
        return this.getSuccessor().isOpen();
    }

    @Override
    void setIOEventHandler(IoHandler.IIOEventHandler ioEventHandler) {
        this.getSuccessor().setIOEventHandler(ioEventHandler);
    }

    @Override
    boolean isChainSendBufferEmpty() {
        if (this.getSuccessor() != null) {
            return this.sendQueue.isEmpty() && this.getSuccessor().isChainSendBufferEmpty();
        }
        return this.sendQueue.isEmpty();
    }

    @Override
    IoHandler.IIOEventHandler getIOEventHandler() {
        return this.getSuccessor().getIOEventHandler();
    }

    @Override
    LinkedList<ByteBuffer> drainIncoming() {
        return this.getSuccessor().drainIncoming();
    }

    @Override
    void close() throws IOException {
        this.flushOutgoing();
        this.getSuccessor().close();
    }

    @Override
    void writeOutgoing(ByteBuffer buffer) {
        this.addToDelayedQueue(buffer);
    }

    @Override
    void writeOutgoing(LinkedList<ByteBuffer> buffers) {
        for (ByteBuffer buffer : buffers) {
            this.addToDelayedQueue(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDelayedQueue(ByteBuffer buffer) {
        int size = buffer.remaining();
        if (size > 0) {
            int delayTime = size * 1000 / this.sendBytesPerSec;
            Queue<DelayQueueEntry> queue = this.sendQueue;
            synchronized (queue) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] add " + buffer.remaining() + " bytes to delay queue");
                }
                this.sendQueue.offer(new DelayQueueEntry(System.currentTimeMillis() + (long)delayTime, buffer));
            }
        }
        if (this.delayedDelivererTask == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] delay delivery task is null. Starting task");
            }
            this.delayedDelivererTask = new DeliveryTask();
            IoDelayWriteHandler.getTimer().schedule(this.delayedDelivererTask, 0L, 500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flushOutgoing() {
        Queue<DelayQueueEntry> queue = this.sendQueue;
        synchronized (queue) {
            if (!this.sendQueue.isEmpty()) {
                DelayQueueEntry[] entries = this.sendQueue.toArray(new DelayQueueEntry[this.sendQueue.size()]);
                this.sendQueue.clear();
                ByteBuffer[] buffers = new ByteBuffer[entries.length];
                for (int i = 0; i < buffers.length; ++i) {
                    buffers[i] = entries[i].getBuffer();
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] flushing " + buffers.length + " buffers of delay queue");
                }
                for (ByteBuffer buffer : buffers) {
                    try {
                        this.getSuccessor().writeOutgoing(buffer);
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("[" + this.getId() + "] error occured while writing. Reason: " + e.toString());
                    }
                }
            }
        }
        this.getSuccessor().flushOutgoing();
    }

    private static synchronized Timer getTimer() {
        if (timer == null) {
            timer = new Timer("IoDelayWriteTimer", true);
        }
        return timer;
    }

    private static final class DelayQueueEntry {
        private long deliveryTime = 0L;
        private ByteBuffer buffer = null;

        DelayQueueEntry(long deliveryTime, ByteBuffer buffer) {
            this.deliveryTime = deliveryTime;
            this.buffer = buffer;
        }

        ByteBuffer getBuffer() {
            return this.buffer;
        }

        long getDeliveryTime() {
            return this.deliveryTime;
        }
    }

    private final class DeliveryTask
    extends TimerTask {
        private DeliveryTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Thread.currentThread().setName("DeliveryThread");
            long current = System.currentTimeMillis();
            Queue queue = IoDelayWriteHandler.this.sendQueue;
            synchronized (queue) {
                while (!IoDelayWriteHandler.this.sendQueue.isEmpty()) {
                    DelayQueueEntry qe = (DelayQueueEntry)IoDelayWriteHandler.this.sendQueue.peek();
                    if (current < qe.getDeliveryTime()) return;
                    try {
                        IoDelayWriteHandler.this.sendQueue.remove(qe);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + IoDelayWriteHandler.this.getId() + "] release " + qe.getBuffer().remaining() + " bytes from delay queue");
                        }
                        IoDelayWriteHandler.this.getSuccessor().writeOutgoing(qe.getBuffer());
                    }
                    catch (Throwable e) {
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("[" + IoDelayWriteHandler.this.getId() + "] Error occured while write delayed. Reason: " + e.toString());
                    }
                }
                return;
            }
        }
    }
}

