/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.Dispatcher;
import org.xsocket.IEventHandler;
import org.xsocket.IWorkerPool;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.IoSocketHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSocketDispatcher
extends Dispatcher<IoSocketHandler> {
    private IMemoryManager memoryManager = null;

    IoSocketDispatcher(IMemoryManager memoryManager, IWorkerPool workerPool) {
        super(new DispatcherEventHandler(memoryManager, workerPool));
        this.memoryManager = memoryManager;
    }

    @Override
    public void register(IoSocketHandler handle, int ops) throws IOException {
        handle.setMemoryManager(this.memoryManager);
        super.register(handle, ops);
    }

    public int getPreallocatedReadMemorySize() {
        return this.memoryManager.getFreeBufferSize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DispatcherEventHandler
    implements IEventHandler<IoSocketHandler> {
        private static final Logger LOG = Logger.getLogger(DispatcherEventHandler.class.getName());
        private IMemoryManager memoryManager = null;
        private IWorkerPool workerPool = null;

        DispatcherEventHandler(IMemoryManager memoryManager, IWorkerPool workerPool) {
            this.memoryManager = memoryManager;
            this.workerPool = workerPool;
        }

        IMemoryManager getMemoryManager() {
            return this.memoryManager;
        }

        @Override
        public void onHandleReadableEvent(final IoSocketHandler socketIOHandler) throws IOException {
            block3: {
                try {
                    socketIOHandler.readSocketIntoReceiveQueue();
                    if (socketIOHandler.getReceiveQueueSize() > 0) {
                        this.workerPool.execute(new Runnable(){

                            public void run() {
                                socketIOHandler.onDataEvent();
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    socketIOHandler.close();
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("error occured by handling readable event. reason: " + t.toString());
                }
            }
        }

        @Override
        public void onHandleWriteableEvent(final IoSocketHandler socketIOHandler) throws IOException {
            socketIOHandler.getDispatcher().updateInterestSet(socketIOHandler, 1);
            try {
                socketIOHandler.writeSendQueueDataToSocket();
                socketIOHandler.onWrittenEvent();
            }
            catch (IOException ioe) {
                socketIOHandler.onWrittenExceptionEvent(ioe);
            }
            if (socketIOHandler.getSendQueueSize() > 0) {
                socketIOHandler.getDispatcher().updateInterestSet(socketIOHandler, 4);
            } else if (socketIOHandler.shouldClosedPhysically()) {
                block7: {
                    try {
                        socketIOHandler.getDispatcher().deregister(socketIOHandler);
                        socketIOHandler.closePhysically();
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block7;
                        LOG.fine("error occured by closing connection. reason: " + e.toString());
                    }
                }
                this.workerPool.execute(new Runnable(){

                    public void run() {
                        socketIOHandler.onDisconnectEvent();
                    }
                });
            }
        }

        @Override
        public void onDispatcherCloseEvent(final IoSocketHandler socketIOHandler) {
            this.workerPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    IoSocketHandler ioSocketHandler = socketIOHandler;
                    synchronized (ioSocketHandler) {
                        try {
                            socketIOHandler.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }

        @Override
        public void onHandleRegisterEvent(final IoSocketHandler socketIOHandler) throws IOException {
            if (socketIOHandler.getIOEventHandler().listenForConnect()) {
                this.workerPool.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        IoSocketHandler ioSocketHandler = socketIOHandler;
                        synchronized (ioSocketHandler) {
                            socketIOHandler.getIOEventHandler().onConnectEvent();
                        }
                    }
                });
            }
        }
    }
}

