/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.IDispatcher;
import org.xsocket.IWorkerPool;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.BlockingConnection;
import org.xsocket.stream.Connection;
import org.xsocket.stream.IConnectHandler;
import org.xsocket.stream.IConnectionScoped;
import org.xsocket.stream.IDataHandler;
import org.xsocket.stream.IDisconnectHandler;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.ILifeCycle;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.INonBlockingConnection;
import org.xsocket.stream.ITimeoutHandler;
import org.xsocket.stream.IoDelayWriteHandler;
import org.xsocket.stream.IoHandler;
import org.xsocket.stream.IoSSLHandler;
import org.xsocket.stream.IoSocketHandler;
import org.xsocket.stream.MemoryManager;

public final class NonBlockingConnection
extends Connection
implements INonBlockingConnection {
    private static final Logger LOG = Logger.getLogger(BlockingConnection.class.getName());
    private IHandler appHandler = null;
    private boolean isConnectHandler = false;
    private boolean isDisconnectHandler = false;
    private boolean isDataHandler = false;
    private boolean isTimeoutHandler = false;
    private boolean isClient = false;
    private IoSocketHandler socketHandler = null;
    private TimeoutWatchdog timeoutWatchdog = null;
    private static Timer watchDogTimer = null;

    public NonBlockingConnection(String hostname, int port) throws IOException {
        this(hostname, port, null, false);
    }

    public NonBlockingConnection(InetAddress address, int port) throws IOException {
        this(new InetSocketAddress(address, port), null, false, null);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(address, port), null, false, appHandler);
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(hostname, port), null, false, appHandler);
    }

    public NonBlockingConnection(InetAddress address, int port, SSLContext sslContext, boolean startSSL) throws IOException {
        this(new InetSocketAddress(address, port), sslContext, startSSL, null);
    }

    public NonBlockingConnection(String hostname, int port, SSLContext sslContext, boolean startSSL) throws IOException {
        this(new InetSocketAddress(hostname, port), sslContext, startSSL, null);
    }

    private NonBlockingConnection(InetSocketAddress inetAddress, SSLContext sslContext, boolean startSSL, IHandler appHandler) throws IOException {
        this(NonBlockingConnection.createcClientIoSocketHandler(inetAddress, NonBlockingConnection.getGlobalMemoryManager(), NonBlockingConnection.getGlobalDispatcher()), sslContext, startSSL, NonBlockingConnection.getGlobalMemoryManager(), true, appHandler, appHandler instanceof IConnectHandler, appHandler instanceof IDisconnectHandler, appHandler instanceof IDataHandler, appHandler instanceof ITimeoutHandler);
        if (LOG.isLoggable(Level.FINE)) {
            if (appHandler instanceof IConnectionScoped) {
                LOG.fine("handler type IConnectionScoped is not supported in the client context");
            }
            if (appHandler instanceof ILifeCycle) {
                LOG.fine("ILifeCycle is not supported in the client context");
            }
        }
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler, IWorkerPool workerPool, int preallocationMemorySize) throws IOException {
        this(new InetSocketAddress(hostname, port), null, false, appHandler, workerPool, new MemoryManager(preallocationMemorySize, true));
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, IWorkerPool workerPool, int preallocationMemorySize) throws IOException {
        this(new InetSocketAddress(address, port), null, false, appHandler, workerPool, new MemoryManager(preallocationMemorySize, true));
    }

    private NonBlockingConnection(InetSocketAddress inetAddress, SSLContext sslContext, boolean startSSL, IHandler appHandler, IWorkerPool workerPool, IMemoryManager memoryManager) throws IOException {
        this(NonBlockingConnection.createcClientIoSocketHandler(inetAddress, memoryManager, NonBlockingConnection.newDispatcher("ClientDispatcher", memoryManager, workerPool)), sslContext, startSSL, memoryManager, true, appHandler, appHandler instanceof IConnectHandler, appHandler instanceof IDisconnectHandler, appHandler instanceof IDataHandler, appHandler instanceof ITimeoutHandler);
        if (LOG.isLoggable(Level.FINE)) {
            if (appHandler instanceof IConnectionScoped) {
                LOG.fine("handler type IConnectionScoped is not supported in the client context");
            }
            if (appHandler instanceof ILifeCycle) {
                LOG.fine("ILifeCycle is not supported in the client context");
            }
        }
    }

    NonBlockingConnection(IoSocketHandler socketHandler, SSLContext sslContext, boolean startSSL, IMemoryManager sslMemoryManager, boolean isClient, IHandler appHandler, boolean isConnectHandler, boolean isDisconnectHandler, boolean isDataHandler, boolean isTimeoutHandler) throws IOException {
        this.socketHandler = socketHandler;
        this.appHandler = appHandler;
        this.isConnectHandler = isConnectHandler;
        this.isDataHandler = isDataHandler;
        this.isDataHandler = isDataHandler;
        this.isTimeoutHandler = isTimeoutHandler;
        this.isDisconnectHandler = isDisconnectHandler;
        this.isClient = isClient;
        socketHandler.setIOEventHandler(new IOEventHandler());
        if (sslContext != null) {
            IoSSLHandler sslHandler = new IoSSLHandler(socketHandler, sslContext, startSSL, isClient, sslMemoryManager);
            this.setIOHandler(sslHandler);
            this.open();
        } else {
            this.setIOHandler(socketHandler);
            this.open();
        }
    }

    public void setIdleTimeoutSec(int timeoutInSec) {
        this.socketHandler.setIdleTimeoutMillis((long)timeoutInSec * 1000L);
        if (this.isClient) {
            this.getWatchdog().updateTimeoutCheckPeriod(this.socketHandler.getIdleTimeoutMillis(), this.socketHandler.getConnectionTimeoutMillis());
        }
    }

    public void setConnectionTimeoutSec(int timeoutSec) {
        this.socketHandler.setConnectionTimeoutMillis((long)timeoutSec * 1000L);
        if (this.isClient) {
            this.getWatchdog().updateTimeoutCheckPeriod(this.socketHandler.getIdleTimeoutMillis(), this.socketHandler.getConnectionTimeoutMillis());
        }
    }

    private TimeoutWatchdog getWatchdog() {
        if (this.timeoutWatchdog == null) {
            this.timeoutWatchdog = new TimeoutWatchdog();
            this.timeoutWatchdog.setDispatcher(this.socketHandler.getDispatcher());
        }
        return this.timeoutWatchdog;
    }

    public int getConnectionTimeoutSec() {
        return (int)(this.socketHandler.getConnectionTimeoutMillis() / 1000L);
    }

    public int getIdleTimeoutSec() {
        return (int)(this.socketHandler.getIdleTimeoutMillis() / 1000L);
    }

    public void setWriteTransferRate(int bytesPerSecond) throws ClosedConnectionException, IOException {
        IoDelayWriteHandler delayHandler = this.getDelayIOHandler();
        if (bytesPerSecond == Integer.MAX_VALUE) {
            if (delayHandler != null) {
                delayHandler.flushOutgoing();
                IoHandler ioHandler = delayHandler.getSuccessor();
                this.setIOHandler(ioHandler);
            }
        } else {
            if (delayHandler == null) {
                delayHandler = new IoDelayWriteHandler(this.getIOHandler());
                this.setIOHandler(delayHandler);
            }
            delayHandler.setWriteRateSec(bytesPerSecond);
        }
    }

    private IoDelayWriteHandler getDelayIOHandler() {
        IoHandler ioHandler = this.getIOHandler();
        do {
            if (!(ioHandler instanceof IoDelayWriteHandler)) continue;
            return (IoDelayWriteHandler)ioHandler;
        } while ((ioHandler = ioHandler.getSuccessor()) != null);
        return null;
    }

    public int getNumberOfAvailableBytes() {
        return this.getReadQueue().getSize();
    }

    public ByteBuffer[] readAvailable() throws IOException, ClosedConnectionException {
        LinkedList<ByteBuffer> buffers = this.extractAvailableFromReadQueue();
        if (buffers != null) {
            return buffers.toArray(new ByteBuffer[buffers.size()]);
        }
        return new ByteBuffer[0];
    }

    public boolean readAvailableByDelimiter(String delimiter, WritableByteChannel outputChannel) throws IOException, ClosedConnectionException {
        return this.extractAvailableFromReadQueue(delimiter, outputChannel);
    }

    public int read(ByteBuffer buffer) throws IOException {
        ByteBuffer[] bufs;
        int savedPos = buffer.position();
        int savedLimit = buffer.limit();
        int size = buffer.remaining();
        int available = this.getNumberOfAvailableBytes();
        if (available < size) {
            size = available;
        }
        for (ByteBuffer buf : bufs = this.readByteBufferByLength(size)) {
            while (buf.hasRemaining()) {
                buffer.put(buf);
            }
        }
        buffer.position(savedPos);
        buffer.limit(savedLimit);
        return size;
    }

    public byte readByte() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractByteFromReadQueue();
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException, BufferUnderflowException {
        LinkedList<ByteBuffer> result = this.extractBytesByDelimiterFromReadQueue(delimiter, maxLength);
        return result.toArray(new ByteBuffer[result.size()]);
    }

    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException {
        LinkedList<ByteBuffer> extracted = this.extractBytesByLength(length);
        return extracted.toArray(new ByteBuffer[extracted.size()]);
    }

    public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException, BufferUnderflowException {
        return DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, maxLength));
    }

    public byte[] readBytesByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return DataConverter.toBytes(this.readByteBufferByLength(length));
    }

    public double readDouble() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractDoubleFromReadQueue();
    }

    public int readInt() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractIntFromReadQueue();
    }

    public long readLong() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractLongFromReadQueue();
    }

    public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        return this.readStringByDelimiter(delimiter, this.getDefaultEncoding(), maxLength);
    }

    public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        LinkedList<ByteBuffer> extracted = this.extractBytesByDelimiterFromReadQueue(delimiter, maxLength);
        return DataConverter.toString(extracted, encoding);
    }

    public String readStringByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByLength(length, this.getDefaultEncoding());
    }

    public String readStringByLength(int length, String encoding) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        LinkedList<ByteBuffer> extracted = this.extractBytesByLength(length);
        return DataConverter.toString(extracted, encoding);
    }

    void onConnectionTimeout() {
        block5: {
            try {
                if (this.isTimeoutHandler) {
                    boolean handled = ((ITimeoutHandler)this.appHandler).onConnectionTimeout(this);
                    this.flush();
                    if (!handled) {
                        this.close();
                    }
                } else {
                    this.close();
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.fine("error occured by handling connection timeout event. Reason: " + e.toString());
            }
        }
    }

    void onIdleTimeout() {
        block5: {
            try {
                if (this.isTimeoutHandler) {
                    boolean handled = ((ITimeoutHandler)this.appHandler).onIdleTimeout(this);
                    this.flush();
                    if (!handled) {
                        this.close();
                    }
                } else {
                    this.close();
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.fine("error occured by handling idle timeout event. Reason: " + e.toString());
            }
        }
    }

    private static synchronized Timer getTimer() {
        if (watchDogTimer == null) {
            watchDogTimer = new Timer("NBConnectionWatchdogTimer", true);
        }
        return watchDogTimer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TimeoutWatchdog {
        private TimerTask watchdogTimerTask = null;
        private IDispatcher<IoSocketHandler> dispatcher = null;

        private TimeoutWatchdog() {
        }

        synchronized void setDispatcher(IDispatcher<IoSocketHandler> dispatcher) {
            this.dispatcher = dispatcher;
        }

        void updateTimeoutCheckPeriod(long idleTimeoutMillis, long connectionTimeoutMillis) {
            long period = idleTimeoutMillis;
            if (connectionTimeoutMillis < idleTimeoutMillis) {
                period = connectionTimeoutMillis;
            }
            this.setTimeoutCheckPeriod((int)((double)period / 5.0));
        }

        private void setTimeoutCheckPeriod(long period) {
            if (this.watchdogTimerTask != null) {
                this.watchdogTimerTask.cancel();
            }
            this.watchdogTimerTask = new TimerTask(){

                public void run() {
                    TimeoutWatchdog.this.checkDispatcherTimeout();
                }
            };
            NonBlockingConnection.getTimer().schedule(this.watchdogTimerTask, period, period);
        }

        void shutdown() {
            if (this.watchdogTimerTask != null) {
                this.watchdogTimerTask.cancel();
            }
        }

        private synchronized void checkDispatcherTimeout() {
            block3: {
                try {
                    long current = System.currentTimeMillis();
                    Set<IoSocketHandler> socketHandlers = this.dispatcher.getRegistered();
                    for (IoSocketHandler socketHandler : socketHandlers) {
                        this.checkTimeout(socketHandler, current);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("error occured: " + e.toString());
                }
            }
        }

        private void checkTimeout(IoSocketHandler ioSocketHandler, long current) {
            ioSocketHandler.checkIdleTimeout(current);
            ioSocketHandler.checkConnectionTimeout(current);
        }
    }

    private final class IOEventHandler
    implements IoHandler.IIOEventHandler {
        private IOEventHandler() {
        }

        public void onDataEvent() {
            NonBlockingConnection.this.receive();
            if (NonBlockingConnection.this.isDataHandler) {
                try {
                    int readQueueSizeBefore = 0;
                    int readQueueSizeAfter = 0;
                    do {
                        readQueueSizeBefore = NonBlockingConnection.this.getReadQueue().getSize();
                        ((IDataHandler)NonBlockingConnection.this.appHandler).onData(NonBlockingConnection.this);
                        NonBlockingConnection.this.flush();
                    } while ((readQueueSizeAfter = NonBlockingConnection.this.getReadQueue().getSize()) != 0 && readQueueSizeAfter != readQueueSizeBefore);
                }
                catch (MaxReadSizeExceededException mee) {
                    try {
                        NonBlockingConnection.this.flush();
                    }
                    catch (Exception fe) {
                        // empty catch block
                    }
                    LOG.warning("unhandled " + mee.getClass().getSimpleName() + " exception occured");
                }
                catch (BufferUnderflowException bue) {
                    try {
                        NonBlockingConnection.this.flush();
                    }
                    catch (Exception fe) {}
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling data. Reason: " + e.toString());
                    }
                    try {
                        NonBlockingConnection.this.flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public boolean listenForConnect() {
            return NonBlockingConnection.this.isConnectHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnectEvent() {
            if (NonBlockingConnection.this.isConnectHandler) {
                try {
                    ((IConnectHandler)NonBlockingConnection.this.appHandler).onConnect(NonBlockingConnection.this);
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling connect. Reason: " + e.toString());
                    }
                }
                finally {
                    try {
                        NonBlockingConnection.this.flush();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        public boolean listenForDisconnect() {
            return NonBlockingConnection.this.isDisconnectHandler;
        }

        public boolean listenForWritten() {
            return false;
        }

        public void onWrittenEvent() {
        }

        public void onWriteExceptionEvent(IOException ioe) {
        }

        public void onDisconnectEvent() {
            block3: {
                if (NonBlockingConnection.this.isDisconnectHandler) {
                    try {
                        ((IDisconnectHandler)NonBlockingConnection.this.appHandler).onDisconnect(NonBlockingConnection.this);
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling connect. Reason: " + e.toString());
                    }
                }
            }
        }

        public void onConnectionTimeout() {
            block7: {
                if (NonBlockingConnection.this.isTimeoutHandler) {
                    try {
                        boolean isHandled = ((ITimeoutHandler)NonBlockingConnection.this.appHandler).onConnectionTimeout(NonBlockingConnection.this);
                        if (!isHandled) {
                            NonBlockingConnection.this.close();
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling onConnectionTimeout. Reason: " + e.toString());
                        }
                        break block7;
                    }
                }
                try {
                    NonBlockingConnection.this.close();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block7;
                    LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured closing connection caused by connection timeout. Reason: " + ioe.toString());
                }
            }
        }

        public void onIdleTimeout() {
            block7: {
                if (NonBlockingConnection.this.isTimeoutHandler) {
                    try {
                        boolean isHandled = ((ITimeoutHandler)NonBlockingConnection.this.appHandler).onIdleTimeout(NonBlockingConnection.this);
                        if (!isHandled) {
                            NonBlockingConnection.this.close();
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling onIdleTimeout. Reason: " + e.toString());
                        }
                        break block7;
                    }
                }
                try {
                    NonBlockingConnection.this.close();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block7;
                    LOG.fine("[" + NonBlockingConnection.this.getId() + "]  error occured closing connection caused by idle timeout. Reason: " + ioe.toString());
                }
            }
        }
    }
}

