/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.datagram.AbstractChannelBasedEndpoint;
import org.xsocket.datagram.DatagramSocketConfiguration;
import org.xsocket.datagram.IConnectedEndpoint;
import org.xsocket.datagram.IDatagramHandler;
import org.xsocket.datagram.UserDatagram;

public final class ConnectedEndpoint
extends AbstractChannelBasedEndpoint
implements IConnectedEndpoint {
    private static final Logger LOG = Logger.getLogger(ConnectedEndpoint.class.getName());
    private SocketAddress remoteAddress = null;

    public ConnectedEndpoint(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port));
    }

    public ConnectedEndpoint(String host, int port, DatagramSocketConfiguration socketConfiguration) throws IOException {
        this((SocketAddress)new InetSocketAddress(host, port), socketConfiguration);
    }

    public ConnectedEndpoint(SocketAddress remoteAddress) throws IOException {
        this(remoteAddress, -1);
    }

    public ConnectedEndpoint(SocketAddress remoteAddress, DatagramSocketConfiguration socketConfiguration) throws IOException {
        this(remoteAddress, socketConfiguration, -1);
    }

    public ConnectedEndpoint(SocketAddress remoteAddress, int receivePacketSize) throws IOException {
        this(remoteAddress, receivePacketSize, null);
    }

    public ConnectedEndpoint(SocketAddress remoteAddress, DatagramSocketConfiguration socketConfiguration, int receivePacketSize) throws IOException {
        this(remoteAddress, socketConfiguration, receivePacketSize, null);
    }

    public ConnectedEndpoint(String host, int port, int receivePacketSize) throws IOException {
        this(new InetSocketAddress(host, port), null, receivePacketSize, null);
    }

    public ConnectedEndpoint(String host, int port, DatagramSocketConfiguration socketConfiguration, int receivePacketSize) throws IOException {
        this(new InetSocketAddress(host, port), socketConfiguration, receivePacketSize, null);
    }

    public ConnectedEndpoint(SocketAddress remoteAddress, int receivePacketSize, IDatagramHandler datagramHandler) throws IOException {
        this(remoteAddress, null, receivePacketSize, datagramHandler);
    }

    public ConnectedEndpoint(SocketAddress remoteAddress, DatagramSocketConfiguration socketConfiguration, int receivePacketSize, IDatagramHandler datagramHandler) throws IOException {
        super(InetAddress.getLocalHost(), 0, socketConfiguration, datagramHandler, receivePacketSize);
        this.remoteAddress = remoteAddress;
        this.getChannel().connect(remoteAddress);
    }

    public void send(UserDatagram packet) throws IOException {
        if (LOG.isLoggable(Level.FINER) && packet.getRemoteSocketAddress() != null) {
            LOG.fine("remote address of given packet is already set with " + packet.getRemoteSocketAddress() + ". this value will be overriden by " + this.remoteAddress);
        }
        packet.setRemoteAddress(this.remoteAddress);
        super.send(packet);
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.remoteAddress;
    }
}

