/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;

public final class DatagramSocketConfiguration {
    private final Map<Integer, Object> options = new HashMap<Integer, Object>();

    void setOptions(DatagramSocket socket) throws SocketException {
        for (Map.Entry<Integer, Object> entry : this.options.entrySet()) {
            DatagramSocketConfiguration.setOption(socket, entry.getKey(), entry.getValue());
        }
    }

    static void setOption(DatagramSocket socket, int optID, Object value) throws SocketException {
        switch (optID) {
            case 4102: {
                socket.setSoTimeout((Integer)value);
                break;
            }
            case 4097: {
                socket.setSendBufferSize((Integer)value);
                break;
            }
            case 4: {
                socket.setReuseAddress((Boolean)value);
                break;
            }
            case 4098: {
                socket.setReceiveBufferSize((Integer)value);
                break;
            }
            case 3: {
                socket.setTrafficClass((Integer)value);
                break;
            }
        }
    }

    static Object getOption(DatagramSocket socket, int optID) throws SocketException {
        switch (optID) {
            case 4102: {
                return socket.getSoTimeout();
            }
            case 4097: {
                return socket.getSendBufferSize();
            }
            case 4: {
                return socket.getReuseAddress();
            }
            case 4098: {
                return socket.getReceiveBufferSize();
            }
            case 3: 
            case 128: {
                return socket.getTrafficClass();
            }
        }
        throw new RuntimeException("unsupported option id: " + optID);
    }

    public void setSO_TIMEOUT(Integer i) {
        this.options.put(4102, i);
    }

    public void setSO_SNDBUF(Integer i) {
        this.options.put(4097, i);
    }

    public void setSO_RCVBUF(Integer i) {
        this.options.put(4098, i);
    }

    public void setSO_REUSEADDR(Boolean b) {
        this.options.put(4, b);
    }

    public void setIP_TOS(Integer i) {
        this.options.put(3, i);
    }
}

