/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.Connection;
import org.xsocket.stream.IConnection;
import org.xsocket.stream.WaitTimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractConnectionPool {
    private static final Logger LOG = Logger.getLogger(AbstractConnectionPool.class.getName());
    static final long MIN_CHECKPERIOD_MILLIS = 60000L;
    static final long NULL = -1L;
    static final int MAX_SIZE = Integer.MAX_VALUE;
    static final long MAX_TIMEOUT = Long.MAX_VALUE;
    static final int CREATE_CONNECTION_TIMEOUT = 250;
    private final Timer timer = new Timer("ConPoolWatchdog", true);
    private int maxActive = Integer.MAX_VALUE;
    private int maxIdle = 3;
    private long maxWaitMillis = 0L;
    private long idleTimeoutMillis = Long.MAX_VALUE;
    private long lifeTimeoutMillis = Long.MAX_VALUE;
    private boolean isOpen = true;
    private final Map<InetSocketAddress, List<PoolableConnection>> idlePool = new HashMap<InetSocketAddress, List<PoolableConnection>>();
    private final Set<PoolableConnection> activePool = new HashSet<PoolableConnection>();
    private long checkPeriod = 0L;
    private TimerTask watchDogTask = null;
    private final List<ILifeCycle> listeners = new ArrayList<ILifeCycle>();

    AbstractConnectionPool(long idleTimeoutMillis, long lifeTimeoutMillis, int maxActive, long maxWaitMillis, int maxIdle) {
        this.idleTimeoutMillis = idleTimeoutMillis;
        this.lifeTimeoutMillis = lifeTimeoutMillis;
        this.maxActive = maxActive;
        this.maxWaitMillis = maxWaitMillis;
        this.maxIdle = maxIdle;
        this.resetCheckPeriod();
    }

    public final synchronized void destroyConnection(IConnection connection) throws IOException {
        if (connection instanceof PoolableConnection) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("destroying connection " + connection.getId());
            }
            this.activePool.remove(connection);
            ((PoolableConnection)connection).reallyClose();
        } else {
            connection.close();
        }
    }

    public void addListener(ILifeCycle listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(ILifeCycle listener) {
        boolean result = this.listeners.remove(listener);
        return result;
    }

    private void resetCheckPeriod() {
        if (this.watchDogTask != null) {
            this.watchDogTask.cancel();
        }
        this.watchDogTask = new TimerTask(){

            public void run() {
                Thread.currentThread().setPriority(1);
                List idleConnections = AbstractConnectionPool.this.idleConnectionList();
                AbstractConnectionPool.this.checkTimeout(idleConnections);
                AbstractConnectionPool.this.checkSize(idleConnections);
            }
        };
        long time = 60000L;
        if (this.lifeTimeoutMillis / 5L < time) {
            time = this.lifeTimeoutMillis / 5L;
        }
        if (this.idleTimeoutMillis / 5L < time) {
            time = this.idleTimeoutMillis / 5L;
        }
        this.checkPeriod = time;
        this.timer.schedule(this.watchDogTask, this.checkPeriod, this.checkPeriod);
    }

    final long getCheckPeriodMillis() {
        return this.checkPeriod;
    }

    public final synchronized int getMaxActive() {
        return this.maxActive;
    }

    public final synchronized void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
        this.notifyAll();
    }

    public final synchronized long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public final synchronized void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
        this.notifyAll();
    }

    public final synchronized int getMaxIdle() {
        return this.maxIdle;
    }

    public final synchronized void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        this.notifyAll();
    }

    public final synchronized int getNumActive() {
        return this.activePool.size();
    }

    public final synchronized int getNumIdle() {
        int size = 0;
        for (List<PoolableConnection> connectionList : this.idlePool.values()) {
            size += connectionList.size();
        }
        return size;
    }

    public final long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    public final void setIdleTimeoutMillis(long idleTimeoutMillis) {
        this.idleTimeoutMillis = idleTimeoutMillis;
        this.resetCheckPeriod();
    }

    public final long getLifeTimeoutMillis() {
        return this.lifeTimeoutMillis;
    }

    public final void setLifeTimeoutMillis(long lifeTimeoutMillis) {
        this.lifeTimeoutMillis = lifeTimeoutMillis;
        this.resetCheckPeriod();
    }

    synchronized List<String> getConnectionInfo() {
        ArrayList<String> info = new ArrayList<String>();
        for (PoolableConnection activeConnection : this.activePool) {
            info.add(activeConnection.toString());
        }
        for (PoolableConnection idleConnection : this.idleConnectionList()) {
            info.add(idleConnection.toString());
        }
        return info;
    }

    final synchronized PoolableConnection getConnection(InetSocketAddress address) throws IOException, WaitTimeoutException {
        if (this.isOpen) {
            PoolableConnection poolableConnection = this.getConnectionFromPool(address);
            if (poolableConnection == null) {
                if (this.maxWaitMillis == -1L) {
                    poolableConnection = this.newConnection(address);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("new connection to " + poolableConnection.getId() + " has been established (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ")");
                    }
                } else if (this.activePool.size() < this.maxActive) {
                    poolableConnection = this.newConnection(address);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("new connection to " + poolableConnection.getId() + " has been established (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ")");
                    }
                } else {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("no free connection available waiting for a free connection (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ")");
                    }
                    long start = System.currentTimeMillis();
                    while (System.currentTimeMillis() - start < this.maxWaitMillis) {
                        try {
                            this.wait(this.maxWaitMillis - (System.currentTimeMillis() - start));
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        if ((poolableConnection = this.getConnectionFromPool(address)) == null) continue;
                    }
                    if (poolableConnection == null) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("wait timeout reached (" + DataConverter.toFormatedDuration(this.maxWaitMillis) + ")");
                        }
                        throw new WaitTimeoutException("wait timeout reached (" + DataConverter.toFormatedDuration(this.maxWaitMillis) + ")");
                    }
                }
            }
            if (poolableConnection != null) {
                this.activePool.add(poolableConnection);
                poolableConnection.setStateActive();
            }
            return poolableConnection;
        }
        throw new RuntimeException("pool is already closed");
    }

    private PoolableConnection getConnectionFromPool(InetSocketAddress address) throws IOException {
        List<PoolableConnection> connectionList = this.idlePool.get(address);
        if (connectionList != null && !connectionList.isEmpty()) {
            PoolableConnection poolableConnection = connectionList.remove(0);
            if (this.isConnectionValid(System.currentTimeMillis(), poolableConnection)) {
                poolableConnection.reset();
                if (connectionList.isEmpty()) {
                    this.idlePool.remove(address);
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("got connection to " + poolableConnection.getId() + " from pool (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ")");
                }
                return poolableConnection;
            }
            return this.getConnectionFromPool(address);
        }
        return null;
    }

    final String getAddressString(String host, int port) {
        return host + ":" + port;
    }

    final synchronized void returnConnection(PoolableConnection poolableConnection) throws IOException {
        this.activePool.remove(poolableConnection);
        poolableConnection.setStateIdle();
        if (this.isOpen) {
            if (!this.isConnectionValid(System.currentTimeMillis(), poolableConnection)) {
                poolableConnection.reallyClose();
                return;
            }
            this.addConnectionToPool(poolableConnection);
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("pool is already closed destroy returned connection to " + poolableConnection.getId());
            }
            poolableConnection.reallyClose();
        }
        this.notifyAll();
    }

    private void addConnectionToPool(PoolableConnection connection) throws IOException {
        if (this.idlePool.size() < this.maxIdle) {
            List<PoolableConnection> connectionList = this.idlePool.get(connection.getAddress());
            if (connectionList == null) {
                connectionList = new ArrayList<PoolableConnection>();
                this.idlePool.put(connection.getAddress(), connectionList);
            }
            connectionList.add(connection);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("connection to " + connection.getId() + " has been inserted into the pool (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ")");
            }
        } else {
            connection.reallyClose();
        }
    }

    public final synchronized void close() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("closing (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ")");
        }
        this.timer.cancel();
        for (List<PoolableConnection> connectionList : this.idlePool.values()) {
            for (PoolableConnection connection : connectionList) {
                try {
                    connection.reallyClose();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("error occured by (really) closing of conection " + connection.getId() + ". Reason: " + e.toString());
                }
            }
        }
        this.idlePool.clear();
        for (ILifeCycle lifeCycle : this.listeners) {
            lifeCycle.onDestroy();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ")";
    }

    private boolean isConnectionValid(long currentTime, PoolableConnection poolableConnection) {
        if (!poolableConnection.isOpen()) {
            return false;
        }
        if (this.idleTimeoutMillis != Long.MAX_VALUE && currentTime > poolableConnection.getLastUsageTime() + this.idleTimeoutMillis) {
            return false;
        }
        return this.lifeTimeoutMillis == Long.MAX_VALUE || currentTime <= poolableConnection.getCreationTime() + this.lifeTimeoutMillis;
    }

    private void checkTimeout(List<PoolableConnection> idleConnections) {
        long currentTime = System.currentTimeMillis();
        for (PoolableConnection poolableConnection : idleConnections) {
            if (this.isConnectionValid(currentTime, poolableConnection)) continue;
            this.closeConnection(poolableConnection, "auto");
        }
    }

    private void checkSize(List<PoolableConnection> idleConnections) {
        if (idleConnections.size() > this.maxIdle) {
            for (int i = 0; i < idleConnections.size() - this.maxIdle; ++i) {
                PoolableConnection poolableConnection = idleConnections.get(i);
                this.closeConnection(poolableConnection, "auto");
            }
        }
    }

    private synchronized List<PoolableConnection> idleConnectionList() {
        ArrayList<PoolableConnection> idleConnections = new ArrayList<PoolableConnection>();
        for (List<PoolableConnection> connectionList : this.idlePool.values()) {
            idleConnections.addAll(connectionList);
        }
        return idleConnections;
    }

    private synchronized boolean closeConnection(PoolableConnection poolableConnection, String reason) {
        assert (poolableConnection != null);
        List<PoolableConnection> connectionList = this.idlePool.get(poolableConnection.getAddress());
        if (connectionList.contains(poolableConnection)) {
            block5: {
                connectionList.remove(poolableConnection);
                try {
                    poolableConnection.reallyClose();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("error occured by (really) closing of conection " + poolableConnection.getId() + ". Reason: " + e.toString());
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(reason + " close of connection " + poolableConnection.getId() + " (idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ")");
            }
            return true;
        }
        return false;
    }

    private PoolableConnection newConnection(InetSocketAddress address) {
        int trials = 0;
        int sleepTime = 3;
        long start = System.currentTimeMillis();
        PoolableConnection connection = null;
        while (true) {
            ++trials;
            try {
                connection = this.createConnection(address);
                return connection;
            }
            catch (IOException ioe) {
                sleepTime *= 3;
                try {
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (System.currentTimeMillis() < start + 250L) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by creating connection to " + address + ". creation timeout " + 250 + " reached. (" + trials + " trials done)");
                }
                return null;
            }
            break;
        }
    }

    abstract PoolableConnection createConnection(InetSocketAddress var1) throws IOException;

    abstract class PoolableConnection
    implements IConnection {
        private AbstractConnectionPool pool = null;
        private InetSocketAddress address = null;
        private Connection delegee;
        private long creationTime = System.currentTimeMillis();
        private long lastUsageTime = System.currentTimeMillis();
        private boolean isActive = false;
        private long enteredState = System.currentTimeMillis();

        public PoolableConnection(AbstractConnectionPool pool, Connection delegee, InetSocketAddress address) throws IOException {
            this.pool = pool;
            this.delegee = delegee;
            this.address = address;
        }

        final void setStateActive() {
            this.isActive = true;
            this.enteredState = System.currentTimeMillis();
        }

        final void setStateIdle() {
            this.isActive = false;
            this.enteredState = System.currentTimeMillis();
        }

        final boolean isActive() {
            return this.isActive;
        }

        final long getStateEntered() {
            return this.enteredState;
        }

        final Connection getDelegee() {
            return this.delegee;
        }

        final InetSocketAddress getAddress() {
            return this.address;
        }

        final long getLastUsageTime() {
            return this.lastUsageTime;
        }

        final long getCreationTime() {
            return this.creationTime;
        }

        public void close() throws IOException {
            if (this.delegee.isOpen()) {
                this.lastUsageTime = System.currentTimeMillis();
                this.pool.returnConnection(this);
            }
        }

        final void reset() throws IOException {
            this.delegee.reset();
        }

        void reallyClose() throws IOException {
            this.delegee.close();
        }

        public void flush() throws ClosedConnectionException, IOException, SocketTimeoutException {
            this.delegee.flush();
        }

        public boolean isOpen() {
            return this.delegee.isOpen();
        }

        public void activateSecuredMode() throws IOException {
            throw new UnsupportedOperationException("activateSecuredMode is not supported for a pooled connection");
        }

        public boolean getAutoflush() {
            return this.delegee.getAutoflush();
        }

        public void setAutoflush(boolean autoflush) {
            this.delegee.setAutoflush(autoflush);
        }

        public void setDefaultEncoding(String encoding) {
            this.delegee.setDefaultEncoding(encoding);
        }

        public String getDefaultEncoding() {
            return this.delegee.getDefaultEncoding();
        }

        public int getIndexOf(String str) throws IOException, ClosedConnectionException {
            return this.delegee.getIndexOf(str);
        }

        public int getIndexOf(String str, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException {
            return this.delegee.getIndexOf(str, maxLength);
        }

        public int read(ByteBuffer buffer) throws IOException {
            return this.delegee.read(buffer);
        }

        public byte readByte() throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readByte();
        }

        public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readByteBufferByDelimiter(delimiter);
        }

        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, SocketTimeoutException, MaxReadSizeExceededException {
            return this.delegee.readByteBufferByDelimiter(delimiter, maxLength);
        }

        public ByteBuffer[] readByteBufferByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readByteBufferByLength(length);
        }

        public byte[] readBytesByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readBytesByDelimiter(delimiter);
        }

        public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, SocketTimeoutException, MaxReadSizeExceededException {
            return this.delegee.readBytesByDelimiter(delimiter, maxLength);
        }

        public byte[] readBytesByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readBytesByLength(length);
        }

        public double readDouble() throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readDouble();
        }

        public int readInt() throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readInt();
        }

        public long readLong() throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readLong();
        }

        public String readStringByDelimiter(String delimiter) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException {
            return this.delegee.readStringByDelimiter(delimiter);
        }

        public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException, MaxReadSizeExceededException {
            return this.delegee.readStringByDelimiter(delimiter, maxLength);
        }

        public String readStringByDelimiter(String delimiter, String encoding) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException {
            return this.delegee.readStringByDelimiter(delimiter, encoding);
        }

        public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException, MaxReadSizeExceededException {
            return this.delegee.readStringByDelimiter(delimiter, encoding, maxLength);
        }

        public int indexOf(String str) throws IOException, ClosedConnectionException {
            return this.delegee.indexOf(str);
        }

        public String readStringByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readStringByLength(length);
        }

        public String readStringByLength(int length, String encoding) throws IOException, ClosedConnectionException, SocketTimeoutException {
            return this.delegee.readStringByLength(length, encoding);
        }

        public void removeReadMark() {
            this.delegee.removeReadMark();
        }

        public void removeWriteMark() {
            this.delegee.removeWriteMark();
        }

        public void markReadPosition() {
            this.delegee.markReadPosition();
        }

        public void markWritePosition() {
            this.delegee.markWritePosition();
        }

        public boolean resetToReadMark() {
            return this.delegee.resetToReadMark();
        }

        public boolean resetToWriteMark() {
            return this.delegee.resetToWriteMark();
        }

        public String getId() {
            return this.delegee.getId();
        }

        public InetAddress getLocalAddress() {
            return this.delegee.getLocalAddress();
        }

        public int getLocalPort() {
            return this.delegee.getLocalPort();
        }

        public InetAddress getRemoteAddress() {
            return this.delegee.getRemoteAddress();
        }

        public int getRemotePort() {
            return this.delegee.getRemotePort();
        }

        public int write(byte b) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(b);
        }

        public int write(byte ... bytes) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(bytes);
        }

        public int write(byte[] bytes, int offset, int length) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(bytes, offset, length);
        }

        public int write(ByteBuffer buffer) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(buffer);
        }

        public long write(ByteBuffer[] arg0, int arg1, int arg2) throws IOException {
            return this.delegee.write(arg0, arg1, arg2);
        }

        public long write(ByteBuffer[] buffers) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(buffers);
        }

        public int write(double d) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(d);
        }

        public int write(int i) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(i);
        }

        public int write(long l) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(l);
        }

        public int write(String message) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(message);
        }

        public int write(String message, String encoding) throws ClosedConnectionException, IOException, SocketTimeoutException {
            return this.delegee.write(message, encoding);
        }

        public Object attach(Object obj) {
            return this.delegee.attach(obj);
        }

        public Object attachment() {
            return this.delegee.attachment();
        }

        public String toString() {
            String state = "idle";
            if (this.isActive()) {
                state = "active";
            }
            return "[" + state + ", since " + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.getStateEntered()) + "] " + this.delegee.toString();
        }
    }
}

