/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.Connection;
import org.xsocket.stream.IBlockingConnection;
import org.xsocket.stream.IConnection;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.IoSocketHandler;
import org.xsocket.stream.StreamSocketConfiguration;

public final class BlockingConnection
extends Connection
implements IBlockingConnection {
    private Object readGuard = new Object();
    private long receiveTimeout = 0L;

    public BlockingConnection(String hostname, int port) throws IOException {
        this(new InetSocketAddress(hostname, port), null, null, false);
    }

    public BlockingConnection(String hostname, int port, StreamSocketConfiguration socketConfiguration) throws IOException {
        this(new InetSocketAddress(hostname, port), socketConfiguration, null, false);
    }

    public BlockingConnection(InetAddress address, int port) throws IOException {
        this(new InetSocketAddress(address, port), null, null, false);
    }

    public BlockingConnection(InetAddress address, int port, StreamSocketConfiguration socketConf) throws IOException {
        this(new InetSocketAddress(address, port), socketConf, null, false);
    }

    public BlockingConnection(InetAddress address, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), null, sslContext, sslOn);
    }

    public BlockingConnection(InetAddress address, int port, StreamSocketConfiguration socketConf, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), socketConf, sslContext, sslOn);
    }

    public BlockingConnection(String hostname, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), null, sslContext, sslOn);
    }

    public BlockingConnection(String hostname, int port, StreamSocketConfiguration socketConf, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), socketConf, sslContext, sslOn);
    }

    private BlockingConnection(InetSocketAddress remoteAddress, StreamSocketConfiguration socketConf, SSLContext sslContext, boolean sslOn) throws IOException {
        this(BlockingConnection.createClientIoSocketHandler(remoteAddress, BlockingConnection.getGlobalMemoryManager(), BlockingConnection.getGlobalDispatcher(), socketConf), sslContext, sslOn, BlockingConnection.getGlobalMemoryManager());
    }

    private BlockingConnection(IoSocketHandler socketHandler, SSLContext sslContext, boolean sslOn, IMemoryManager sslMemoryManager) throws IOException {
        this.setReceiveTimeoutMillis(60000L);
        this.setFlushmode(IConnection.FlushMode.SYNC);
        this.init(socketHandler, sslContext, sslOn, true, sslMemoryManager);
    }

    void reset() {
        this.readGuard = new Object();
        super.reset();
        this.setReceiveTimeoutMillis(60000L);
        this.setFlushmode(IConnection.FlushMode.SYNC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.extractByteFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    public final void setReceiveTimeoutMillis(long timeout) {
        this.receiveTimeout = timeout;
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.readByteBufferByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, SocketTimeoutException, MaxReadSizeExceededException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    LinkedList<ByteBuffer> result = this.extractBytesByDelimiterFromReadQueue(delimiter, maxLength);
                    return result.toArray(new ByteBuffer[result.size()]);
                }
                catch (MaxReadSizeExceededException mee) {
                    throw mee;
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        if (length <= 0) {
            return null;
        }
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    LinkedList<ByteBuffer> result = this.extractBytesByLength(length);
                    return result.toArray(new ByteBuffer[result.size()]);
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    public byte[] readBytesByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.readBytesByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, SocketTimeoutException, MaxReadSizeExceededException {
        return DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, maxLength));
    }

    public byte[] readBytesByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return DataConverter.toBytes(this.readByteBufferByLength(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readDouble() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.extractDoubleFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.extractIntFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(ByteBuffer buffer) throws IOException {
        int size = buffer.remaining();
        if (size < 1) {
            return 0;
        }
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            do {
                int availableSize;
                if ((availableSize = this.getReadQueue().getSize()) > 0) {
                    ByteBuffer[] bufs;
                    if (size > availableSize) {
                        size = availableSize;
                    }
                    for (ByteBuffer buf : bufs = this.readByteBufferByLength(size)) {
                        buffer.put(buf);
                    }
                    return size;
                }
                try {
                    this.readGuard.wait(remainingTime);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            } while ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L);
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.extractLongFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    public String readStringByDelimiter(String delimiter) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException, MaxReadSizeExceededException {
        return this.readStringByDelimiter(delimiter, this.getDefaultEncoding(), maxLength);
    }

    public String readStringByDelimiter(String delimiter, String encoding) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException, MaxReadSizeExceededException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    LinkedList<ByteBuffer> extracted = this.extractBytesByDelimiterFromReadQueue(delimiter, maxLength);
                    return DataConverter.toString(extracted, encoding);
                }
                catch (MaxReadSizeExceededException mle) {
                    throw mle;
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    public int getIndexOf(String str) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.getIndexOf(str, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexOf(String str, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.readIndexOf(str, maxLength);
                }
                catch (MaxReadSizeExceededException mle) {
                    throw mle;
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    public String readStringByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.readStringByLength(length, this.getDefaultEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readStringByLength(int length, String encoding) throws IOException, ClosedConnectionException, SocketTimeoutException {
        if (length <= 0) {
            return null;
        }
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    LinkedList<ByteBuffer> extracted = this.extractBytesByLength(length);
                    return DataConverter.toString(extracted, encoding);
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDataEvent() {
        Object object = this.readGuard;
        synchronized (object) {
            this.receive();
            this.readGuard.notify();
        }
    }
}

