/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.xsocket.stream.AbstractConnectionPool;
import org.xsocket.stream.BlockingConnection;
import org.xsocket.stream.IBlockingConnection;
import org.xsocket.stream.WaitTimeoutException;

public final class BlockingConnectionPool
extends AbstractConnectionPool {
    public static final long UNLIMITED_TIMEOUT = Long.MAX_VALUE;

    public BlockingConnectionPool(long timeToIdleMillis) {
        this(timeToIdleMillis, Integer.MAX_VALUE, -1L);
    }

    public BlockingConnectionPool(long timeToIdleMillis, int maxActive, long maxWaitTimeMillis) {
        super(timeToIdleMillis, Long.MAX_VALUE, maxActive, maxWaitTimeMillis, Integer.MAX_VALUE);
    }

    public IBlockingConnection getBlockingConnection(String host, int port) throws IOException, WaitTimeoutException {
        return (IBlockingConnection)((Object)this.getConnection(new InetSocketAddress(host, port)));
    }

    public IBlockingConnection getBlockingConnection(InetAddress address, int port) throws IOException, WaitTimeoutException {
        return (IBlockingConnection)((Object)this.getConnection(new InetSocketAddress(address, port)));
    }

    AbstractConnectionPool.PoolableConnection createConnection(InetSocketAddress address) throws IOException {
        return new PoolableBlockingConnection(address);
    }

    private final class PoolableBlockingConnection
    extends AbstractConnectionPool.PoolableConnection
    implements IBlockingConnection {
        public PoolableBlockingConnection(InetSocketAddress address) throws IOException {
            super(BlockingConnectionPool.this, new BlockingConnection(address.getAddress(), address.getPort()), address);
        }

        public void setReceiveTimeoutMillis(long timeout) {
            ((BlockingConnection)this.getDelegee()).setReceiveTimeoutMillis(timeout);
        }
    }
}

