/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ByteBufferParser {
    ByteBufferParser() {
    }

    public Index find(LinkedList<ByteBuffer> bufferQueue, String delimiter) {
        return this.find(bufferQueue, new Index(delimiter));
    }

    /*
     * Unable to fully structure code
     */
    public Index find(LinkedList<ByteBuffer> bufferQueue, Index index) {
        queueSize = bufferQueue.size();
        for (bufNr = Index.access$000(index); bufNr < queueSize && !Index.access$100(index); ++bufNr) {
            buffer = bufferQueue.get(bufNr);
            savedPos = buffer.position();
            savedLimit = buffer.limit();
            pos = 0;
            while (buffer.hasRemaining() && !Index.access$100(index)) {
                b = buffer.get();
                Index.access$208(index);
                if (Index.access$300(index) <= 0) ** GOTO lbl22
                if (b == Index.access$400(index)[Index.access$300(index)]) {
                    if (Index.access$300(index) + 1 == Index.access$500(index)) {
                        Index.access$102(index, true);
                        break;
                    }
                    Index.access$308(index);
                } else {
                    Index.access$302(index, 0);
lbl22:
                    // 2 sources

                    if (Index.access$300(index) == 0 && b == Index.access$400(index)[Index.access$300(index)]) {
                        Index.access$308(index);
                        if (Index.access$500(index) == 1) {
                            Index.access$102(index, true);
                            break;
                        }
                    }
                }
                ++pos;
            }
            Index.access$008(index);
            buffer.position(savedPos);
            buffer.limit(savedLimit);
        }
        return index;
    }

    public LinkedList<ByteBuffer> extract(LinkedList<ByteBuffer> inOutBuffer, int length) throws IOException, BufferUnderflowException {
        int bufLength;
        LinkedList<ByteBuffer> result = new LinkedList<ByteBuffer>();
        int remainingToExtract = length;
        ByteBuffer buffer = null;
        do {
            if ((buffer = inOutBuffer.remove()) == null) {
                throw new BufferUnderflowException();
            }
            bufLength = buffer.limit() - buffer.position();
            if (remainingToExtract < bufLength) {
                int savedLimit = buffer.limit();
                buffer.limit(buffer.position() + remainingToExtract);
                ByteBuffer leftPart = buffer.slice();
                result.addLast(leftPart);
                buffer.position(buffer.limit());
                buffer.limit(savedLimit);
                ByteBuffer rightPart = buffer.slice();
                inOutBuffer.addFirst(rightPart);
                break;
            }
            result.addLast(buffer);
        } while ((remainingToExtract -= bufLength) > 0);
        return result;
    }

    public LinkedList<ByteBuffer> extract(LinkedList<ByteBuffer> inOutBuffer, Index index) throws IOException {
        assert (index.isValid) : "Index is invalid";
        assert (index.hasDelimiterFound());
        LinkedList<ByteBuffer> result = this.extract(inOutBuffer, index.getReadBytes() - index.getDelimiterLength());
        this.extract(inOutBuffer, index.getDelimiterLength());
        return result;
    }

    public static final class Index {
        public static final int NULL = -1;
        private boolean isValid = true;
        private boolean hasDelimiterFound = false;
        private String delimiter = null;
        private byte[] delimiterBytes = null;
        private int delimiterLength = 0;
        private int delimiterPos = 0;
        private int scannedBuffers = 0;
        private int readBytes = 0;

        Index(String delimiter) {
            this.delimiter = delimiter;
            this.delimiterBytes = delimiter.getBytes();
            this.delimiterLength = this.delimiterBytes.length;
        }

        public boolean hasDelimiterFound() {
            return this.hasDelimiterFound;
        }

        public int getReadBytes() {
            return this.readBytes;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        int getDelimiterLength() {
            return this.delimiterLength;
        }

        public int getDelimiterPos() {
            return this.delimiterPos;
        }

        static /* synthetic */ int access$000(Index x0) {
            return x0.scannedBuffers;
        }

        static /* synthetic */ boolean access$100(Index x0) {
            return x0.hasDelimiterFound;
        }

        static /* synthetic */ int access$208(Index x0) {
            return x0.readBytes++;
        }

        static /* synthetic */ int access$300(Index x0) {
            return x0.delimiterPos;
        }

        static /* synthetic */ byte[] access$400(Index x0) {
            return x0.delimiterBytes;
        }

        static /* synthetic */ int access$500(Index x0) {
            return x0.delimiterLength;
        }

        static /* synthetic */ boolean access$102(Index x0, boolean x1) {
            x0.hasDelimiterFound = x1;
            return x0.hasDelimiterFound;
        }

        static /* synthetic */ int access$308(Index x0) {
            return x0.delimiterPos++;
        }

        static /* synthetic */ int access$302(Index x0, int x1) {
            x0.delimiterPos = x1;
            return x0.delimiterPos;
        }

        static /* synthetic */ int access$008(Index x0) {
            return x0.scannedBuffers++;
        }
    }
}

