/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketOptions;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.DynamicWorkerPool;
import org.xsocket.IDispatcher;
import org.xsocket.IWorkerPool;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.ByteBufferParser;
import org.xsocket.stream.ByteBufferQueue;
import org.xsocket.stream.IConnection;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.IoActivateableSSLHandler;
import org.xsocket.stream.IoHandler;
import org.xsocket.stream.IoSSLHandler;
import org.xsocket.stream.IoSocketDispatcher;
import org.xsocket.stream.IoSocketHandler;
import org.xsocket.stream.MemoryManager;
import org.xsocket.stream.StreamSocketConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Connection
implements IConnection {
    private static final Logger LOG = Logger.getLogger(Connection.class.getName());
    static final IConnection.FlushMode INITIAL_FLUSH_MODE = IConnection.FlushMode.SYNC;
    private static final long SEND_TIMEOUT = 60000L;
    private static final ByteBufferParser PARSER = new ByteBufferParser();
    private static IWorkerPool globalWorkerPool = null;
    private static IMemoryManager globalMemoryManager = null;
    private static IDispatcher<IoSocketHandler> globalDispatcher = null;
    private final ByteBufferQueue writeQueue = new ByteBufferQueue();
    private final ByteBufferQueue readQueue = new ByteBufferQueue();
    private IoHandler ioHandler = null;
    private String defaultEncoding = "UTF-8";
    private boolean autoflush = true;
    private IConnection.FlushMode flushmode = INITIAL_FLUSH_MODE;
    private ByteBufferParser.Index cachedIndex = null;
    private Object attachment = null;
    private Object writeGuard = new Object();
    private IOException writeException = null;
    private LinkedList<ByteBuffer> readMarkBuffer = null;
    private boolean isReadMarked = false;
    private WriteMarkBuffer writeMarkBuffer = null;
    private boolean isWriteMarked = false;
    private IoSocketHandler socketHandler = null;

    Connection() {
    }

    protected void init(IoSocketHandler socketHandler, SSLContext sslContext, boolean sslOn, boolean isClientMode, IMemoryManager sslMemoryManager) throws SocketException, IOException {
        this.socketHandler = socketHandler;
        socketHandler.setIOEventHandler(new IOEventHandler());
        if (sslContext != null) {
            if (sslOn) {
                this.setIOHandler(new IoSSLHandler(socketHandler, sslContext, isClientMode, sslMemoryManager));
            } else {
                this.setIOHandler(new IoActivateableSSLHandler(socketHandler, sslContext, isClientMode, sslMemoryManager));
            }
            this.open();
        } else {
            this.setIOHandler(socketHandler);
            this.open();
        }
    }

    void reset() {
        this.writeQueue.drain();
        this.writeGuard = new Object();
        this.writeException = null;
        this.setAutoflush(true);
        this.setFlushmode(INITIAL_FLUSH_MODE);
        this.setDefaultEncoding("UTF-8");
        this.removeReadMark();
        this.removeWriteMark();
        this.resetCachedIndex();
        this.attachment = null;
        this.ioHandler.drainIncoming();
        this.readQueue.drain();
    }

    protected final IoSocketHandler getIoSocketHandler() {
        return this.socketHandler;
    }

    void open() throws IOException {
        this.ioHandler.open();
    }

    final SocketOptions getSocketOptions() {
        return this.socketHandler.getSocketOptions();
    }

    final ByteBufferQueue getReadQueue() {
        return this.readQueue;
    }

    String printInQueue() {
        StringBuilder sb = new StringBuilder();
        if (this.readMarkBuffer != null) {
            ByteBuffer[] copy = new ByteBuffer[this.readMarkBuffer.size()];
            for (int i = 0; i < copy.length; ++i) {
                copy[i] = this.readMarkBuffer.get(i).duplicate();
            }
            sb.append("[" + DataConverter.toTextOrHexString(copy, "UTF-8", Integer.MAX_VALUE) + "] ");
        }
        sb.append(this.readQueue.toTextOrHexString());
        return sb.toString();
    }

    static final synchronized IWorkerPool getGlobalWorkerPool() {
        if (globalWorkerPool == null) {
            globalWorkerPool = new DynamicWorkerPool(0, 250);
        }
        return globalWorkerPool;
    }

    static synchronized IMemoryManager getGlobalMemoryManager() {
        if (globalMemoryManager == null) {
            globalMemoryManager = new MemoryManager(65536, true);
        }
        return globalMemoryManager;
    }

    static synchronized IDispatcher<IoSocketHandler> getGlobalDispatcher() {
        if (globalDispatcher == null) {
            globalDispatcher = Connection.newDispatcher("xGlobalDispatcher", new MemoryManager(65536, true));
        }
        return globalDispatcher;
    }

    static IoSocketDispatcher newDispatcher(String name, IMemoryManager memoryManager) {
        IoSocketDispatcher dispatcher = new IoSocketDispatcher(memoryManager);
        Thread t = new Thread(dispatcher);
        t.setName(name);
        t.setDaemon(true);
        t.start();
        return dispatcher;
    }

    static IoSocketHandler createClientIoSocketHandler(InetSocketAddress inetAddress, IMemoryManager memoryManager, IDispatcher<IoSocketHandler> dispatcher, StreamSocketConfiguration socketConfiguration) throws IOException {
        SocketChannel channel = SocketChannel.open();
        if (socketConfiguration != null) {
            socketConfiguration.setOptions(channel.socket());
        }
        channel.socket().connect(inetAddress);
        IoSocketHandler socketHdl = new IoSocketHandler(channel, "c.", dispatcher);
        socketHdl.setMemoryManager(memoryManager);
        while (!socketHdl.getChannel().finishConnect()) {
            try {
                Thread.sleep(25L);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Waiting to finish connection");
            }
            catch (InterruptedException ignore) {}
        }
        return socketHdl;
    }

    final IoHandler getIOHandler() {
        return this.ioHandler;
    }

    final void setIOHandler(IoHandler ioHdl) {
        this.ioHandler = ioHdl;
    }

    @Override
    public final void close() throws IOException {
        this.internalFlushStrong();
        this.ioHandler.close(false);
    }

    @Override
    public final boolean isOpen() {
        return this.ioHandler.isOpen();
    }

    final void writeIncoming(ByteBuffer data) {
        this.readQueue.append(data);
    }

    final void writeOutgoing(ByteBuffer data) {
        this.writeQueue.append(data);
    }

    void writeOutgoing(LinkedList<ByteBuffer> datas) {
        this.writeQueue.append(datas);
    }

    @Override
    public void flush() throws ClosedConnectionException, IOException {
        if (this.autoflush) {
            LOG.warning("flush has been called for a connection which is in autoflush mode (since xSocket V1.1 autoflush is activated by default)");
        }
        this.internalFlush();
    }

    void internalFlush() throws ClosedConnectionException, IOException {
        this.removeWriteMark();
        if (this.flushmode == IConnection.FlushMode.SYNC) {
            this.syncFlush();
        } else {
            this.flushWriteQueue();
        }
    }

    void setFlushmode(IConnection.FlushMode flushMode) {
        this.flushmode = flushMode;
    }

    IConnection.FlushMode getFlushmode() {
        return this.flushmode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFlush() throws ClosedConnectionException, IOException {
        long start = System.currentTimeMillis();
        long remainingTime = 60000L;
        Object object = this.writeGuard;
        synchronized (object) {
            this.flushWriteQueue();
            do {
                if (this.getIOHandler().isChainSendBufferEmpty()) {
                    return;
                }
                if (this.writeException != null) {
                    IOException ioe = this.writeException;
                    this.writeException = null;
                    throw ioe;
                }
                try {
                    this.writeGuard.wait(remainingTime);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            } while ((remainingTime = start + 60000L - System.currentTimeMillis()) > 0L);
        }
    }

    private void flushWriteQueue() throws ClosedConnectionException, IOException {
        if (!this.writeQueue.isEmpty()) {
            LinkedList<ByteBuffer> buffer = this.writeQueue.drain();
            this.ioHandler.writeOutgoing(buffer);
        }
    }

    private void internalFlushStrong() throws ClosedConnectionException, IOException {
        this.internalFlush();
        this.getIOHandler().flushOutgoing();
    }

    @Override
    public final String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public final void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    @Override
    public boolean getAutoflush() {
        return this.autoflush;
    }

    @Override
    public final String getId() {
        return this.ioHandler.getId();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.ioHandler.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.ioHandler.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.ioHandler.getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.ioHandler.getRemotePort();
    }

    void onIdleTimeout() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void onConnectionTimeout() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    final void receive() {
        LinkedList<ByteBuffer> buffers = this.getIOHandler().drainIncoming();
        if (LOG.isLoggable(Level.FINER)) {
            int received = 0;
            for (ByteBuffer buffer : buffers) {
                received += buffer.remaining();
            }
            LOG.finer("appending " + received + " bytes to connection's read queue");
        }
        this.getReadQueue().append(buffers);
    }

    @Override
    public void activateSecuredMode() throws IOException {
        IoHandler ioHandler = this.getIOHandler();
        while (!(ioHandler instanceof IoActivateableSSLHandler) && (ioHandler = ioHandler.getSuccessor()) != null) {
        }
        if (ioHandler != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("activating ssl");
            }
        } else {
            throw new IOException("couldn't startSSL, because no SSLHandler (SSLContext) is set");
        }
        IoActivateableSSLHandler sslHandler = (IoActivateableSSLHandler)ioHandler;
        sslHandler.stopProcessingIncoming();
        this.internalFlushStrong();
        sslHandler.startSSL(this.readQueue);
    }

    @Override
    public final int write(String s) throws ClosedConnectionException, IOException {
        return this.write(s, this.defaultEncoding);
    }

    @Override
    public final int write(String s, String encoding) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = DataConverter.toByteBuffer(s, encoding);
        return this.write(buffer);
    }

    @Override
    public final int write(byte b) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1).put(b);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(byte ... bytes) throws ClosedConnectionException, IOException {
        return this.write(ByteBuffer.wrap(bytes));
    }

    @Override
    public final int write(byte[] bytes, int offset, int length) throws ClosedConnectionException, IOException {
        return this.write(ByteBuffer.wrap(bytes, offset, length));
    }

    @Override
    public final long write(ByteBuffer[] buffers) throws ClosedConnectionException, IOException {
        if (this.isOpen()) {
            long written = 0L;
            for (ByteBuffer buffer : buffers) {
                written += (long)(buffer.limit() - buffer.position());
            }
            if (this.isWriteMarked) {
                for (ByteBuffer buffer : buffers) {
                    this.writeMarkBuffer.add(buffer);
                }
            } else {
                for (ByteBuffer buffer : buffers) {
                    this.writeQueue.append(buffer);
                }
            }
            if (this.autoflush) {
                this.internalFlush();
            }
            return written;
        }
        throw new ClosedConnectionException("connection " + this.getId() + " is already closed");
    }

    @Override
    public final int write(ByteBuffer buffer) throws ClosedConnectionException, IOException {
        if (this.isOpen()) {
            int written = buffer.limit() - buffer.position();
            if (this.isWriteMarked) {
                this.writeMarkBuffer.add(buffer);
            } else {
                this.writeQueue.append(buffer);
            }
            if (this.autoflush) {
                this.internalFlush();
            }
            return written;
        }
        throw new ClosedConnectionException("connection " + this.getId() + " is already closed");
    }

    @Override
    public final int write(int i) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4).putInt(i);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(long l) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putLong(l);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final int write(double d) throws ClosedConnectionException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).putDouble(d);
        buffer.flip();
        return this.write(buffer);
    }

    @Override
    public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        ByteBuffer[] bufs = new ByteBuffer[length];
        System.arraycopy(srcs, offset, bufs, 0, length);
        return this.write(bufs);
    }

    protected final LinkedList<ByteBuffer> extractAvailableFromReadQueue() {
        this.resetCachedIndex();
        LinkedList<ByteBuffer> buffers = this.readQueue.drain();
        this.onExtracted(buffers);
        return buffers;
    }

    protected final LinkedList<ByteBuffer> extractBytesByDelimiterFromReadQueue(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (!this.readQueue.isEmpty()) {
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, delimiter);
            if (index.getReadBytes() > maxLength) {
                throw new MaxReadSizeExceededException();
            }
            if (index.hasDelimiterFound()) {
                LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, index);
                this.onExtracted(extracted);
                this.readQueue.addFirst(buffers);
                this.resetCachedIndex();
                return extracted;
            }
            this.readQueue.addFirst(buffers);
            this.cachedIndex = index;
        }
        throw new BufferUnderflowException();
    }

    public int indexOf(String str) {
        int length = 0;
        if (!this.readQueue.isEmpty()) {
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, str);
            length = index.hasDelimiterFound() ? index.getReadBytes() - str.length() : -1;
            this.readQueue.addFirst(buffers);
            this.cachedIndex = index;
        }
        return length;
    }

    protected final int readIndexOf(String str, int maxReadSize) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        int length = 0;
        if (!this.readQueue.isEmpty()) {
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, str);
            length = index.hasDelimiterFound() ? index.getReadBytes() - str.length() : -1;
            this.readQueue.addFirst(buffers);
            this.cachedIndex = index;
        } else {
            length = -1;
        }
        if (length < 0) {
            if (this.readQueue.getSize() >= maxReadSize) {
                throw new MaxReadSizeExceededException();
            }
            throw new BufferUnderflowException();
        }
        return length;
    }

    protected final LinkedList<ByteBuffer> extractBytesByLength(int length) throws IOException, BufferUnderflowException {
        if (this.readQueue.getSize() >= length) {
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, length);
            this.onExtracted(extracted);
            this.readQueue.addFirst(buffers);
            this.resetCachedIndex();
            return extracted;
        }
        throw new BufferUnderflowException();
    }

    protected final boolean extractAvailableFromReadQueue(String delimiter, WritableByteChannel outChannel) throws IOException {
        if (!this.readQueue.isEmpty()) {
            int availableBytes;
            int readBytes;
            LinkedList<ByteBuffer> buffers = this.readQueue.drain();
            assert (buffers != null);
            ByteBufferParser.Index index = this.scanByDelimiter(buffers, delimiter);
            if (index.hasDelimiterFound()) {
                LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, index);
                this.onExtracted(extracted);
                for (ByteBuffer buffer : extracted) {
                    outChannel.write(buffer);
                }
                this.readQueue.addFirst(buffers);
                this.resetCachedIndex();
                return true;
            }
            if (index.getDelimiterPos() == 0 && (readBytes = index.getReadBytes()) > 0 && (availableBytes = readBytes - index.getDelimiterPos()) > 0) {
                LinkedList<ByteBuffer> extracted = PARSER.extract(buffers, availableBytes);
                this.onExtracted(extracted);
                for (ByteBuffer buffer : extracted) {
                    outChannel.write(buffer);
                }
                this.resetCachedIndex();
            }
            this.readQueue.addFirst(buffers);
            return false;
        }
        return false;
    }

    private ByteBufferParser.Index scanByDelimiter(LinkedList<ByteBuffer> buffers, String delimiter) {
        if (this.cachedIndex != null) {
            if (this.cachedIndex.getDelimiter().equals(delimiter)) {
                return PARSER.find(buffers, this.cachedIndex);
            }
            this.cachedIndex = null;
        }
        return PARSER.find(buffers, delimiter);
    }

    private void onExtracted(LinkedList<ByteBuffer> buffers) {
        for (ByteBuffer buffer : buffers) {
            this.onExtracted(buffer);
        }
    }

    private void onExtracted(ByteBuffer buffer) {
        if (this.isReadMarked) {
            this.readMarkBuffer.addLast(buffer.duplicate());
        }
    }

    protected final byte[] extractBytesFromReadQueue(int length) throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(length);
        this.onExtracted(buffer);
        return DataConverter.toBytes(buffer);
    }

    protected final int extractIntFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(4);
        this.onExtracted(buffer);
        return buffer.getInt();
    }

    protected final byte extractByteFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(1);
        this.onExtracted(buffer);
        return buffer.get();
    }

    protected final double extractDoubleFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(8);
        this.onExtracted(buffer);
        return buffer.getDouble();
    }

    protected final long extractLongFromReadQueue() throws BufferUnderflowException {
        this.resetCachedIndex();
        ByteBuffer buffer = this.readQueue.read(8);
        this.onExtracted(buffer);
        return buffer.getLong();
    }

    private void resetCachedIndex() {
        this.cachedIndex = null;
    }

    @Override
    public final Object attach(Object obj) {
        Object old = this.attachment;
        this.attachment = obj;
        return old;
    }

    @Override
    public final Object attachment() {
        return this.attachment;
    }

    @Override
    public void markReadPosition() {
        this.removeReadMark();
        this.isReadMarked = true;
        this.readMarkBuffer = new LinkedList();
    }

    @Override
    public void markWritePosition() {
        if (this.getAutoflush()) {
            throw new UnsupportedOperationException("write mark is only supported for mode autoflush off");
        }
        this.removeWriteMark();
        this.isWriteMarked = true;
        this.writeMarkBuffer = new WriteMarkBuffer();
    }

    @Override
    public boolean resetToWriteMark() {
        if (this.isWriteMarked) {
            this.writeMarkBuffer.resetWritePosition();
            return true;
        }
        return false;
    }

    @Override
    public boolean resetToReadMark() {
        if (this.isReadMarked) {
            this.getReadQueue().addFirst(this.readMarkBuffer);
            this.removeReadMark();
            return true;
        }
        return false;
    }

    @Override
    public void removeReadMark() {
        this.isReadMarked = false;
        this.readMarkBuffer = null;
    }

    @Override
    public void removeWriteMark() {
        if (this.isWriteMarked) {
            this.isWriteMarked = false;
            this.writeQueue.append(this.writeMarkBuffer.drain());
            this.writeMarkBuffer = null;
        }
    }

    protected void onDataEvent() {
    }

    protected void onConnectEvent() {
    }

    protected void onDisconnectEvent() {
    }

    protected void onConnectionTimeoutEvent() {
    }

    protected void onIdleTimeoutEvent() {
    }

    public String toString() {
        try {
            if (this.isOpen()) {
                return "id=" + this.getId() + ", remote=" + this.getRemoteAddress().getCanonicalHostName() + "(" + this.getRemoteAddress() + ":" + this.getRemotePort() + ")";
            }
            return "id=" + this.getId() + " (closed)";
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    private final class IOEventHandler
    implements IoHandler.IIOEventHandler {
        private IOEventHandler() {
        }

        public boolean listenForWritten() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWrittenEvent() {
            Object object = Connection.this.writeGuard;
            synchronized (object) {
                Connection.this.writeGuard.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWriteExceptionEvent(IOException ioe) {
            Object object = Connection.this.writeGuard;
            synchronized (object) {
                Connection.this.writeException = ioe;
                Connection.this.writeGuard.notify();
            }
        }

        public void onDataEvent() {
            Connection.this.onDataEvent();
        }

        public void initiateClose() {
            block2: {
                try {
                    Connection.this.close();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("[" + Connection.this.getId() + "] error occured closing connection. Reason: " + ioe.toString());
                }
            }
        }

        public boolean listenForConnect() {
            return true;
        }

        public void onConnectEvent() {
            Connection.this.onConnectEvent();
        }

        public boolean listenForDisconnect() {
            return true;
        }

        public void onDisconnectEvent() {
            Connection.this.onDisconnectEvent();
        }

        public void onConnectionTimeout() {
            Connection.this.onConnectionTimeoutEvent();
        }

        public void onIdleTimeout() {
            Connection.this.onIdleTimeoutEvent();
        }
    }

    private static class Entry {
        private ByteBuffer element = null;
        private Entry next = null;

        Entry(ByteBuffer element, Entry next) {
            this.element = element;
            this.next = next;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.element != null) {
                sb.append(DataConverter.toHexString(new ByteBuffer[]{this.element}, 100000));
            }
            if (this.next != null) {
                sb.append(this.next.toString());
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WriteMarkBuffer {
        private final Entry head;
        private Entry tail;

        private WriteMarkBuffer() {
            this.tail = this.head = new Entry(null, null);
        }

        public LinkedList<ByteBuffer> drain() {
            LinkedList<ByteBuffer> result = new LinkedList<ByteBuffer>();
            Entry entry = this.head;
            do {
                if ((entry = entry.next) == null) continue;
                result.add(entry.element);
            } while (entry != null);
            this.head.next = null;
            this.tail = this.head;
            return result;
        }

        public void add(ByteBuffer data) {
            int size = data.remaining();
            if (size == 0) {
                return;
            }
            Entry entry = new Entry(data, this.tail.next);
            this.tail.next = entry;
            this.tail = entry;
            while (size > 0 && this.tail.next != null) {
                int nextSize = this.tail.next.element.remaining();
                if (nextSize <= size) {
                    size -= nextSize;
                    this.tail.next = this.tail.next.next;
                    if (this.tail.next != null) continue;
                    break;
                }
                ByteBuffer buffer = this.tail.next.element;
                buffer.position(buffer.position() + size);
                ByteBuffer sliced = buffer.slice();
                Entry slicedEntry = new Entry(sliced, this.tail.next.next);
                this.tail.next = slicedEntry;
                break;
            }
        }

        public void resetWritePosition() {
            this.tail = this.head;
        }
    }
}

