/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.xsocket.ClosedConnectionException;
import org.xsocket.IDataSink;
import org.xsocket.IDataSource;
import org.xsocket.MaxReadSizeExceededException;

public interface IConnection
extends IDataSource,
IDataSink,
GatheringByteChannel,
ReadableByteChannel,
WritableByteChannel,
Flushable,
Closeable {
    public static final String INITIAL_DEFAULT_ENCODING = "UTF-8";
    public static final boolean INITIAL_AUTOFLUSH = true;

    public String getId();

    public boolean isOpen();

    public void flush() throws ClosedConnectionException, IOException;

    public int getLocalPort();

    public InetAddress getLocalAddress();

    public InetAddress getRemoteAddress();

    public int getRemotePort();

    public void setDefaultEncoding(String var1);

    public String getDefaultEncoding();

    public void setAutoflush(boolean var1);

    public boolean getAutoflush();

    public void activateSecuredMode() throws IOException;

    public int write(String var1, String var2) throws ClosedConnectionException, IOException;

    public int write(String var1) throws ClosedConnectionException, IOException;

    public int write(byte var1) throws ClosedConnectionException, IOException;

    public int write(byte ... var1) throws ClosedConnectionException, IOException;

    public int write(byte[] var1, int var2, int var3) throws ClosedConnectionException, IOException;

    public int write(ByteBuffer var1) throws ClosedConnectionException, IOException;

    public long write(ByteBuffer[] var1) throws ClosedConnectionException, IOException;

    public int write(int var1) throws ClosedConnectionException, IOException;

    public int write(long var1) throws ClosedConnectionException, IOException;

    public int write(double var1) throws ClosedConnectionException, IOException;

    public byte readByte() throws IOException, ClosedConnectionException;

    public int readInt() throws IOException, ClosedConnectionException;

    public long readLong() throws IOException, ClosedConnectionException;

    public double readDouble() throws IOException, ClosedConnectionException;

    public ByteBuffer[] readByteBufferByDelimiter(String var1) throws IOException, ClosedConnectionException;

    public ByteBuffer[] readByteBufferByDelimiter(String var1, int var2) throws IOException, ClosedConnectionException, MaxReadSizeExceededException;

    public ByteBuffer[] readByteBufferByLength(int var1) throws IOException, ClosedConnectionException;

    public byte[] readBytesByDelimiter(String var1) throws IOException, ClosedConnectionException;

    public byte[] readBytesByDelimiter(String var1, int var2) throws IOException, ClosedConnectionException, MaxReadSizeExceededException;

    public byte[] readBytesByLength(int var1) throws IOException, ClosedConnectionException;

    public String readStringByDelimiter(String var1) throws IOException, ClosedConnectionException, UnsupportedEncodingException;

    public String readStringByDelimiter(String var1, int var2) throws IOException, ClosedConnectionException, UnsupportedEncodingException, MaxReadSizeExceededException;

    public String readStringByLength(int var1) throws IOException, ClosedConnectionException, UnsupportedEncodingException;

    public String readStringByDelimiter(String var1, String var2) throws IOException, ClosedConnectionException, UnsupportedEncodingException;

    public String readStringByDelimiter(String var1, String var2, int var3) throws IOException, ClosedConnectionException, UnsupportedEncodingException, MaxReadSizeExceededException;

    public String readStringByLength(int var1, String var2) throws IOException, ClosedConnectionException, UnsupportedEncodingException;

    public int getIndexOf(String var1) throws IOException, ClosedConnectionException;

    public int getIndexOf(String var1, int var2) throws IOException, ClosedConnectionException, MaxReadSizeExceededException;

    public void markWritePosition();

    public void removeWriteMark();

    public boolean resetToWriteMark();

    public void markReadPosition();

    public void removeReadMark();

    public boolean resetToReadMark();

    public Object attach(Object var1);

    public Object attachment();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlushMode {
        SYNC,
        ASYNC;

    }
}

