/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedConnectionException;
import org.xsocket.stream.ByteBufferQueue;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.IoHandler;
import org.xsocket.stream.IoSSLHandler;
import org.xsocket.stream.SSLProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoActivateableSSLHandler
extends IoHandler
implements SSLProcessor.EventHandler {
    private static final Logger LOG = Logger.getLogger(IoSSLHandler.class.getName());
    private Mode mode = Mode.OFF;
    private final ByteBufferQueue inNetDataQueue = new ByteBufferQueue();
    private final ByteBufferQueue outAppDataQueue = new ByteBufferQueue();
    private final ByteBufferQueue inAppDataQueue = new ByteBufferQueue();
    private SSLProcessor sslProcessor = null;
    protected IoHandler.IIOEventHandler ioEventHandler = null;

    IoActivateableSSLHandler(IoHandler successor, SSLContext sslContext, boolean isClientMode, IMemoryManager memoryManager) throws IOException {
        super(successor);
        this.sslProcessor = new SSLProcessor(sslContext, isClientMode, memoryManager, this);
        this.setIOEventHandler(successor.getIOEventHandler());
    }

    @Override
    void open() throws IOException {
        this.getSuccessor().open();
    }

    @Override
    final void close(boolean immediate) throws IOException {
        this.getSuccessor().close(immediate);
    }

    @Override
    boolean isChainSendBufferEmpty() {
        if (this.getSuccessor() != null) {
            return this.outAppDataQueue.isEmpty() && this.getSuccessor().isChainSendBufferEmpty();
        }
        return this.outAppDataQueue.isEmpty();
    }

    @Override
    void setIOEventHandler(IoHandler.IIOEventHandler ioEventHandler) {
        this.ioEventHandler = ioEventHandler;
        this.getSuccessor().setIOEventHandler(new IOEventHandler());
    }

    @Override
    IoHandler.IIOEventHandler getIOEventHandler() {
        return this.ioEventHandler;
    }

    @Override
    final LinkedList<ByteBuffer> drainIncoming() {
        if (this.mode == Mode.OFF) {
            return this.getSuccessor().drainIncoming();
        }
        return this.inAppDataQueue.drain();
    }

    @Override
    final void writeOutgoing(ByteBuffer buffer) throws ClosedConnectionException, IOException {
        LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
        buffers.add(buffer);
        this.writeOutgoing(buffers);
    }

    @Override
    final void writeOutgoing(LinkedList<ByteBuffer> buffers) throws ClosedConnectionException, IOException {
        this.outAppDataQueue.append(buffers);
        this.flushOutgoing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flushOutgoing() throws IOException {
        if (this.mode == Mode.SSL) {
            SSLProcessor sSLProcessor = this.sslProcessor;
            synchronized (sSLProcessor) {
                if (this.sslProcessor.isHandshaking()) {
                    this.sslProcessor.processOutAppData();
                } else if (!this.outAppDataQueue.isEmpty()) {
                    this.sslProcessor.processOutAppData(this.outAppDataQueue.drain());
                }
            }
        } else if (this.mode == Mode.OFF || this.mode == Mode.NON_RECEIVING) {
            LinkedList<ByteBuffer> data = this.outAppDataQueue.drain();
            this.getSuccessor().writeOutgoing(data);
        }
    }

    void stopProcessingIncoming() {
        this.mode = Mode.NON_RECEIVING;
    }

    void startSSL(ByteBufferQueue readQueue) throws IOException {
        assert (this.mode == Mode.NON_RECEIVING);
        this.mode = Mode.NON_RECEIVING_AND_WRITING;
        this.inNetDataQueue.addFirst(readQueue.drain());
        this.sslProcessor.start();
        this.mode = Mode.SSL;
        this.flushOutgoing();
        this.readIncomingEncryptedData();
    }

    @Override
    public void onHandshakeFinished() throws IOException {
        this.flushOutgoing();
        this.readIncomingEncryptedData();
    }

    protected final void readIncomingEncryptedData() throws ClosedConnectionException, IOException {
        this.inNetDataQueue.append(this.getSuccessor().drainIncoming());
        this.readIncomingEncryptedData(this.inNetDataQueue.drain());
    }

    private synchronized void readIncomingEncryptedData(LinkedList<ByteBuffer> inNetDataList) throws ClosedConnectionException, IOException {
        if (inNetDataList != null) {
            if (LOG.isLoggable(Level.FINE)) {
                int size = 0;
                for (ByteBuffer buffer : inNetDataList) {
                    size += buffer.remaining();
                }
                LOG.fine("received " + size + " bytes encrypted data");
            }
            this.sslProcessor.processInNetData(inNetDataList);
        }
    }

    @Override
    public void onSSLProcessorClosed() throws IOException {
        this.close(true);
    }

    @Override
    public void onInAppDataReceived(LinkedList<ByteBuffer> appDataList) {
        this.inAppDataQueue.append(appDataList);
        if (!this.inAppDataQueue.isEmpty()) {
            this.ioEventHandler.onDataEvent();
        }
    }

    @Override
    public void onOutNetDataToWrite(ByteBuffer netData) throws IOException {
        if (netData.hasRemaining()) {
            this.getSuccessor().writeOutgoing(netData);
        }
    }

    private final class IOEventHandler
    implements IoHandler.IIOEventHandler {
        private IOEventHandler() {
        }

        public void onDataEvent() {
            block5: {
                try {
                    if (IoActivateableSSLHandler.this.mode == Mode.OFF) {
                        IoActivateableSSLHandler.this.getIOEventHandler().onDataEvent();
                        break block5;
                    }
                    if (IoActivateableSSLHandler.this.mode == Mode.SSL) {
                        IoActivateableSSLHandler.this.readIncomingEncryptedData();
                        break block5;
                    }
                    assert (IoActivateableSSLHandler.this.mode == Mode.NON_RECEIVING || IoActivateableSSLHandler.this.mode == Mode.NON_RECEIVING_AND_WRITING);
                    return;
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("[" + IoActivateableSSLHandler.this.getId() + "] error occured while receiving data. Reason: " + e.toString());
                }
            }
        }

        public void onConnectEvent() {
            IoActivateableSSLHandler.this.getIOEventHandler().onConnectEvent();
        }

        public void onWrittenEvent() {
            IoActivateableSSLHandler.this.getIOEventHandler().onWrittenEvent();
        }

        public void onWriteExceptionEvent(IOException ioe) {
            IoActivateableSSLHandler.this.getIOEventHandler().onWriteExceptionEvent(ioe);
        }

        public void onDisconnectEvent() {
            IoActivateableSSLHandler.this.getIOEventHandler().onDisconnectEvent();
        }

        public void initiateClose() {
            IoActivateableSSLHandler.this.getIOEventHandler().initiateClose();
        }

        public void onConnectionTimeout() {
            IoActivateableSSLHandler.this.getIOEventHandler().onConnectionTimeout();
        }

        public void onIdleTimeout() {
            IoActivateableSSLHandler.this.getIOEventHandler().onIdleTimeout();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        OFF,
        NON_RECEIVING,
        NON_RECEIVING_AND_WRITING,
        SSL;

    }
}

