/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.xsocket.ClosedConnectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class IoHandler {
    private IoHandler successor = null;
    private IoHandler previous = null;

    IoHandler(IoHandler successor) {
        this.setSuccessor(successor);
    }

    final IoHandler getSuccessor() {
        return this.successor;
    }

    final void setSuccessor(IoHandler successor) {
        this.successor = successor;
        if (successor != null) {
            successor.setPrevious(this);
        }
    }

    final void setPrevious(IoHandler previous) {
        this.previous = previous;
    }

    final IoHandler getPrevious() {
        return this.previous;
    }

    abstract void flushOutgoing() throws IOException;

    String getId() {
        return this.getSuccessor().getId();
    }

    abstract void open() throws IOException;

    abstract void close(boolean var1) throws IOException;

    abstract void writeOutgoing(ByteBuffer var1) throws ClosedConnectionException, IOException;

    abstract boolean isChainSendBufferEmpty();

    abstract void writeOutgoing(LinkedList<ByteBuffer> var1) throws ClosedConnectionException, IOException;

    abstract LinkedList<ByteBuffer> drainIncoming();

    InetAddress getLocalAddress() {
        return this.getSuccessor().getLocalAddress();
    }

    int getLocalPort() {
        return this.getSuccessor().getLocalPort();
    }

    InetAddress getRemoteAddress() {
        return this.getSuccessor().getRemoteAddress();
    }

    int getRemotePort() {
        return this.getSuccessor().getRemotePort();
    }

    boolean isOpen() {
        return this.getSuccessor().isOpen();
    }

    abstract void setIOEventHandler(IIOEventHandler var1);

    abstract IIOEventHandler getIOEventHandler();

    static interface IIOEventHandler {
        public void onWrittenEvent();

        public void onWriteExceptionEvent(IOException var1);

        public void onDataEvent();

        public void onConnectEvent();

        public void onDisconnectEvent();

        public void onIdleTimeout();

        public void onConnectionTimeout();

        public void initiateClose();
    }
}

