/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedConnectionException;
import org.xsocket.stream.ByteBufferQueue;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.IoHandler;
import org.xsocket.stream.SSLProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSSLHandler
extends IoHandler
implements SSLProcessor.EventHandler {
    private static final Logger LOG = Logger.getLogger(IoSSLHandler.class.getName());
    private final ByteBufferQueue outAppDataQueue = new ByteBufferQueue();
    private final ByteBufferQueue inAppDataQueue = new ByteBufferQueue();
    protected IoHandler.IIOEventHandler ioEventHandler = null;
    private SSLProcessor sslProcessor = null;
    private boolean isClientMode = false;
    private boolean isSSLConnected = false;

    IoSSLHandler(IoHandler successor, SSLContext sslContext, boolean isClientMode, IMemoryManager memoryManager) throws IOException {
        super(successor);
        this.isClientMode = isClientMode;
        this.sslProcessor = new SSLProcessor(sslContext, isClientMode, memoryManager, this);
        this.setIOEventHandler(successor.getIOEventHandler());
    }

    @Override
    void open() throws IOException {
        this.getSuccessor().open();
        this.startSSL();
    }

    void startSSL() throws IOException {
        if (!this.isSSLConnected) {
            this.sslProcessor.start();
        }
        this.readIncomingEncryptedData();
    }

    @Override
    final boolean isChainSendBufferEmpty() {
        if (this.getSuccessor() != null) {
            return this.outAppDataQueue.isEmpty() && this.getSuccessor().isChainSendBufferEmpty();
        }
        return this.outAppDataQueue.isEmpty();
    }

    @Override
    void setIOEventHandler(IoHandler.IIOEventHandler ioEventHandler) {
        this.ioEventHandler = ioEventHandler;
        this.getSuccessor().setIOEventHandler(new IOEventHandler());
    }

    @Override
    IoHandler.IIOEventHandler getIOEventHandler() {
        return this.ioEventHandler;
    }

    @Override
    LinkedList<ByteBuffer> drainIncoming() {
        return this.inAppDataQueue.drain();
    }

    @Override
    final void close(boolean immediate) throws IOException {
        this.getSuccessor().close(immediate);
    }

    @Override
    final void writeOutgoing(ByteBuffer buffer) throws ClosedConnectionException, IOException {
        LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
        buffers.add(buffer);
        this.writeOutgoing(buffers);
    }

    @Override
    final void writeOutgoing(LinkedList<ByteBuffer> buffers) throws ClosedConnectionException, IOException {
        this.outAppDataQueue.append(buffers);
        this.flushOutgoing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flushOutgoing() throws IOException {
        SSLProcessor sSLProcessor = this.sslProcessor;
        synchronized (sSLProcessor) {
            if (!this.sslProcessor.isHandshaking()) {
                if (!this.outAppDataQueue.isEmpty()) {
                    this.sslProcessor.processOutAppData(this.outAppDataQueue.drain());
                }
            } else {
                this.sslProcessor.processOutAppData();
            }
        }
    }

    protected final void readIncomingEncryptedData() throws ClosedConnectionException, IOException {
        this.readIncomingEncryptedData(this.getSuccessor().drainIncoming());
    }

    private synchronized void readIncomingEncryptedData(LinkedList<ByteBuffer> inNetDataList) throws ClosedConnectionException, IOException {
        if (inNetDataList != null) {
            if (LOG.isLoggable(Level.FINE)) {
                int size = 0;
                for (ByteBuffer buffer : inNetDataList) {
                    size += buffer.remaining();
                }
                LOG.fine("received " + size + " bytes encrypted data");
            }
            this.sslProcessor.processInNetData(inNetDataList);
        }
    }

    @Override
    public void onHandshakeFinished() throws IOException {
        if (!this.isSSLConnected) {
            if (LOG.isLoggable(Level.FINE)) {
                if (this.isClientMode) {
                    LOG.fine("[" + this.getId() + "] handshake has been finished (clientMode)");
                } else {
                    LOG.fine("[" + this.getId() + "] handshake has been finished (serverMode)");
                }
            }
            this.isSSLConnected = true;
            this.ioEventHandler.onConnectEvent();
        }
        this.flushOutgoing();
        this.readIncomingEncryptedData();
    }

    @Override
    public void onSSLProcessorClosed() throws IOException {
        this.close(true);
    }

    @Override
    public void onInAppDataReceived(LinkedList<ByteBuffer> appDataList) {
        this.inAppDataQueue.append(appDataList);
        if (!this.inAppDataQueue.isEmpty()) {
            this.ioEventHandler.onDataEvent();
        }
    }

    @Override
    public void onOutNetDataToWrite(ByteBuffer netData) throws IOException {
        if (netData.hasRemaining()) {
            this.getSuccessor().writeOutgoing(netData);
        }
    }

    private final class IOEventHandler
    implements IoHandler.IIOEventHandler {
        private IOEventHandler() {
        }

        public void onDataEvent() {
            block2: {
                try {
                    IoSSLHandler.this.readIncomingEncryptedData();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("[" + IoSSLHandler.this.getId() + "] error occured while receiving data. Reason: " + e.toString());
                }
            }
        }

        public void onConnectEvent() {
        }

        public void onWrittenEvent() {
            IoSSLHandler.this.ioEventHandler.onWrittenEvent();
        }

        public void onWriteExceptionEvent(IOException ioe) {
            IoSSLHandler.this.ioEventHandler.onWriteExceptionEvent(ioe);
        }

        public void onDisconnectEvent() {
            IoSSLHandler.this.sslProcessor.destroy();
            IoSSLHandler.this.ioEventHandler.onDisconnectEvent();
        }

        public void initiateClose() {
            IoSSLHandler.this.ioEventHandler.initiateClose();
        }

        public void onConnectionTimeout() {
            IoSSLHandler.this.ioEventHandler.onConnectionTimeout();
        }

        public void onIdleTimeout() {
            IoSSLHandler.this.ioEventHandler.onIdleTimeout();
        }
    }
}

