/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.IDispatcher;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.IMutlithreadedServerListener;
import org.xsocket.stream.IoSocketDispatcher;
import org.xsocket.stream.IoSocketHandler;
import org.xsocket.stream.MemoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSocketDispatcherPool {
    private static final Logger LOG = Logger.getLogger(IoSocketDispatcherPool.class.getName());
    static final String DISPATCHER_PREFIX = "xDispatcher";
    private boolean isRunning = true;
    private int preallocationSize = 65536;
    private final IMemoryManager multiThreadedMemoryManager = new MultiThreadedMemoryManager();
    private final List<IMutlithreadedServerListener> listeners = new ArrayList<IMutlithreadedServerListener>();
    private final LinkedList<IoSocketDispatcher> dispatchers = new LinkedList();
    private int size = 0;
    private int pointer = 0;

    IoSocketDispatcherPool(int preallocationSize) {
        this.preallocationSize = preallocationSize;
    }

    synchronized void setSize(int size) {
        this.size = size;
        this.updateDispatcher();
    }

    synchronized void addListener(IMutlithreadedServerListener listener) {
        this.listeners.add(listener);
    }

    synchronized boolean removeListener(IMutlithreadedServerListener listener) {
        return this.listeners.remove(listener);
    }

    void run() {
        this.isRunning = true;
        this.updateDispatcher();
    }

    synchronized int getReceiveBufferPreallocationSize() {
        return this.preallocationSize;
    }

    synchronized void setReceiveBufferPreallocationSize(int size) {
        this.preallocationSize = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IDispatcher<IoSocketHandler>> getDispatchers() {
        List result = null;
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            result = (List)this.dispatchers.clone();
        }
        return result;
    }

    IMemoryManager getMultithreadedMemoryManager() {
        return this.multiThreadedMemoryManager;
    }

    private synchronized void updateDispatcher() {
        if (this.isRunning) {
            int currentRunning = this.dispatchers.size();
            if (currentRunning != this.size) {
                IDispatcher dispatcher;
                int i;
                if (currentRunning > this.size) {
                    for (i = this.size; i < currentRunning; ++i) {
                        block12: {
                            dispatcher = this.dispatchers.getLast();
                            this.dispatchers.remove(dispatcher);
                            try {
                                dispatcher.close();
                            }
                            catch (IOException ioe) {
                                if (!LOG.isLoggable(Level.FINE)) break block12;
                                LOG.fine("error occured by closing the dispatcher " + dispatcher + ". reason " + ioe.toString());
                            }
                        }
                        for (IMutlithreadedServerListener listener : this.listeners) {
                            listener.onDispatcherRemoved(dispatcher);
                        }
                    }
                } else if (currentRunning < this.size) {
                    for (i = currentRunning; i < this.size; ++i) {
                        dispatcher = new IoSocketDispatcher(new SingleThreadedMemoryManager());
                        this.dispatchers.addLast((IoSocketDispatcher)dispatcher);
                        Thread t = new Thread(dispatcher);
                        t.setDaemon(false);
                        t.setName("xDispatcher#" + i);
                        t.start();
                        for (IMutlithreadedServerListener listener : this.listeners) {
                            listener.onDispatcherAdded(dispatcher);
                        }
                    }
                }
            }
            IDispatcher[] connectionDispatchers = new IDispatcher[this.dispatchers.size()];
            for (int i = 0; i < connectionDispatchers.length; ++i) {
                connectionDispatchers[i] = this.dispatchers.get(i);
            }
        }
    }

    void shutdown() {
        this.isRunning = false;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.fine("terminate dispatchers");
        }
        for (IoSocketDispatcher dispatcher : this.dispatchers) {
            try {
                dispatcher.close();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("error occured by closing the dispatcher " + dispatcher + ". reason " + ioe.toString());
            }
        }
        this.dispatchers.clear();
    }

    IoSocketDispatcher nextDispatcher() {
        ++this.pointer;
        if (this.pointer >= this.size) {
            this.pointer = 0;
        }
        return this.dispatchers.get(this.pointer);
    }

    private final class SingleThreadedMemoryManager
    implements IMemoryManager {
        private ByteBuffer freeBuffer = null;

        private SingleThreadedMemoryManager() {
        }

        public int getCurrentPreallocationBufferSize() {
            ByteBuffer b = this.freeBuffer;
            if (b == null) {
                return 0;
            }
            return b.remaining();
        }

        public void recycleMemory(ByteBuffer buffer) {
            if (buffer.hasRemaining()) {
                this.freeBuffer = buffer;
            }
        }

        public final ByteBuffer acquireMemory(int minSize) {
            ByteBuffer buffer = null;
            if (this.freeBuffer != null) {
                if (this.freeBuffer.remaining() >= minSize) {
                    buffer = this.freeBuffer;
                }
                this.freeBuffer = null;
            }
            if (buffer == null) {
                buffer = this.newBuffer(IoSocketDispatcherPool.this.preallocationSize);
            }
            return buffer;
        }

        final ByteBuffer newBuffer(int preallocationSize) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("allocate new physical memory (size: " + preallocationSize + ") by thread " + Thread.currentThread().getName());
            }
            return ByteBuffer.allocateDirect(preallocationSize);
        }

        public int getFreeBufferSize() {
            if (this.freeBuffer != null) {
                return this.freeBuffer.remaining();
            }
            return 0;
        }
    }

    private final class MultiThreadedMemoryManager
    extends MemoryManager {
        MultiThreadedMemoryManager() {
            super(IoSocketDispatcherPool.this.preallocationSize, true);
        }

        int getPreallocationSize() {
            return IoSocketDispatcherPool.this.preallocationSize;
        }
    }
}

