/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.IDispatcher;
import org.xsocket.IHandle;
import org.xsocket.stream.ByteBufferQueue;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.IoHandler;
import org.xsocket.stream.StreamSocketConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSocketHandler
extends IoHandler
implements IHandle {
    private static final Logger LOG = Logger.getLogger(IoSocketHandler.class.getName());
    public static final int DEFAULT_READ_MEMORY_MIN_SIZE = 128;
    private boolean isLogicalOpen = true;
    private boolean isDisconnectNotified = false;
    private SocketChannel channel = null;
    private IDispatcher<IoSocketHandler> dispatcher = null;
    private IoHandler.IIOEventHandler ioEventHandler = null;
    private IMemoryManager memoryManager = null;
    private final ByteBufferQueue sendQueue = new ByteBufferQueue();
    private final ByteBufferQueue receiveQueue = new ByteBufferQueue();
    private String id = null;
    private static long nextId = 0L;
    private static String idPrefix = null;
    private long idleTimeout = Long.MAX_VALUE;
    private long connectionTimeout = Long.MAX_VALUE;
    private long openTime = -1L;
    private long lastTimeReceived = System.currentTimeMillis();
    private long receivedBytes = 0L;
    private long sendBytes = 0L;

    IoSocketHandler(SocketChannel channel, String idLocalPrefix, IDispatcher<IoSocketHandler> dispatcher) throws IOException {
        super(null);
        assert (channel != null);
        this.channel = channel;
        this.openTime = System.currentTimeMillis();
        channel.configureBlocking(false);
        this.id = idPrefix + "." + idLocalPrefix + this.nextLocalId();
        this.dispatcher = dispatcher;
    }

    void setMemoryManager(IMemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    @Override
    void open() throws IOException {
        assert (this.ioEventHandler != null) : "ioHandler hasn't been set";
        this.dispatcher.register(this, 1);
    }

    @Override
    void setIOEventHandler(IoHandler.IIOEventHandler ioEventHandler) {
        this.ioEventHandler = ioEventHandler;
    }

    @Override
    IoHandler.IIOEventHandler getIOEventHandler() {
        return this.ioEventHandler;
    }

    SocketOptions getSocketOptions() {
        return new SocketOptions(){

            public Object getOption(int optID) throws SocketException {
                return StreamSocketConfiguration.getOption(IoSocketHandler.this.channel.socket(), optID);
            }

            public void setOption(int optID, Object value) throws SocketException {
                StreamSocketConfiguration.setOption(IoSocketHandler.this.channel.socket(), optID, value);
            }

            public String toString() {
                try {
                    return "TCP_NODELAY=" + this.getOption(1) + ", " + "SO_TIMEOUT=" + this.getOption(4102) + ", " + "SO_SNDBUF=" + this.getOption(4097) + ", " + "SO_REUSEADDR=" + this.getOption(4) + ", " + "SO_RCVBUF=" + this.getOption(4098) + ", " + "SO_OOBINLINE=" + this.getOption(4099) + ", " + "SO_LINGER=" + this.getOption(128) + ", " + "SO_KEEPALIVE=" + this.getOption(8) + ", " + "IP_TOS=" + this.getOption(3) + ", ";
                }
                catch (Exception e) {
                    return super.toString();
                }
            }
        };
    }

    private synchronized long nextLocalId() {
        if (++nextId < 0L) {
            nextId = 1L;
        }
        return nextId;
    }

    @Override
    final String getId() {
        return this.id;
    }

    public void setIdleTimeoutMillis(long timeout) {
        this.idleTimeout = timeout;
    }

    public void setConnectionTimeoutMillis(long timeout) {
        this.connectionTimeout = timeout;
    }

    public long getConnectionTimeoutMillis() {
        return this.connectionTimeout;
    }

    public long getIdleTimeoutMillis() {
        return this.idleTimeout;
    }

    int getReceiveQueueSize() {
        return this.receiveQueue.getSize();
    }

    int getSendQueueSize() {
        return this.sendQueue.getSize();
    }

    boolean checkIdleTimeout(Long current) {
        boolean timeoutReached;
        long maxTime = this.lastTimeReceived + this.idleTimeout;
        if (maxTime < 0L) {
            maxTime = Long.MAX_VALUE;
        }
        boolean bl = timeoutReached = maxTime < current;
        if (timeoutReached) {
            this.ioEventHandler.onIdleTimeout();
        }
        return timeoutReached;
    }

    void checkConnection() {
        if (!this.channel.isOpen()) {
            this.getIOEventHandler().initiateClose();
        }
    }

    boolean checkConnectionTimeout(Long current) {
        boolean timeoutReached;
        long maxTime = this.openTime + this.connectionTimeout;
        if (maxTime < 0L) {
            maxTime = Long.MAX_VALUE;
        }
        boolean bl = timeoutReached = maxTime < current;
        if (timeoutReached) {
            this.ioEventHandler.onConnectionTimeout();
        }
        return timeoutReached;
    }

    int getIncomingQueueSize() {
        return this.receiveQueue.getSize();
    }

    void onDataEvent() {
        if (this.getReceiveQueueSize() > 0) {
            this.getIOEventHandler().onDataEvent();
        }
    }

    void onWrittenEvent() {
        this.getIOEventHandler().onWrittenEvent();
    }

    void onWrittenExceptionEvent(IOException ioe) {
        this.getIOEventHandler().onWriteExceptionEvent(new IOException(ioe.toString()));
    }

    synchronized void onDisconnectEvent() {
        if (!this.isDisconnectNotified) {
            this.isDisconnectNotified = true;
            this.getIOEventHandler().onDisconnectEvent();
        }
    }

    boolean shouldClosedPhysically() {
        return !this.isLogicalOpen && this.sendQueue.isEmpty();
    }

    @Override
    void writeOutgoing(ByteBuffer buffer) throws IOException {
        if (buffer != null) {
            this.sendQueue.append(buffer);
            this.updateInterestedSetWrite();
        }
    }

    @Override
    void writeOutgoing(LinkedList<ByteBuffer> buffers) throws IOException {
        if (buffers != null) {
            this.sendQueue.append(buffers);
            this.updateInterestedSetWrite();
        }
    }

    @Override
    LinkedList<ByteBuffer> drainIncoming() {
        return this.receiveQueue.drain();
    }

    @Override
    void close(boolean immediate) throws IOException {
        if (immediate) {
            this.closePhysically();
        } else {
            this.isLogicalOpen = false;
            this.updateInterestedSetWrite();
        }
    }

    void closePhysically() throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection " + this.getId() + " has been closed");
        }
        this.channel.close();
    }

    void onDispatcherClose() {
        this.getIOEventHandler().initiateClose();
    }

    private void updateInterestedSetWrite() throws ClosedConnectionException {
        try {
            this.dispatcher.updateInterestSet(this, 4);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("couldn't update interested set to write data on socket. Reason: " + ioe.toString());
            }
            try {
                this.dispatcher.deregister(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ClosedConnectionException("connection " + this.getId() + " is already closed", ioe);
        }
    }

    @Override
    boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    boolean isChainSendBufferEmpty() {
        if (this.getSuccessor() != null) {
            return this.sendQueue.isEmpty() && this.getSuccessor().isChainSendBufferEmpty();
        }
        return this.sendQueue.isEmpty();
    }

    @Override
    public SocketChannel getChannel() {
        return this.channel;
    }

    IDispatcher<IoSocketHandler> getDispatcher() {
        return this.dispatcher;
    }

    protected final int readSocketIntoReceiveQueue() throws IOException {
        int read = 0;
        this.lastTimeReceived = System.currentTimeMillis();
        if (this.isOpen()) {
            ByteBuffer readBuffer = this.memoryManager.acquireMemory(128);
            int pos = readBuffer.position();
            int limit = readBuffer.limit();
            try {
                read = this.channel.read(readBuffer);
            }
            catch (IOException ioe) {
                readBuffer.position(pos);
                readBuffer.limit(limit);
                this.memoryManager.recycleMemory(readBuffer);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured while reading channel: " + ioe.toString());
                }
                throw ioe;
            }
            switch (read) {
                case -1: {
                    this.memoryManager.recycleMemory(readBuffer);
                    ClosedConnectionException cce = new ClosedConnectionException("[" + this.id + "] End of stream reached");
                    throw cce;
                }
                case 0: {
                    this.memoryManager.recycleMemory(readBuffer);
                    break;
                }
                default: {
                    int savePos = readBuffer.position();
                    int saveLimit = readBuffer.limit();
                    readBuffer.position(savePos - read);
                    readBuffer.limit(savePos);
                    ByteBuffer readData = readBuffer.slice();
                    this.receiveQueue.append(readData);
                    if (readBuffer.hasRemaining()) {
                        readBuffer.position(savePos);
                        readBuffer.limit(saveLimit);
                        this.memoryManager.recycleMemory(readBuffer);
                    }
                    if (!LOG.isLoggable(Level.FINE)) break;
                    LOG.fine("[" + this.getId() + "] received (" + (readData.limit() - readData.position()) + " bytes): " + DataConverter.toTextOrHexString(new ByteBuffer[]{readData.duplicate()}, "UTF-8", 500));
                }
            }
        }
        this.receivedBytes += (long)read;
        return read;
    }

    protected final void writeSendQueueDataToSocket() throws IOException {
        if (this.isOpen() && !this.sendQueue.isEmpty()) {
            LinkedList<ByteBuffer> data = this.sendQueue.drain();
            if (LOG.isLoggable(Level.FINE)) {
                int size = 0;
                ByteBuffer[] copies = new ByteBuffer[data.size()];
                for (int i = 0; i < copies.length; ++i) {
                    copies[i] = data.get(i).duplicate();
                    size += copies[i].remaining();
                }
                LOG.fine("[" + this.getId() + "] sending: (" + size + " bytes): " + DataConverter.toTextOrHexString(copies, "UTF-8", 500));
            }
            this.sendBytes += this.channel.write(data.toArray(new ByteBuffer[data.size()]));
            ListIterator<ByteBuffer> it = data.listIterator(data.size());
            while (it.hasPrevious()) {
                ByteBuffer buf = it.previous();
                if (!buf.hasRemaining()) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] not all bytes has been sent re-sending remaing");
                }
                this.sendQueue.addFirst(buf);
            }
            if (!this.sendQueue.isEmpty()) {
                this.updateInterestedSetWrite();
            }
        }
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.channel.socket().getLocalAddress();
    }

    @Override
    public final int getLocalPort() {
        return this.channel.socket().getLocalPort();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.channel.socket().getInetAddress();
    }

    @Override
    public final int getRemotePort() {
        return this.channel.socket().getPort();
    }

    @Override
    void flushOutgoing() {
    }

    public String toString() {
        try {
            return this.channel.socket().getInetAddress().toString() + ":" + this.channel.socket().getPort() + " received=" + DataConverter.toFormatedBytesSize(this.receivedBytes) + ", sent=" + DataConverter.toFormatedBytesSize(this.sendBytes) + ", age=" + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.openTime) + ", lastReceived=" + DataConverter.toFormatedDate(this.lastTimeReceived) + " [" + this.id + "]";
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    static {
        String base = null;
        try {
            base = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            base = "locale";
        }
        int random = 0;
        while ((random = new Random().nextInt()) < 0) {
        }
        idPrefix = Integer.toHexString(base.hashCode()) + "." + Long.toHexString(System.currentTimeMillis()) + "." + Integer.toHexString(random);
    }
}

