/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DynamicWorkerPool;
import org.xsocket.IDispatcher;
import org.xsocket.ILifeCycle;
import org.xsocket.IWorkerPool;
import org.xsocket.Resource;
import org.xsocket.stream.Acceptor;
import org.xsocket.stream.IConnectHandler;
import org.xsocket.stream.IConnectionScoped;
import org.xsocket.stream.IDataHandler;
import org.xsocket.stream.IDisconnectHandler;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.IMultithreadedServer;
import org.xsocket.stream.IMutlithreadedServerListener;
import org.xsocket.stream.IServerContext;
import org.xsocket.stream.ITimeoutHandler;
import org.xsocket.stream.IoSocketDispatcherPool;
import org.xsocket.stream.IoSocketHandler;
import org.xsocket.stream.NonBlockingConnection;
import org.xsocket.stream.StreamSocketConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultithreadedServer
implements IMultithreadedServer {
    private static final Logger LOG = Logger.getLogger(MultithreadedServer.class.getName());
    private boolean isOpen = false;
    private int port = 0;
    private InetAddress localAddress = null;
    private boolean sslOn = false;
    private SSLContext sslContext = null;
    private IHandler appHandler = null;
    private boolean isLifeCycleHandler = false;
    private boolean isConnectionScoped = false;
    private boolean isConnectHandler = false;
    private boolean isDisconnectHandler = false;
    private boolean isDataHandler = false;
    private boolean isTimeoutHandler = false;
    private boolean isSynchronnizedHandler = false;
    private IWorkerPool workerPool = new DynamicWorkerPool(3, 250);
    private boolean isSelfCreatedWorkerPool = true;
    private final IoSocketDispatcherPool dispatcherPool = new IoSocketDispatcherPool(65536);
    private Acceptor acceptor = null;
    private final ArrayList<IMutlithreadedServerListener> listeners = new ArrayList();

    public MultithreadedServer(IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getLocalHost(), 0, null, handler, false, null);
    }

    public MultithreadedServer(StreamSocketConfiguration socketConfiguration, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getLocalHost(), 0, socketConfiguration, handler, false, null);
    }

    public MultithreadedServer(int port, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getLocalHost(), port, null, handler, false, null);
    }

    public MultithreadedServer(int port, StreamSocketConfiguration socketConfiguration, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getLocalHost(), port, socketConfiguration, handler, false, null);
    }

    public MultithreadedServer(InetAddress address, int port, IHandler handler) throws UnknownHostException, IOException {
        this(address, port, null, handler, false, null);
    }

    public MultithreadedServer(InetAddress address, int port, StreamSocketConfiguration socketConfiguration, IHandler handler) throws UnknownHostException, IOException {
        this(address, port, socketConfiguration, handler, false, null);
    }

    public MultithreadedServer(String ipAddress, int port, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, null, handler, false, null);
    }

    public MultithreadedServer(String ipAddress, int port, StreamSocketConfiguration socketConfiguration, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, socketConfiguration, handler, false, null);
    }

    public MultithreadedServer(int port, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getLocalHost(), port, null, handler, sslOn, sslContext);
    }

    public MultithreadedServer(int port, StreamSocketConfiguration socketConfiguration, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getLocalHost(), port, socketConfiguration, handler, sslOn, sslContext);
    }

    public MultithreadedServer(String ipAddress, int port, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, null, handler, sslOn, sslContext);
    }

    public MultithreadedServer(String ipAddress, int port, StreamSocketConfiguration socketConfiguration, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, socketConfiguration, handler, sslOn, sslContext);
    }

    public MultithreadedServer(InetAddress address, int port, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this(address, port, null, handler, sslOn, sslContext);
    }

    public MultithreadedServer(InetAddress address, int port, StreamSocketConfiguration socketConfiguration, IHandler handler, boolean sslOn, SSLContext sslContext) throws UnknownHostException, IOException {
        this.localAddress = address;
        this.sslOn = sslOn;
        this.sslContext = sslContext;
        this.acceptor = new Acceptor(this.localAddress, port, socketConfiguration, sslContext, sslOn, Integer.toString(port), this.dispatcherPool, this.workerPool);
        this.port = this.acceptor.getLocalePort();
        this.setDispatcherPoolSize(Runtime.getRuntime().availableProcessors() + 1);
        this.setConnectionTimeoutSec(Integer.MAX_VALUE);
        this.setIdleTimeoutSec(3600);
        if (handler != null) {
            this.setHandler(handler);
        }
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.acceptor.shutdown();
            if (this.isSelfCreatedWorkerPool && this.workerPool instanceof DynamicWorkerPool) {
                ((DynamicWorkerPool)this.workerPool).close();
            }
            this.destroyCurrentHandler();
            for (IMutlithreadedServerListener listener : (ArrayList)this.listeners.clone()) {
                listener.onDestroy();
            }
            LOG.info("server " + this.localAddress + ":" + this.port + " has been shut down");
        }
    }

    @Override
    public final void run() {
        if (this.appHandler == null) {
            LOG.warning("no handler has been set. Call setHandler-method to set an assigned handler");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                MultithreadedServer.this.close();
            }
        });
        if (this.sslContext != null) {
            if (this.sslOn) {
                LOG.info("server listening on " + this.localAddress + ":" + this.port + "  - ssl mode (" + this.getVersionInfo() + ")");
            } else {
                LOG.info("server listening on " + this.localAddress + ":" + this.port + " - activateable ssl mode (" + this.getVersionInfo() + ")");
            }
        } else {
            LOG.info("server listening on " + this.localAddress + ":" + this.port + " (" + this.getVersionInfo() + ")");
        }
        LOG.fine("dispatcherPoolSize=" + this.getDispatcher().size());
        LOG.fine("preallocationSize=" + this.getReceiveBufferPreallocationSize());
        this.isOpen = true;
        for (IMutlithreadedServerListener listener : (ArrayList)this.listeners.clone()) {
            listener.onInit();
        }
        this.acceptor.run();
    }

    @Override
    public void addListener(IMutlithreadedServerListener listener) {
        this.listeners.add(listener);
        this.dispatcherPool.addListener(listener);
    }

    @Override
    public boolean removeListener(IMutlithreadedServerListener listener) {
        boolean result = this.listeners.remove(listener);
        this.dispatcherPool.removeListener(listener);
        return result;
    }

    @Override
    public IWorkerPool getWorkerPool() {
        return this.workerPool;
    }

    @Override
    public void setWorkerPool(IWorkerPool newWorkerPool) {
        IWorkerPool oldWorkerPool = this.workerPool;
        if (newWorkerPool == null) {
            newWorkerPool = new NullWorkerPool();
        }
        this.workerPool = newWorkerPool;
        if (this.isSelfCreatedWorkerPool && oldWorkerPool instanceof DynamicWorkerPool) {
            ((DynamicWorkerPool)oldWorkerPool).close();
        }
        this.isSelfCreatedWorkerPool = false;
        for (IMutlithreadedServerListener listener : (ArrayList)this.listeners.clone()) {
            IWorkerPool wn;
            IWorkerPool wo = oldWorkerPool;
            if (wo instanceof NullWorkerPool) {
                wo = null;
            }
            if ((wn = newWorkerPool) instanceof NullWorkerPool) {
                wn = null;
            }
            listener.onWorkerPoolUpdated(null, newWorkerPool);
        }
        this.acceptor.setWorkerPool(this.workerPool);
    }

    @Override
    public final void setDispatcherPoolSize(int size) {
        this.dispatcherPool.setSize(size);
    }

    @Override
    public int getDispatcherPoolSize() {
        return this.dispatcherPool.getDispatchers().size();
    }

    int getMultiMemoryManagerFreeBufferSize() {
        return this.dispatcherPool.getMultithreadedMemoryManager().getFreeBufferSize();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void setHandler(IHandler appHandler) {
        if (appHandler == null) {
            throw new NullPointerException("handler have to be not null");
        }
        this.destroyCurrentHandler();
        this.appHandler = appHandler;
        this.isConnectHandler = appHandler instanceof IConnectHandler;
        this.isDisconnectHandler = appHandler instanceof IDisconnectHandler;
        this.isDataHandler = appHandler instanceof IDataHandler;
        this.isTimeoutHandler = appHandler instanceof ITimeoutHandler;
        this.isConnectionScoped = appHandler instanceof IConnectionScoped;
        this.isLifeCycleHandler = appHandler instanceof ILifeCycle;
        this.isSynchronnizedHandler = NonBlockingConnection.isSynchronized(appHandler);
        this.initCurrentHandler();
    }

    private void initCurrentHandler() {
        this.injectContext(this.appHandler);
        this.acceptor.setHandler(this.appHandler, this.isConnectionScoped, this.isConnectHandler, this.isDisconnectHandler, this.isDataHandler, this.isTimeoutHandler, this.isSynchronnizedHandler);
        if (this.isLifeCycleHandler) {
            ((ILifeCycle)((Object)this.appHandler)).onInit();
        }
    }

    private void injectContext(IHandler hdl) {
        Field[] fields;
        HandlerContext ctx = null;
        for (Field field : fields = hdl.getClass().getDeclaredFields()) {
            if (field.getType() != IServerContext.class || field.getAnnotation(Resource.class) == null) continue;
            field.setAccessible(true);
            try {
                if (ctx == null) {
                    ctx = new HandlerContext();
                }
                field.set(hdl, ctx);
            }
            catch (IllegalAccessException iae) {
                LOG.warning("couldn't set HandlerContext for attribute " + field.getName() + ". Reason " + iae.toString());
            }
        }
    }

    private void destroyCurrentHandler() {
        if (this.appHandler != null) {
            if (this.isLifeCycleHandler) {
                ((ILifeCycle)((Object)this.appHandler)).onDestroy();
            }
            this.appHandler = null;
        }
    }

    @Override
    public final int getLocalPort() {
        return this.port;
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public final int getReceiveBufferPreallocationSize() {
        return this.dispatcherPool.getReceiveBufferPreallocationSize();
    }

    @Override
    public void setReceiveBufferPreallocationSize(int size) {
        this.dispatcherPool.setReceiveBufferPreallocationSize(size);
    }

    @Override
    public void setConnectionTimeoutSec(int timeoutSec) {
        this.acceptor.setConnectionTimeoutSec(timeoutSec);
    }

    @Override
    public void setIdleTimeoutSec(int timeoutInSec) {
        this.acceptor.setIdleTimeoutSec(timeoutInSec);
    }

    @Override
    public final List<IDispatcher> getDispatcher() {
        ArrayList<IDispatcher> result = new ArrayList<IDispatcher>();
        for (IDispatcher<IoSocketHandler> dispatcher : this.dispatcherPool.getDispatchers()) {
            result.add(dispatcher);
        }
        return result;
    }

    @Override
    public final int getConnectionTimeoutSec() {
        return this.acceptor.getConnectionTimeoutSec();
    }

    @Override
    public final int getIdleTimeoutSec() {
        return this.acceptor.getIdleTimeoutSec();
    }

    int getNumberOfConnectionTimeout() {
        return this.acceptor.getNumberOfConnectionTimeout();
    }

    int getNumberOfIdleTimeout() {
        return this.acceptor.getNumberOfIdleTimeout();
    }

    final List<String> getOpenConnections() {
        ArrayList<String> result = new ArrayList<String>();
        for (IDispatcher<IoSocketHandler> dispatcher : this.dispatcherPool.getDispatchers()) {
            for (IoSocketHandler handler : dispatcher.getRegistered()) {
                result.add(handler.toString());
            }
        }
        return result;
    }

    int getNumberOfOpenConnections() {
        return this.getOpenConnections().size();
    }

    long getNumberOfHandledConnections() {
        return this.acceptor.getNumberOfHandledConnections();
    }

    private String getVersionInfo() {
        Package p = Package.getPackage("org.xsocket");
        if (p != null) {
            return p.getSpecificationTitle() + " " + p.getImplementationVersion();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NullWorkerPool
    implements IWorkerPool {
        private NullWorkerPool() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        @Override
        public int getActiveCount() {
            return 0;
        }

        @Override
        public int getPoolSize() {
            return 0;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<Callable<T>> tasks) throws InterruptedException {
            throw new UnsupportedOperationException("invokeAll is not supported");
        }
    }

    private final class HandlerContext
    implements IServerContext {
        private HandlerContext() {
        }

        public int getLocalePort() {
            return MultithreadedServer.this.getLocalPort();
        }

        public InetAddress getLocaleAddress() {
            return MultithreadedServer.this.localAddress;
        }

        public int getNumberOfOpenConnections() {
            return MultithreadedServer.this.getNumberOfOpenConnections();
        }
    }
}

