/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.IDispatcher;
import org.xsocket.ILifeCycle;
import org.xsocket.IWorkerPool;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.Synchronized;
import org.xsocket.stream.BlockingConnection;
import org.xsocket.stream.Connection;
import org.xsocket.stream.IConnectHandler;
import org.xsocket.stream.IConnection;
import org.xsocket.stream.IConnectionScoped;
import org.xsocket.stream.IDataHandler;
import org.xsocket.stream.IDisconnectHandler;
import org.xsocket.stream.IHandler;
import org.xsocket.stream.IMemoryManager;
import org.xsocket.stream.INonBlockingConnection;
import org.xsocket.stream.ITimeoutHandler;
import org.xsocket.stream.IoDelayWriteHandler;
import org.xsocket.stream.IoHandler;
import org.xsocket.stream.IoSocketHandler;
import org.xsocket.stream.MemoryManager;
import org.xsocket.stream.StreamSocketConfiguration;

public final class NonBlockingConnection
extends Connection
implements INonBlockingConnection {
    private static final Logger LOG = Logger.getLogger(BlockingConnection.class.getName());
    private static final long MIN_WATCHDOG_PERIOD_MILLIS = 900000L;
    private IHandler appHandler = null;
    private boolean isConnectHandler = false;
    private boolean isDisconnectHandler = false;
    private boolean isDataHandler = false;
    private boolean isTimeoutHandler = false;
    private boolean isClient = false;
    private IWorkerPool workerPool = null;
    private final TaskQueue taskQueue = new TaskQueue();
    private Runnable taskProcessor = null;
    private TimeoutWatchdog timeoutWatchdog = null;
    private static Timer watchDogTimer = null;

    public NonBlockingConnection(String hostname, int port) throws IOException {
        this(InetAddress.getByName(hostname), port);
    }

    public NonBlockingConnection(String hostname, int port, StreamSocketConfiguration socketConfiguration) throws IOException {
        this(InetAddress.getByName(hostname), port, socketConfiguration);
    }

    public NonBlockingConnection(InetAddress address, int port) throws IOException {
        this(new InetSocketAddress(address, port), null, null, false, null);
    }

    public NonBlockingConnection(InetAddress address, int port, StreamSocketConfiguration socketConfiguration) throws IOException {
        this(new InetSocketAddress(address, port), socketConfiguration, null, false, null);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(address, port), null, null, false, appHandler);
    }

    public NonBlockingConnection(InetAddress address, int port, StreamSocketConfiguration socketConfiguration, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(address, port), socketConfiguration, null, false, appHandler);
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(hostname, port), null, null, false, appHandler);
    }

    public NonBlockingConnection(String hostname, int port, StreamSocketConfiguration socketConfiguration, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(hostname, port), socketConfiguration, null, false, appHandler);
    }

    public NonBlockingConnection(InetAddress address, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), null, sslContext, sslOn, null);
    }

    public NonBlockingConnection(InetAddress address, int port, StreamSocketConfiguration socketConfiguration, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), socketConfiguration, sslContext, sslOn, null);
    }

    public NonBlockingConnection(String hostname, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), null, sslContext, sslOn, null);
    }

    public NonBlockingConnection(String hostname, int port, StreamSocketConfiguration socketConfiguration, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), socketConfiguration, sslContext, sslOn, null);
    }

    private NonBlockingConnection(InetSocketAddress remoteAddress, StreamSocketConfiguration socketConf, SSLContext sslContext, boolean sslOn, IHandler appHandler) throws IOException {
        this(NonBlockingConnection.createClientIoSocketHandler(remoteAddress, NonBlockingConnection.getGlobalMemoryManager(), NonBlockingConnection.getGlobalDispatcher(), socketConf), sslContext, sslOn, NonBlockingConnection.getGlobalMemoryManager(), NonBlockingConnection.getGlobalWorkerPool(), true, appHandler, appHandler instanceof IConnectHandler, appHandler instanceof IDisconnectHandler, appHandler instanceof IDataHandler, appHandler instanceof ITimeoutHandler, NonBlockingConnection.isSynchronized(appHandler));
        if (LOG.isLoggable(Level.FINE)) {
            if (appHandler instanceof IConnectionScoped) {
                LOG.fine("handler type IConnectionScoped is not supported in the client context");
            }
            if (appHandler instanceof ILifeCycle) {
                LOG.fine("ILifeCycle is not supported in the client context");
            }
        }
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler, IWorkerPool workerPool, int preallocationMemorySize) throws IOException {
        this(new InetSocketAddress(hostname, port), null, null, false, appHandler, workerPool, new MemoryManager(preallocationMemorySize, true));
    }

    public NonBlockingConnection(String hostname, int port, StreamSocketConfiguration socketConf, IHandler appHandler, IWorkerPool workerPool, int preallocationMemorySize) throws IOException {
        this(new InetSocketAddress(hostname, port), socketConf, null, false, appHandler, workerPool, new MemoryManager(preallocationMemorySize, true));
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, IWorkerPool workerPool, int preallocationMemorySize) throws IOException {
        this(new InetSocketAddress(address, port), null, null, false, appHandler, workerPool, new MemoryManager(preallocationMemorySize, true));
    }

    public NonBlockingConnection(InetAddress address, int port, StreamSocketConfiguration socketConf, IHandler appHandler, IWorkerPool workerPool, int preallocationMemorySize) throws IOException {
        this(new InetSocketAddress(address, port), socketConf, null, false, appHandler, workerPool, new MemoryManager(preallocationMemorySize, true));
    }

    private NonBlockingConnection(InetSocketAddress remoteAddress, StreamSocketConfiguration socketConf, SSLContext sslContext, boolean startSSL, IHandler appHandler, IWorkerPool workerPool, IMemoryManager memoryManager) throws IOException {
        this(NonBlockingConnection.createClientIoSocketHandler(remoteAddress, memoryManager, NonBlockingConnection.newDispatcher("ClientDispatcher", memoryManager), socketConf), sslContext, startSSL, memoryManager, workerPool, true, appHandler, appHandler instanceof IConnectHandler, appHandler instanceof IDisconnectHandler, appHandler instanceof IDataHandler, appHandler instanceof ITimeoutHandler, NonBlockingConnection.isSynchronized(appHandler));
        if (LOG.isLoggable(Level.FINE)) {
            if (appHandler instanceof IConnectionScoped) {
                LOG.fine("handler type IConnectionScoped is not supported in the client context");
            }
            if (appHandler instanceof ILifeCycle) {
                LOG.fine("ILifeCycle is not supported in the client context");
            }
        }
    }

    NonBlockingConnection(IoSocketHandler socketHandler, SSLContext sslContext, boolean sslOn, IMemoryManager sslMemoryManager, IWorkerPool workerPool, boolean isClient, IHandler appHandler, boolean isConnectHandler, boolean isDisconnectHandler, boolean isDataHandler, boolean isTimeoutHandler, boolean isSynchronizedHandler) throws IOException {
        this.workerPool = workerPool;
        this.appHandler = appHandler;
        this.isConnectHandler = isConnectHandler;
        this.isDataHandler = isDataHandler;
        this.isDataHandler = isDataHandler;
        this.isTimeoutHandler = isTimeoutHandler;
        this.isDisconnectHandler = isDisconnectHandler;
        this.isClient = isClient;
        this.taskProcessor = isSynchronizedHandler ? new SynchronizedTaskProcessor() : new NonSynchronizedTaskProcessor();
        this.init(socketHandler, sslContext, sslOn, isClient, sslMemoryManager);
    }

    IHandler getAppHandler() {
        return this.appHandler;
    }

    void reset() {
        block2: {
            try {
                this.setWriteTransferRate(Integer.MAX_VALUE);
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by reseting (setWriteTransferRate). Reason: " + e.toString());
            }
        }
        super.reset();
        this.setIdleTimeoutSec(Integer.MAX_VALUE);
        this.setConnectionTimeoutSec(Integer.MAX_VALUE);
        this.setFlushmode(INonBlockingConnection.INITIAL_FLUSH_MODE);
    }

    public void setIdleTimeoutSec(int timeoutInSec) {
        this.getIoSocketHandler().setIdleTimeoutMillis((long)timeoutInSec * 1000L);
        if (this.isClient) {
            this.getWatchdog().updateTimeoutCheckPeriod(this.getIoSocketHandler().getIdleTimeoutMillis(), this.getIoSocketHandler().getConnectionTimeoutMillis());
        }
    }

    public void setConnectionTimeoutSec(int timeoutSec) {
        this.getIoSocketHandler().setConnectionTimeoutMillis((long)timeoutSec * 1000L);
        if (this.isClient) {
            this.getWatchdog().updateTimeoutCheckPeriod(this.getIoSocketHandler().getIdleTimeoutMillis(), this.getIoSocketHandler().getConnectionTimeoutMillis());
        }
    }

    private TimeoutWatchdog getWatchdog() {
        if (this.timeoutWatchdog == null) {
            this.timeoutWatchdog = new TimeoutWatchdog();
            this.timeoutWatchdog.setDispatcher(this.getIoSocketHandler().getDispatcher());
        }
        return this.timeoutWatchdog;
    }

    public int getConnectionTimeoutSec() {
        return (int)(this.getIoSocketHandler().getConnectionTimeoutMillis() / 1000L);
    }

    public int getIdleTimeoutSec() {
        return (int)(this.getIoSocketHandler().getIdleTimeoutMillis() / 1000L);
    }

    public void setFlushmode(IConnection.FlushMode mode) {
        super.setFlushmode(mode);
    }

    public IConnection.FlushMode getFlushmode() {
        return super.getFlushmode();
    }

    public void setWriteTransferRate(int bytesPerSecond) throws ClosedConnectionException, IOException {
        IoDelayWriteHandler delayHandler = this.getDelayIOHandler();
        if (bytesPerSecond == Integer.MAX_VALUE) {
            if (delayHandler != null) {
                delayHandler.flushOutgoing();
                IoHandler ioHandler = delayHandler.getSuccessor();
                this.setIOHandler(ioHandler);
            }
        } else {
            if (delayHandler == null) {
                delayHandler = new IoDelayWriteHandler(this.getIOHandler());
                this.setIOHandler(delayHandler);
            }
            delayHandler.setWriteRateSec(bytesPerSecond);
        }
    }

    private IoDelayWriteHandler getDelayIOHandler() {
        IoHandler ioHandler = this.getIOHandler();
        do {
            if (!(ioHandler instanceof IoDelayWriteHandler)) continue;
            return (IoDelayWriteHandler)ioHandler;
        } while ((ioHandler = ioHandler.getSuccessor()) != null);
        return null;
    }

    public int getNumberOfAvailableBytes() {
        return this.getReadQueue().getSize();
    }

    public ByteBuffer[] readAvailable() throws IOException, ClosedConnectionException {
        LinkedList<ByteBuffer> buffers = this.extractAvailableFromReadQueue();
        if (buffers != null) {
            return buffers.toArray(new ByteBuffer[buffers.size()]);
        }
        return new ByteBuffer[0];
    }

    public boolean readAvailableByDelimiter(String delimiter, WritableByteChannel outputChannel) throws IOException, ClosedConnectionException {
        return this.extractAvailableFromReadQueue(delimiter, outputChannel);
    }

    public int read(ByteBuffer buffer) throws IOException {
        ByteBuffer[] bufs;
        int size = buffer.remaining();
        int available = this.getNumberOfAvailableBytes();
        if (available < size) {
            size = available;
        }
        for (ByteBuffer buf : bufs = this.readByteBufferByLength(size)) {
            while (buf.hasRemaining()) {
                buffer.put(buf);
            }
        }
        return size;
    }

    public byte readByte() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractByteFromReadQueue();
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.readByteBufferByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException, BufferUnderflowException {
        LinkedList<ByteBuffer> result = this.extractBytesByDelimiterFromReadQueue(delimiter, maxLength);
        return result.toArray(new ByteBuffer[result.size()]);
    }

    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException {
        LinkedList<ByteBuffer> extracted = this.extractBytesByLength(length);
        return extracted.toArray(new ByteBuffer[extracted.size()]);
    }

    public byte[] readBytesByDelimiter(String delimiter) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.readBytesByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException, BufferUnderflowException {
        return DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, maxLength));
    }

    public byte[] readBytesByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return DataConverter.toBytes(this.readByteBufferByLength(length));
    }

    public double readDouble() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractDoubleFromReadQueue();
    }

    public int readInt() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractIntFromReadQueue();
    }

    public long readLong() throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.extractLongFromReadQueue();
    }

    public String readStringByDelimiter(String delimiter) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        return this.readStringByDelimiter(delimiter, this.getDefaultEncoding(), maxLength);
    }

    public String readStringByDelimiter(String delimiter, String encoding) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        LinkedList<ByteBuffer> extracted = this.extractBytesByDelimiterFromReadQueue(delimiter, maxLength);
        return DataConverter.toString(extracted, encoding);
    }

    public String readStringByLength(int length) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByLength(length, this.getDefaultEncoding());
    }

    public String readStringByLength(int length, String encoding) throws IOException, ClosedConnectionException, BufferUnderflowException, UnsupportedEncodingException {
        LinkedList<ByteBuffer> extracted = this.extractBytesByLength(length);
        return DataConverter.toString(extracted, encoding);
    }

    public int getIndexOf(String str, int maxLength) throws IOException, ClosedConnectionException, BufferUnderflowException, MaxReadSizeExceededException {
        return this.readIndexOf(str, maxLength);
    }

    public int getIndexOf(String str) throws IOException, ClosedConnectionException, BufferUnderflowException {
        return this.getIndexOf(str, Integer.MAX_VALUE);
    }

    void onConnectionTimeout() {
        block5: {
            try {
                if (this.isTimeoutHandler) {
                    boolean handled = ((ITimeoutHandler)this.appHandler).onConnectionTimeout(this);
                    this.internalFlush();
                    if (!handled) {
                        this.close();
                    }
                } else {
                    this.close();
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.fine("error occured by handling connection timeout event. Reason: " + e.toString());
            }
        }
    }

    void onIdleTimeout() {
        block5: {
            try {
                if (this.isTimeoutHandler) {
                    boolean handled = ((ITimeoutHandler)this.appHandler).onIdleTimeout(this);
                    this.internalFlush();
                    if (!handled) {
                        this.close();
                    }
                } else {
                    this.close();
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.fine("error occured by handling idle timeout event. Reason: " + e.toString());
            }
        }
    }

    private static synchronized Timer getTimer() {
        if (watchDogTimer == null) {
            watchDogTimer = new Timer("xNBCWatchdogTimer", true);
        }
        return watchDogTimer;
    }

    static boolean isSynchronized(IHandler hdl) {
        if (hdl == null) {
            return true;
        }
        Synchronized sync = hdl.getClass().getAnnotation(Synchronized.class);
        if (sync != null) {
            Synchronized.Mode scope = sync.value();
            return scope == Synchronized.Mode.CONNECTION;
        }
        return true;
    }

    protected void onDataEvent() {
        this.receive();
        if (this.isDataHandler) {
            Runnable task = new Runnable(){

                public void run() {
                    block7: {
                        try {
                            boolean remaingDataToHandle = false;
                            int modifyVersion = 0;
                            do {
                                remaingDataToHandle = false;
                                modifyVersion = NonBlockingConnection.this.getReadQueue().getModifyVersion();
                                ((IDataHandler)NonBlockingConnection.this.appHandler).onData(NonBlockingConnection.this);
                                if (NonBlockingConnection.this.getReadQueue().isEmpty() || modifyVersion == NonBlockingConnection.this.getReadQueue().getModifyVersion()) continue;
                                remaingDataToHandle = true;
                            } while (remaingDataToHandle);
                        }
                        catch (MaxReadSizeExceededException mee) {
                            try {
                                NonBlockingConnection.this.close();
                            }
                            catch (Exception exception) {}
                        }
                        catch (BufferUnderflowException bue) {
                        }
                        catch (Exception e) {
                            if (!LOG.isLoggable(Level.FINE)) break block7;
                            LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling data. Reason: " + e.toString());
                        }
                    }
                }
            };
            this.taskQueue.processTask(this.workerPool, task, this.taskProcessor);
        }
    }

    protected boolean listenForConnect() {
        return this.isConnectHandler;
    }

    protected void onConnectEvent() {
        if (this.isConnectHandler) {
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ((IConnectHandler)NonBlockingConnection.this.appHandler).onConnect(NonBlockingConnection.this);
                    }
                    catch (Exception e) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling connect. Reason: " + e.toString());
                        }
                    }
                    finally {
                        try {
                            NonBlockingConnection.this.internalFlush();
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            this.taskQueue.processTask(this.workerPool, task, this.taskProcessor);
        }
    }

    protected boolean listenForDisconnect() {
        return this.isDisconnectHandler;
    }

    protected void onDisconnectEvent() {
        if (this.isDisconnectHandler) {
            Runnable task = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            ((IDisconnectHandler)NonBlockingConnection.this.appHandler).onDisconnect(NonBlockingConnection.this);
                        }
                        catch (Exception e) {
                            if (!LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling connect. Reason: " + e.toString());
                        }
                    }
                }
            };
            this.taskQueue.processTask(this.workerPool, task, this.taskProcessor);
        }
    }

    protected void onConnectionTimeoutEvent() {
        block4: {
            if (this.isTimeoutHandler) {
                Runnable task = new Runnable(){

                    public void run() {
                        block3: {
                            try {
                                boolean isHandled = ((ITimeoutHandler)NonBlockingConnection.this.appHandler).onConnectionTimeout(NonBlockingConnection.this);
                                if (!isHandled) {
                                    NonBlockingConnection.this.close();
                                }
                            }
                            catch (Exception e) {
                                if (!LOG.isLoggable(Level.FINE)) break block3;
                                LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling onConnectionTimeout. Reason: " + e.toString());
                            }
                        }
                    }
                };
                this.taskQueue.processTask(this.workerPool, task, this.taskProcessor);
            } else {
                try {
                    this.close();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("[" + this.getId() + "] error occured closing connection caused by connection timeout. Reason: " + ioe.toString());
                }
            }
        }
    }

    protected void onIdleTimeoutEvent() {
        block4: {
            if (this.isTimeoutHandler) {
                Runnable task = new Runnable(){

                    public void run() {
                        block3: {
                            try {
                                boolean isHandled = ((ITimeoutHandler)NonBlockingConnection.this.appHandler).onIdleTimeout(NonBlockingConnection.this);
                                if (!isHandled) {
                                    NonBlockingConnection.this.close();
                                }
                            }
                            catch (Exception e) {
                                if (!LOG.isLoggable(Level.FINE)) break block3;
                                LOG.fine("[" + NonBlockingConnection.this.getId() + "] error occured by handling onIdleTimeout. Reason: " + e.toString());
                            }
                        }
                    }
                };
                this.taskQueue.processTask(this.workerPool, task, this.taskProcessor);
            } else {
                try {
                    this.close();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("[" + this.getId() + "]  error occured closing connection caused by idle timeout. Reason: " + ioe.toString());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TimeoutWatchdog {
        private TimerTask watchdogTimerTask = null;
        private IDispatcher<IoSocketHandler> dispatcher = null;

        private TimeoutWatchdog() {
        }

        synchronized void setDispatcher(IDispatcher<IoSocketHandler> dispatcher) {
            this.dispatcher = dispatcher;
        }

        void updateTimeoutCheckPeriod(long idleTimeoutMillis, long connectionTimeoutMillis) {
            long period = idleTimeoutMillis;
            if (connectionTimeoutMillis < idleTimeoutMillis) {
                period = connectionTimeoutMillis;
            }
            if (period > 4500000L) {
                period = 4500000L;
            }
            this.setTimeoutCheckPeriod((int)((double)period / 5.0));
        }

        private void setTimeoutCheckPeriod(long period) {
            if (this.watchdogTimerTask != null) {
                this.watchdogTimerTask.cancel();
            }
            this.watchdogTimerTask = new TimerTask(){

                public void run() {
                    TimeoutWatchdog.this.checkDispatcherTimeout();
                }
            };
            NonBlockingConnection.getTimer().schedule(this.watchdogTimerTask, period, period);
        }

        void shutdown() {
            if (this.watchdogTimerTask != null) {
                this.watchdogTimerTask.cancel();
            }
        }

        private synchronized void checkDispatcherTimeout() {
            block3: {
                try {
                    long current = System.currentTimeMillis();
                    Set<IoSocketHandler> socketHandlers = this.dispatcher.getRegistered();
                    for (IoSocketHandler socketHandler : socketHandlers) {
                        this.checkTimeout(socketHandler, current);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("error occured: " + e.toString());
                }
            }
        }

        private void checkTimeout(IoSocketHandler ioSocketHandler, long current) {
            ioSocketHandler.checkConnection();
            ioSocketHandler.checkIdleTimeout(current);
            ioSocketHandler.checkConnectionTimeout(current);
        }
    }

    private final class NonSynchronizedTaskProcessor
    implements Runnable {
        private NonSynchronizedTaskProcessor() {
        }

        public void run() {
            block3: {
                Runnable task = (Runnable)NonBlockingConnection.this.taskQueue.tasks.poll();
                if (task != null) {
                    try {
                        task.run();
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("error occured by proccesing task " + task);
                    }
                }
            }
        }
    }

    private final class SynchronizedTaskProcessor
    implements Runnable {
        private SynchronizedTaskProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            NonBlockingConnection nonBlockingConnection = NonBlockingConnection.this;
            synchronized (nonBlockingConnection) {
                block6: {
                    Runnable task = (Runnable)NonBlockingConnection.this.taskQueue.tasks.poll();
                    if (task != null) {
                        try {
                            task.run();
                        }
                        catch (Exception e) {
                            if (!LOG.isLoggable(Level.FINE)) break block6;
                            LOG.fine("error occured by proccesing task " + task);
                        }
                    }
                }
            }
        }
    }

    private final class TaskQueue {
        private final Queue<Runnable> tasks = new ConcurrentLinkedQueue<Runnable>();

        private TaskQueue() {
        }

        public void processTask(IWorkerPool workerPool, Runnable newTask, Runnable taskProcessor) {
            this.tasks.offer(newTask);
            workerPool.execute(taskProcessor);
        }
    }
}

