/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.xsocket.ClosedConnectionException;
import org.xsocket.stream.AbstractConnectionPool;
import org.xsocket.stream.IConnection;
import org.xsocket.stream.INonBlockingConnection;
import org.xsocket.stream.NonBlockingConnection;
import org.xsocket.stream.WaitTimeoutException;

public final class NonBlockingConnectionPool
extends AbstractConnectionPool {
    public static final long UNLIMITED_TIMEOUT = Long.MAX_VALUE;

    public NonBlockingConnectionPool(long timeToIdleMillis) {
        this(timeToIdleMillis, Integer.MAX_VALUE, -1L);
    }

    public NonBlockingConnectionPool(long timeToIdleMillis, int maxActive, long maxWaitTimeMillis) {
        super(timeToIdleMillis, Long.MAX_VALUE, maxActive, maxWaitTimeMillis, Integer.MAX_VALUE);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port) throws IOException, WaitTimeoutException {
        return (INonBlockingConnection)((Object)this.getConnection(new InetSocketAddress(host, port)));
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port) throws IOException, WaitTimeoutException {
        return (INonBlockingConnection)((Object)this.getConnection(new InetSocketAddress(address, port)));
    }

    AbstractConnectionPool.PoolableConnection createConnection(InetSocketAddress address) throws IOException {
        return new PoolableNonBlockingConnection(address);
    }

    private final class PoolableNonBlockingConnection
    extends AbstractConnectionPool.PoolableConnection
    implements INonBlockingConnection {
        public PoolableNonBlockingConnection(InetSocketAddress address) throws IOException {
            super(NonBlockingConnectionPool.this, new NonBlockingConnection(address.getAddress(), address.getPort()), address);
        }

        public void setFlushmode(IConnection.FlushMode flushMode) {
            this.getUnderlyingConnection().setFlushmode(flushMode);
        }

        public IConnection.FlushMode getFlushmode() {
            return this.getUnderlyingConnection().getFlushmode();
        }

        public void setIdleTimeoutSec(int timeoutInSec) {
            this.getUnderlyingConnection().setIdleTimeoutSec(timeoutInSec);
        }

        public int getIdleTimeoutSec() {
            return this.getUnderlyingConnection().getIdleTimeoutSec();
        }

        public void setConnectionTimeoutSec(int timeoutSec) {
            this.getUnderlyingConnection().setConnectionTimeoutSec(timeoutSec);
        }

        public int getConnectionTimeoutSec() {
            return this.getUnderlyingConnection().getConnectionTimeoutSec();
        }

        public void setWriteTransferRate(int bytesPerSecond) throws ClosedConnectionException, IOException {
            this.getUnderlyingConnection().setWriteTransferRate(bytesPerSecond);
        }

        public ByteBuffer[] readAvailable() throws IOException, ClosedConnectionException {
            return this.getUnderlyingConnection().readAvailable();
        }

        public boolean readAvailableByDelimiter(String delimiter, WritableByteChannel outputChannel) throws IOException, ClosedConnectionException {
            return this.getUnderlyingConnection().readAvailableByDelimiter(delimiter, outputChannel);
        }

        public int getNumberOfAvailableBytes() {
            return this.getUnderlyingConnection().getNumberOfAvailableBytes();
        }

        public int indexOf(String str) {
            return this.getUnderlyingConnection().indexOf(str);
        }

        private NonBlockingConnection getUnderlyingConnection() {
            return (NonBlockingConnection)this.getDelegee();
        }
    }
}

