/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;

public final class StreamSocketConfiguration {
    private final Map<Integer, Object> options = new HashMap<Integer, Object>();

    void setOptions(Socket socket) throws SocketException {
        for (Map.Entry<Integer, Object> entry : this.options.entrySet()) {
            StreamSocketConfiguration.setOption(socket, (int)entry.getKey(), entry.getValue());
        }
    }

    void setOptions(ServerSocket socket) throws SocketException {
        for (Map.Entry<Integer, Object> entry : this.options.entrySet()) {
            StreamSocketConfiguration.setOption(socket, (int)entry.getKey(), entry.getValue());
        }
    }

    static void setOption(Socket socket, int optID, Object value) throws SocketException {
        switch (optID) {
            case 1: {
                socket.setTcpNoDelay((Boolean)value);
                break;
            }
            case 4102: {
                socket.setSoTimeout((Integer)value);
                break;
            }
            case 4097: {
                socket.setSendBufferSize((Integer)value);
                break;
            }
            case 4: {
                socket.setReuseAddress((Boolean)value);
                break;
            }
            case 4098: {
                socket.setReceiveBufferSize((Integer)value);
                break;
            }
            case 4099: {
                socket.setOOBInline((Boolean)value);
                break;
            }
            case 128: {
                if (value instanceof Integer) {
                    socket.setSoLinger(true, (Integer)value);
                    break;
                }
                if (!(value instanceof Boolean) || !((Boolean)value).equals(Boolean.FALSE)) break;
                socket.setSoLinger(Boolean.FALSE, 0);
                break;
            }
            case 8: {
                socket.setKeepAlive((Boolean)value);
                break;
            }
            case 3: {
                socket.setTrafficClass((Integer)value);
                break;
            }
        }
    }

    static void setOption(ServerSocket socket, int optID, Object value) throws SocketException {
        switch (optID) {
            case 4098: {
                socket.setReceiveBufferSize((Integer)value);
                break;
            }
            case 4: {
                socket.setReuseAddress((Boolean)value);
                break;
            }
        }
    }

    static Object getOption(Socket socket, int optID) throws SocketException {
        switch (optID) {
            case 1: {
                return socket.getTcpNoDelay();
            }
            case 4102: {
                return socket.getSoTimeout();
            }
            case 4097: {
                return socket.getSendBufferSize();
            }
            case 4: {
                return socket.getReuseAddress();
            }
            case 4098: {
                return socket.getReceiveBufferSize();
            }
            case 4099: {
                return socket.getOOBInline();
            }
            case 128: {
                return socket.getSoLinger();
            }
            case 8: {
                return socket.getKeepAlive();
            }
            case 3: {
                return socket.getTrafficClass();
            }
        }
        throw new RuntimeException("unsupported option id: " + optID);
    }

    public void setSO_REUSEADDR(Boolean b) {
        this.options.put(4, b);
    }

    public void setTCP_NODELAY(Boolean b) {
        this.options.put(1, b);
    }

    public void setSO_TIMEOUT(Integer i) {
        this.options.put(4102, i);
    }

    public void setSO_SNDBUF(Integer i) {
        this.options.put(4097, i);
    }

    public void setSO_RCVBUF(Integer i) {
        this.options.put(4098, i);
    }

    public void setSO_OOBINLINE(Boolean b) {
        this.options.put(4099, b);
    }

    public void setSO_KEEPALIVE(Boolean b) {
        this.options.put(8, b);
    }

    public void setIP_TOS(Integer i) {
        this.options.put(3, i);
    }

    public void setSO_LINGER(Integer i) {
        if (i < 0) {
            this.options.put(128, Boolean.FALSE);
        } else {
            this.options.put(128, i);
        }
    }
}

