/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import org.xsocket.IDispatcher;
import org.xsocket.IWorkerPool;
import org.xsocket.stream.IMultithreadedServer;
import org.xsocket.stream.IMutlithreadedServerListener;
import org.xsocket.stream.INonBlockingConnection;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static int validateSufficientDatasizeByIntLengthField(INonBlockingConnection connection) throws IOException, BufferUnderflowException {
        connection.resetToReadMark();
        connection.markReadPosition();
        int length = connection.readInt();
        if (connection.getNumberOfAvailableBytes() < length) {
            throw new BufferUnderflowException();
        }
        connection.removeReadMark();
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(IMultithreadedServer server) {
        IMutlithreadedServerListener startupListener = new IMutlithreadedServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onInit() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    this.notify();
                }
            }

            public void onWorkerPoolUpdated(IWorkerPool oldWorkerPool, IWorkerPool newWorkerPool) {
            }

            public void onDispatcherRemoved(IDispatcher dispatcher) {
            }

            public void onDispatcherAdded(IDispatcher dispatcher) {
            }

            public void onDestroy() {
            }
        };
        server.addListener(startupListener);
        Thread t = new Thread(server);
        t.start();
        if (!server.isOpen()) {
            IMutlithreadedServerListener iMutlithreadedServerListener = startupListener;
            synchronized (iMutlithreadedServerListener) {
                try {
                    startupListener.wait();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
        }
        t.setName("xServer:" + server.getLocalPort());
        server.removeListener(startupListener);
    }
}

