/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.management;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xsocket.ILifeCycle;
import org.xsocket.stream.BlockingConnectionPool;
import org.xsocket.stream.NonBlockingConnectionPool;
import org.xsocket.stream.management.IntrospectionBasedDynamicBean;

public final class ConnectionPoolMBeanProxyFactory {
    public static void createAndRegister(BlockingConnectionPool pool) throws JMException {
        ConnectionPoolMBeanProxyFactory.createAndRegister(pool, "org.xsocket.stream");
    }

    public static void createAndRegister(NonBlockingConnectionPool pool) throws JMException {
        ConnectionPoolMBeanProxyFactory.createAndRegister(pool, "org.xsocket.stream");
    }

    public static void createAndRegister(BlockingConnectionPool pool, String domain) throws JMException {
        ConnectionPoolMBeanProxyFactory.createAndRegister(ManagementFactory.getPlatformMBeanServer(), pool, domain);
    }

    public static void createAndRegister(NonBlockingConnectionPool pool, String domain) throws JMException {
        ConnectionPoolMBeanProxyFactory.createAndRegister(ManagementFactory.getPlatformMBeanServer(), pool, domain);
    }

    public static void createAndRegister(MBeanServer mbeanServer, BlockingConnectionPool pool, String domain) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=BlockingConnectionPool,name=" + pool.hashCode());
        ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicBean(pool), objectName);
        new BlockingConnectionPoolListener(pool, domain);
    }

    public static void createAndRegister(MBeanServer mbeanServer, NonBlockingConnectionPool pool, String domain) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=NonBlockingConnectionPool,name=" + pool.hashCode());
        ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicBean(pool), objectName);
        new NonBlockingConnectionPoolListener(pool, domain);
    }

    private static void unregister(BlockingConnectionPool pool, String domain) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=BlockingConnectionPool,name=" + pool.hashCode());
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
    }

    private static void unregister(NonBlockingConnectionPool pool, String domain) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=NonBlockingConnectionPool,name=" + pool.hashCode());
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
    }

    private static final class NonBlockingConnectionPoolListener
    implements ILifeCycle {
        private static final Logger LOG = Logger.getLogger(BlockingConnectionPoolListener.class.getName());
        private NonBlockingConnectionPool pool = null;
        private String domain = null;

        NonBlockingConnectionPoolListener(NonBlockingConnectionPool pool, String domain) {
            this.pool = pool;
            this.domain = domain;
            pool.addListener(this);
        }

        public void onInit() {
        }

        public void onDestroy() {
            block2: {
                try {
                    ConnectionPoolMBeanProxyFactory.unregister(this.pool, this.domain);
                }
                catch (Exception ex) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by deregistering the pool (domain=" + this.domain + "). reason: " + ex.toString());
                }
            }
        }
    }

    private static final class BlockingConnectionPoolListener
    implements ILifeCycle {
        private static final Logger LOG = Logger.getLogger(BlockingConnectionPoolListener.class.getName());
        private BlockingConnectionPool pool = null;
        private String domain = null;

        BlockingConnectionPoolListener(BlockingConnectionPool pool, String domain) {
            this.pool = pool;
            this.domain = domain;
            pool.addListener(this);
        }

        public void onInit() {
        }

        public void onDestroy() {
            block2: {
                try {
                    ConnectionPoolMBeanProxyFactory.unregister(this.pool, this.domain);
                }
                catch (Exception ex) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by deregistering the pool (domain=" + this.domain + "). reason: " + ex.toString());
                }
            }
        }
    }
}

