/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream.management;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xsocket.Dispatcher;
import org.xsocket.DynamicWorkerPool;
import org.xsocket.IDispatcher;
import org.xsocket.IWorkerPool;
import org.xsocket.stream.IMultithreadedServer;
import org.xsocket.stream.IMutlithreadedServerListener;
import org.xsocket.stream.MultithreadedServer;
import org.xsocket.stream.management.IntrospectionBasedDynamicBean;

public final class MultithreadedServerMBeanProxyFactory {
    public static void createAndRegister(MultithreadedServer server) throws JMException {
        MultithreadedServerMBeanProxyFactory.createAndRegister(server, "org.xsocket.stream");
    }

    public static void createAndRegister(MultithreadedServer server, String domain) throws JMException {
        MultithreadedServerMBeanProxyFactory.createAndRegister(ManagementFactory.getPlatformMBeanServer(), server, domain);
    }

    public static void createAndRegister(MBeanServer mbeanServer, MultithreadedServer server, String domain) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=MultithreadedServer,name=" + server.getLocalAddress().getHostName() + "." + server.getLocalPort());
        ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicBean(server), objectName);
        Listener listener = new Listener(server, domain);
        listener.onWorkerPoolUpdated(null, server.getWorkerPool());
        for (IDispatcher dispatcher : server.getDispatcher()) {
            listener.onDispatcherAdded(dispatcher);
        }
    }

    private static void unregister(IMultithreadedServer server, String domain) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=MultithreadedServer,name=" + server.getLocalAddress().getHostName() + "." + server.getLocalPort());
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
    }

    private static void registerIoSocketDispatcher(Dispatcher dispatcher, String domain, String hostname, int port) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=IoSocketDispatcher,name=" + hostname + "." + port + "." + dispatcher.hashCode());
        ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicBean(dispatcher), objectName);
    }

    private static void unregisterIoSocketDispatcher(Dispatcher dispatcher, String domain, String hostname, int port) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=IoSocketDispatcher,name=" + hostname + "." + port + "." + dispatcher.hashCode());
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
    }

    private static void registerDynamicWorkerPool(DynamicWorkerPool workerPool, String domain, String hostname, int port) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=DynamicWorkerPool,name=" + hostname + "." + port);
        ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicBean(workerPool), objectName);
    }

    private static void unregisterDynamicWorkerPool(DynamicWorkerPool workerPool, String domain, String hostname, int port) throws JMException {
        ObjectName objectName = new ObjectName(domain + ":type=DynamicWorkerPool,name=" + hostname + "." + port);
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
    }

    private static final class Listener
    implements IMutlithreadedServerListener {
        private static final Logger LOG = Logger.getLogger(Listener.class.getName());
        private MultithreadedServer server = null;
        private String domain = null;

        Listener(MultithreadedServer server, String domain) {
            this.server = server;
            this.domain = domain;
            server.addListener(this);
        }

        public void onInit() {
        }

        public void onDestroy() {
            block2: {
                try {
                    MultithreadedServerMBeanProxyFactory.unregister(this.server, this.domain);
                }
                catch (Exception ex) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by deregistering the server (domain=" + this.domain + "). reason: " + ex.toString());
                }
            }
        }

        public void onWorkerPoolUpdated(IWorkerPool oldWorkerPool, IWorkerPool newWorkerPool) {
            try {
                if (oldWorkerPool != null && oldWorkerPool instanceof DynamicWorkerPool) {
                    MultithreadedServerMBeanProxyFactory.unregisterDynamicWorkerPool((DynamicWorkerPool)oldWorkerPool, this.domain, this.server.getLocalAddress().getHostName(), this.server.getLocalPort());
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                if (newWorkerPool != null && newWorkerPool instanceof DynamicWorkerPool) {
                    MultithreadedServerMBeanProxyFactory.registerDynamicWorkerPool((DynamicWorkerPool)newWorkerPool, this.domain, this.server.getLocalAddress().getHostName(), this.server.getLocalPort());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void onDispatcherAdded(IDispatcher dispatcher) {
            try {
                if (dispatcher instanceof Dispatcher && dispatcher.getClass().getSimpleName().equals("IoSocketDispatcher")) {
                    MultithreadedServerMBeanProxyFactory.registerIoSocketDispatcher((Dispatcher)dispatcher, this.domain, this.server.getLocalAddress().getHostName(), this.server.getLocalPort());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void onDispatcherRemoved(IDispatcher dispatcher) {
            try {
                if (dispatcher instanceof Dispatcher && dispatcher.getClass().getSimpleName().equals("IoSocketDispatcher")) {
                    MultithreadedServerMBeanProxyFactory.unregisterIoSocketDispatcher((Dispatcher)dispatcher, this.domain, this.server.getLocalAddress().getHostName(), this.server.getLocalPort());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

