/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.xsocket.DataConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteBufferQueue {
    private LinkedList<ByteBuffer> buffers = null;
    private Integer currentSize = null;
    private int insertVersion = 0;

    public synchronized boolean isEmpty() {
        if (this.buffers == null) {
            return true;
        }
        return this.buffers.isEmpty();
    }

    public synchronized int getSize() {
        if (this.currentSize != null) {
            return this.currentSize;
        }
        if (this.isEmpty()) {
            return 0;
        }
        int size = 0;
        for (ByteBuffer buffer : this.buffers) {
            size += buffer.remaining();
        }
        this.currentSize = size;
        return size;
    }

    public synchronized int getFirstBufferSize() {
        if (this.buffers == null) {
            return 0;
        }
        if (this.buffers.isEmpty()) {
            this.buffers = null;
            return 0;
        }
        ByteBuffer buffer = this.buffers.getFirst();
        return buffer.remaining();
    }

    public synchronized void append(ByteBuffer data) {
        if (data != null && data.hasRemaining()) {
            this.currentSize = null;
            ++this.insertVersion;
            if (this.buffers == null) {
                this.buffers = new LinkedList();
            }
            this.buffers.add(data);
        }
    }

    public synchronized void append(LinkedList<ByteBuffer> bufs) {
        if (bufs != null && bufs.size() > 0) {
            this.currentSize = null;
            ++this.insertVersion;
            if (this.buffers == null) {
                this.buffers = bufs;
            } else {
                this.buffers.addAll(bufs);
            }
        }
    }

    public synchronized void addFirst(ByteBuffer buffer) {
        if (buffer != null && buffer.hasRemaining()) {
            this.currentSize = null;
            ++this.insertVersion;
            if (this.buffers == null) {
                this.buffers = new LinkedList();
            }
            this.buffers.addFirst(buffer);
        }
    }

    public synchronized void addFirst(LinkedList<ByteBuffer> bufs) {
        if (bufs != null && bufs.size() > 0) {
            this.currentSize = null;
            ++this.insertVersion;
            if (this.buffers == null) {
                this.buffers = bufs;
            } else {
                bufs.addAll(this.buffers);
                this.buffers = bufs;
            }
        }
    }

    public synchronized void addFirstSilence(LinkedList<ByteBuffer> bufs) {
        if (bufs != null && bufs.size() > 0) {
            this.currentSize = null;
            if (this.buffers == null) {
                this.buffers = bufs;
            } else {
                bufs.addAll(this.buffers);
                this.buffers = bufs;
            }
        }
    }

    public synchronized LinkedList<ByteBuffer> drain() {
        if (this.buffers != null) {
            if (!this.buffers.isEmpty()) {
                this.currentSize = null;
                LinkedList<ByteBuffer> result = this.buffers;
                this.buffers = null;
                return result;
            }
            this.buffers = null;
        }
        return new LinkedList<ByteBuffer>();
    }

    public synchronized ByteBuffer removeFirst() {
        if (this.buffers == null) {
            return null;
        }
        if (this.buffers.isEmpty()) {
            this.buffers = null;
            return null;
        }
        this.currentSize = null;
        return this.buffers.removeFirst();
    }

    public int getInsertVersionVersion() {
        return this.insertVersion;
    }

    public synchronized ByteBuffer read(int length) throws BufferUnderflowException {
        if (this.buffers == null) {
            throw new BufferUnderflowException();
        }
        if (!this.isSizeEqualsOrLargerThan(length)) {
            throw new BufferUnderflowException();
        }
        this.currentSize = null;
        ByteBuffer buffer = this.buffers.removeFirst();
        int remainingFirst = buffer.remaining();
        if (remainingFirst == length) {
            return buffer;
        }
        if (remainingFirst > length) {
            int savedLimit = buffer.limit();
            int savedPos = buffer.position();
            buffer.limit(buffer.position() + length);
            ByteBuffer resultBuf = buffer.slice();
            buffer.position(savedPos + length);
            buffer.limit(savedLimit);
            this.addFirst(buffer.slice());
            return resultBuf;
        }
        ByteBuffer result = ByteBuffer.allocate(length);
        int written = 0;
        while (true) {
            if (buffer.hasRemaining()) {
                result.put(buffer.get());
                if (++written != length) continue;
                if (buffer.position() < buffer.limit()) {
                    this.buffers.addFirst(buffer.slice());
                }
                result.clear();
                return result;
            }
            buffer = this.buffers.poll();
        }
    }

    private boolean isSizeEqualsOrLargerThan(int size) {
        if (this.buffers == null) {
            return false;
        }
        int l = 0;
        for (ByteBuffer buffer : this.buffers) {
            if ((l += buffer.remaining()) < size) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.buffers != null) {
            ByteBuffer[] copy = new ByteBuffer[this.buffers.size()];
            try {
                for (int i = 0; i < copy.length; ++i) {
                    copy[i] = this.buffers.get(i).duplicate();
                }
                sb.append(DataConverter.toString(copy, "US-ASCII", Integer.MAX_VALUE));
            }
            catch (Exception ignore) {
                sb.append(DataConverter.toHexString(copy, Integer.MAX_VALUE));
            }
        }
        return sb.toString();
    }
}

