/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.IDispatcher;
import org.xsocket.IEventHandler;
import org.xsocket.IHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dispatcher<T extends IHandle>
implements IDispatcher<T> {
    private static final Logger LOG = Logger.getLogger(Dispatcher.class.getName());
    private static final long TIMEOUT_SHUTDOWN_MILLIS = 5000L;
    private boolean isOpen = true;
    private final Object dispatcherThreadGuard = new Object();
    private Selector selector = null;
    private IEventHandler<T> eventHandler = null;
    private long handledRegistractions = 0L;
    private long handledReads = 0L;
    private long handledWrites = 0L;

    public Dispatcher(IEventHandler<T> eventHandler) {
        assert (eventHandler != null) : "null is not allowed for event handler ";
        this.eventHandler = eventHandler;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("dispatcher " + this.hashCode() + " has been created (eventHandler=" + eventHandler + ")");
        }
        try {
            this.selector = Selector.open();
        }
        catch (IOException ioe) {
            String text = "exception occured while opening selector. Reason: " + ioe.toString();
            LOG.severe(text);
            throw new RuntimeException(text, ioe);
        }
    }

    @Override
    public final IEventHandler<T> getEventHandler() {
        return this.eventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(T handle, int ops) throws IOException {
        assert (!handle.getChannel().isBlocking());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("register handle " + handle);
        }
        Object object = this.dispatcherThreadGuard;
        synchronized (object) {
            this.selector.wakeup();
            handle.getChannel().register(this.selector, ops, handle);
            this.eventHandler.onHandleRegisterEvent(handle);
        }
        ++this.handledRegistractions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregister(T handle) throws IOException {
        Object object = this.dispatcherThreadGuard;
        synchronized (object) {
            this.selector.wakeup();
            SelectionKey key = handle.getChannel().keyFor(this.selector);
            if (key.isValid()) {
                key.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<T> getRegistered() {
        HashSet<IHandle> registered = new HashSet<IHandle>();
        if (this.selector != null) {
            SelectionKey[] selKeys = null;
            Object object = this.dispatcherThreadGuard;
            synchronized (object) {
                this.selector.wakeup();
                Set<SelectionKey> keySet = this.selector.keys();
                selKeys = keySet.toArray(new SelectionKey[keySet.size()]);
            }
            try {
                for (SelectionKey key : selKeys) {
                    IHandle handle = (IHandle)key.attachment();
                    registered.add(handle);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateInterestSet(T handle, int ops) throws IOException {
        SelectionKey key = handle.getChannel().keyFor(this.selector);
        if (key != null) {
            Object object = this.dispatcherThreadGuard;
            synchronized (object) {
                if (key.isValid()) {
                    key.selector().wakeup();
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("updating interest ops for " + handle + ". current value is " + this.printSelectionKeyValue(key.interestOps()));
                    }
                    key.interestOps(ops);
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("interest ops has been updated to " + this.printSelectionKeyValue(ops));
                    }
                } else {
                    throw new IOException("handle " + handle + " is invalid ");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("selector  listening ...");
        }
        while (this.isOpen) {
            try {
                Object object = this.dispatcherThreadGuard;
                synchronized (object) {
                }
                int eventCount = this.selector.select(1000L);
                if (eventCount <= 0) continue;
                Set<SelectionKey> selectedEventKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> it = selectedEventKeys.iterator();
                while (it.hasNext()) {
                    SelectionKey eventKey = it.next();
                    it.remove();
                    IHandle handle = (IHandle)eventKey.attachment();
                    if (eventKey.isValid() && eventKey.isReadable()) {
                        this.eventHandler.onHandleReadableEvent(handle);
                        ++this.handledReads;
                    }
                    if (!eventKey.isValid() || !eventKey.isWritable()) continue;
                    ++this.handledWrites;
                    this.eventHandler.onHandleWriteableEvent(handle);
                }
            }
            catch (Throwable e) {
                LOG.warning("exception occured while processing. Reason " + e.toString());
            }
        }
        this.closeDispatcher();
    }

    private void closeDispatcher() {
        block3: {
            LOG.fine("closing connections");
            if (this.selector != null) {
                try {
                    this.selector.close();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("error occured by close selector within tearDown " + e.toString());
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.isOpen && this.selector != null) {
            Set<T> openHandles = this.getRegistered();
            final int openConnections = openHandles.size();
            for (IHandle handle : openHandles) {
                this.eventHandler.onDispatcherCloseEvent(handle);
            }
            Thread closer = new Thread(){

                public void run() {
                    long start = System.currentTimeMillis();
                    int terminatedConnections = 0;
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() <= start + 5000L) continue;
                        LOG.warning("shutdown timeout reached (" + DataConverter.toFormatedDuration(5000L) + "). kill pending connections");
                        for (SelectionKey sk : Dispatcher.this.selector.keys()) {
                            try {
                                ++terminatedConnections;
                                sk.channel().close();
                            }
                            catch (Exception ignore) {}
                        }
                        break;
                    } while (Dispatcher.this.getRegistered().size() > 0);
                    Dispatcher.this.isOpen = false;
                    Dispatcher.this.selector.wakeup();
                    if ((openConnections > 0 || terminatedConnections > 0) && openConnections > 0 && terminatedConnections > 0) {
                        LOG.info(openConnections - terminatedConnections + " connections has been closed properly, " + terminatedConnections + " connections has been terminate unclean");
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("dispatcher " + this.hashCode() + " has been closed (shutdown time = " + DataConverter.toFormatedDuration(System.currentTimeMillis() - start) + ")");
                    }
                }
            };
            closer.setName("xDispatcherCloser");
            closer.start();
        }
    }

    public final boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public final long getNumberOfHandledRegistrations() {
        return this.handledRegistractions;
    }

    @Override
    public final long getNumberOfHandledReads() {
        return this.handledReads;
    }

    @Override
    public final long getNumberOfHandledWrites() {
        return this.handledWrites;
    }

    private String printSelectionKeyValue(int key) {
        StringBuilder sb = new StringBuilder();
        if ((key & 0x10) == 16) {
            sb.append("OP_ACCEPT, ");
        }
        if ((key & 8) == 8) {
            sb.append("OP_CONNECT, ");
        }
        if ((key & 4) == 4) {
            sb.append("OP_WRITE, ");
        }
        if ((key & 1) == 1) {
            sb.append("OP_READ, ");
        }
        String txt = sb.toString();
        if ((txt = txt.trim()).length() > 0) {
            txt = txt.substring(0, txt.length() - 1);
        }
        return txt + " (" + key + ")";
    }
}

