/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOptions;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.IWorkerPool;
import org.xsocket.datagram.DatagramSocketConfiguration;
import org.xsocket.datagram.IDatagramHandler;
import org.xsocket.datagram.IEndpoint;
import org.xsocket.datagram.UserDatagram;

abstract class AbstractEndpoint
implements IEndpoint {
    private static final Logger LOG = Logger.getLogger(AbstractEndpoint.class.getName());
    private static Executor GLOBAL_WORKERPOOL = Executors.newCachedThreadPool();
    private static String idPrefix = null;
    private static long nextId = 0L;
    private String id = null;
    private String defaultEncoding = "UTF-8";
    private final Object readGuard = new Object();
    private final ReceiveQueue receiveQueue = new ReceiveQueue();
    private int receiveSize = -1;
    private IDatagramHandler datagramHandler = null;
    private Executor workerPool = null;
    private long openTime = -1L;
    private long lastTimeReceived = System.currentTimeMillis();
    private long receivedBytes = 0L;
    private long handleIncomingDatagrams = 0L;
    private long handleOutgoingDatagrams = 0L;

    AbstractEndpoint(IDatagramHandler datagramHandler, int receiveSize, Executor workerPool) {
        this.datagramHandler = datagramHandler;
        this.receiveSize = receiveSize;
        this.workerPool = workerPool;
        this.id = idPrefix + "." + ++nextId;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                AbstractEndpoint.this.close();
            }
        });
        this.openTime = System.currentTimeMillis();
    }

    protected static Executor getGlobalWorkerPool() {
        return GLOBAL_WORKERPOOL;
    }

    public void close() {
    }

    final SocketOptions getSocketOptions(final DatagramSocket socket) {
        return new SocketOptions(){

            public Object getOption(int optID) throws SocketException {
                return DatagramSocketConfiguration.getOption(socket, optID);
            }

            public void setOption(int optID, Object value) throws SocketException {
                DatagramSocketConfiguration.setOption(socket, optID, value);
            }

            public String toString() {
                try {
                    return "TCP_NODELAY=" + this.getOption(1) + ", " + "SO_TIMEOUT=" + this.getOption(4102) + ", " + "SO_SNDBUF=" + this.getOption(4097) + ", " + "SO_REUSEADDR=" + this.getOption(4) + ", " + "SO_RCVBUF=" + this.getOption(4098) + ", " + "IP_TOS=" + this.getOption(3) + ", ";
                }
                catch (Exception e) {
                    return super.toString();
                }
            }
        };
    }

    public void setWorkerPool(IWorkerPool workerPool) {
        this.workerPool = workerPool;
    }

    public IWorkerPool getWorkerPool() {
        return (IWorkerPool)this.workerPool;
    }

    public Executor getWorkerpool() {
        return this.workerPool;
    }

    public final void setReceiveSize(int receivePacketSize) {
        this.receiveSize = receivePacketSize;
    }

    public final int getReceiveSize() {
        return this.receiveSize;
    }

    protected final void onData(SocketAddress address, ByteBuffer data) {
        UserDatagram packet = new UserDatagram(address, data, this.getDefaultEncoding());
        this.receiveQueue.offer(packet);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[/:" + this.getLocalPort() + " " + this.getId() + "] datagram received: " + packet.toString());
        }
        ++this.handleIncomingDatagrams;
        this.lastTimeReceived = System.currentTimeMillis();
        this.receivedBytes += (long)data.remaining();
        if (this.datagramHandler != null) {
            this.workerPool.execute(new HandlerProcessor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UserDatagram receive(long timeoutMillis) throws IOException, SocketTimeoutException {
        if (this.getReceiveSize() == -1) {
            throw new IOException("the receive packet size hasn't been set");
        }
        UserDatagram datagram = null;
        if (timeoutMillis <= 0L) {
            datagram = this.receive();
        } else {
            long start = System.currentTimeMillis();
            Object object = this.readGuard;
            synchronized (object) {
                while ((datagram = this.receive()) == null) {
                    try {
                        this.readGuard.wait(timeoutMillis / 10L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < start + timeoutMillis) continue;
                }
            }
        }
        if (datagram == null) {
            throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(timeoutMillis) + " reached");
        }
        return datagram;
    }

    public UserDatagram receive() {
        return this.receiveQueue.poll();
    }

    public final String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public final void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    protected final void incNumberOfHandledOutgoingDatagram() {
        ++this.handleOutgoingDatagrams;
    }

    public final String getId() {
        return this.id;
    }

    public String toString() {
        return " received=" + DataConverter.toFormatedBytesSize(this.receivedBytes) + ", age=" + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.openTime) + ", lastReceived=" + DataConverter.toFormatedDate(this.lastTimeReceived) + " [" + this.id + "]";
    }

    static {
        String base = null;
        try {
            base = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            base = "locale";
        }
        int random = 0;
        while ((random = new SecureRandom().nextInt()) < 0) {
        }
        idPrefix = Integer.toHexString(base.hashCode()) + "." + Long.toHexString(System.currentTimeMillis()) + "." + Integer.toHexString(random);
    }

    private final class HandlerProcessor
    implements Runnable {
        private HandlerProcessor() {
        }

        public void run() {
            block3: {
                try {
                    if (!AbstractEndpoint.this.receiveQueue.isEmpty()) {
                        AbstractEndpoint.this.datagramHandler.onDatagram(AbstractEndpoint.this);
                    }
                }
                catch (Throwable e) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("error occured by performing onData task. Reason: " + e.toString());
                }
            }
        }
    }

    private static final class ReceiveQueue {
        private List<UserDatagram> receiveQueue = new ArrayList<UserDatagram>();
        private int modifyVersion = 0;

        private ReceiveQueue() {
        }

        public synchronized void offer(UserDatagram userDatagram) {
            ++this.modifyVersion;
            this.receiveQueue.add(userDatagram);
        }

        public synchronized UserDatagram poll() {
            if (this.receiveQueue.isEmpty()) {
                return null;
            }
            ++this.modifyVersion;
            return this.receiveQueue.remove(0);
        }

        public synchronized boolean isEmpty() {
            ++this.modifyVersion;
            return this.receiveQueue.isEmpty();
        }

        public int getModifyVersion() {
            return this.modifyVersion;
        }

        public String toString() {
            return this.receiveQueue.size() + " (modifyVersion=" + this.modifyVersion + ")";
        }
    }
}

