/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.xsocket.DataConverter;
import org.xsocket.IDataSink;
import org.xsocket.IDataSource;
import org.xsocket.MaxReadSizeExceededException;

public final class UserDatagram
implements IDataSource,
IDataSink {
    private SocketAddress remoteSocketAddress = null;
    private ByteBuffer data = null;
    private String defaultEncoding = "UTF-8";

    public UserDatagram(int size) {
        this.init(this.remoteSocketAddress, ByteBuffer.allocate(size), size);
    }

    public UserDatagram(String remoteHost, int remotePort, int size) {
        this.init(new InetSocketAddress(remoteHost, remotePort), ByteBuffer.allocate(size), size);
    }

    public UserDatagram(InetAddress remoteAddress, int remotePort, int size) {
        this.init(new InetSocketAddress(remoteAddress, remotePort), ByteBuffer.allocate(size), size);
    }

    public UserDatagram(SocketAddress address, int size) {
        this.init(address, ByteBuffer.allocate(size), size);
    }

    public UserDatagram(ByteBuffer data) {
        this(null, data);
    }

    public UserDatagram(SocketAddress remoteSocketAddress, ByteBuffer data) {
        this(remoteSocketAddress, data, "UTF-8");
    }

    UserDatagram(SocketAddress remoteSocketAddress, ByteBuffer data, String defaultEncoding) {
        this.init(remoteSocketAddress, data, data.limit());
        this.defaultEncoding = defaultEncoding;
    }

    public UserDatagram(byte[] data) {
        this(null, data);
    }

    public UserDatagram(String remoteHost, int remotePort, byte[] data) {
        this((SocketAddress)new InetSocketAddress(remoteHost, remotePort), data);
    }

    public UserDatagram(SocketAddress remoteSocketAddress, byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.position(buffer.limit());
        this.init(remoteSocketAddress, buffer, data.length);
    }

    private void init(SocketAddress remoteSocketAddress, ByteBuffer data, int packetSize) {
        this.remoteSocketAddress = remoteSocketAddress;
        this.data = data;
    }

    void prepareForSend() {
        this.data.clear();
    }

    void setRemoteAddress(SocketAddress remoteSocketAddress) {
        this.remoteSocketAddress = remoteSocketAddress;
    }

    protected ByteBuffer getData() {
        return this.data;
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.remoteSocketAddress;
    }

    public InetAddress getRemoteAddress() {
        if (this.remoteSocketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)this.remoteSocketAddress).getAddress();
        }
        return null;
    }

    public int getRemotePort() {
        if (this.remoteSocketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)this.remoteSocketAddress).getPort();
        }
        return -1;
    }

    public byte readByte() throws IOException, BufferUnderflowException {
        return this.data.get();
    }

    public ByteBuffer readByteBufferByLength(int length) throws IOException, BufferUnderflowException {
        int savedLimit = this.data.limit();
        int savedPosition = this.data.position();
        this.data.limit(this.data.position() + length);
        ByteBuffer sliced = this.data.slice();
        this.data.position(savedPosition + length);
        this.data.limit(savedLimit);
        return sliced;
    }

    public byte[] readBytesByLength(int length) throws IOException, BufferUnderflowException {
        return DataConverter.toBytes(this.readByteBufferByLength(length));
    }

    public String readStringByLength(int length, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
        return DataConverter.toString(this.readByteBufferByLength(length), encoding);
    }

    public String readStringByLength(int length) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByLength(length, this.defaultEncoding);
    }

    public double readDouble() throws IOException, BufferUnderflowException {
        return this.data.getDouble();
    }

    public int readInt() throws IOException, BufferUnderflowException {
        return this.data.getInt();
    }

    public short readShort() throws IOException, BufferUnderflowException {
        return this.data.getShort();
    }

    public long readLong() throws IOException, BufferUnderflowException {
        return this.data.getLong();
    }

    public ByteBuffer readByteBuffer() throws IOException {
        ByteBuffer sliced = this.data.slice();
        this.data.position(this.data.limit());
        return sliced;
    }

    public byte[] readBytes() throws IOException {
        return DataConverter.toBytes(this.readByteBuffer());
    }

    public String readString() throws IOException, UnsupportedEncodingException {
        return this.readString(this.defaultEncoding);
    }

    public String readString(String encoding) throws IOException, UnsupportedEncodingException {
        return DataConverter.toString(this.readByteBuffer(), encoding);
    }

    public String readStringByDelimiter(String delimiter) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
        return this.readStringByDelimiter(delimiter, this.defaultEncoding, Integer.MAX_VALUE);
    }

    public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        return this.readStringByDelimiter(delimiter, this.defaultEncoding, maxLength);
    }

    public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        ByteBuffer buffer = this.readByteBufferByDelimiter(delimiter, maxLength);
        return DataConverter.toString(buffer, encoding);
    }

    public ByteBuffer readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        byte[] delimiterBytes = delimiter.getBytes();
        int startPos = UserDatagram.findDelimiter(this.data, delimiterBytes, maxLength);
        if (startPos >= 0) {
            int savedLimit = this.data.limit();
            this.data.limit(startPos);
            ByteBuffer result = this.data.slice();
            this.data.limit(savedLimit);
            this.data.position(startPos + delimiterBytes.length);
            return result;
        }
        throw new BufferUnderflowException();
    }

    public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        ByteBuffer buffer = this.readByteBufferByDelimiter(delimiter, maxLength);
        return DataConverter.toBytes(buffer);
    }

    private static int findDelimiter(ByteBuffer buffer, byte[] delimiter, int maxLength) throws MaxReadSizeExceededException {
        int result = -1;
        int delimiterPosition = 0;
        for (int pos = buffer.position(); pos < buffer.limit(); ++pos) {
            byte b = buffer.get(pos);
            if (b == delimiter[delimiterPosition]) {
                if (++delimiterPosition != delimiter.length) continue;
                result = pos - delimiterPosition + 1;
                break;
            }
            delimiterPosition = 0;
        }
        if (result > maxLength) {
            throw new MaxReadSizeExceededException();
        }
        return result;
    }

    public int write(byte b) throws IOException, BufferOverflowException {
        this.data.put(b);
        return 1;
    }

    public int write(short s) throws IOException, BufferOverflowException {
        this.data.putShort(s);
        return 2;
    }

    public int write(byte ... bytes) throws IOException, BufferOverflowException {
        this.data.put(bytes);
        return bytes.length;
    }

    public int write(byte[] bytes, int offset, int length) throws IOException, BufferOverflowException {
        this.data.put(bytes, offset, length);
        return length;
    }

    public int write(ByteBuffer buffer) throws IOException, BufferOverflowException {
        int length = buffer.remaining();
        this.data.put(buffer);
        return length;
    }

    public long write(ByteBuffer[] buffers) throws IOException, BufferOverflowException {
        int length = 0;
        for (ByteBuffer buffer : buffers) {
            length += this.write(buffer);
        }
        return length;
    }

    public int write(double d) throws IOException, BufferOverflowException {
        this.data.putDouble(d);
        return 8;
    }

    public int write(int i) throws IOException, BufferOverflowException {
        this.data.putInt(i);
        return 4;
    }

    public int write(long l) throws IOException, BufferOverflowException {
        this.data.putLong(l);
        return 8;
    }

    public int write(String message) throws IOException, BufferOverflowException {
        return this.write(message, this.defaultEncoding);
    }

    public int write(String message, String encoding) throws IOException, BufferOverflowException {
        byte[] bytes = message.getBytes(encoding);
        this.data.put(bytes);
        return bytes.length;
    }

    public int getSize() {
        return this.data.limit();
    }

    public int getRemaining() {
        return this.data.remaining();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.remoteSocketAddress != null) {
            sb.append("remoteAddress=" + this.remoteSocketAddress.toString() + " ");
        } else {
            sb.append("remoteAddress=null ");
        }
        if (this.data != null) {
            sb.append("data=" + DataConverter.toHexString(new ByteBuffer[]{this.data.duplicate()}, 500) + " ");
        } else {
            sb.append("data=null ");
        }
        return sb.toString();
    }
}

