/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.stream;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.ClosedConnectionException;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.stream.Connection;
import org.xsocket.stream.IBlockingConnection;
import org.xsocket.stream.IConnection;
import org.xsocket.stream.IoHandlerContext;
import org.xsocket.stream.StreamSocketConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BlockingConnection
extends Connection
implements IBlockingConnection {
    private static final Logger LOG = Logger.getLogger(BlockingConnection.class.getName());
    private final Object readGuard = new Object();
    private long receiveTimeout = 0L;

    public BlockingConnection(String hostname, int port) throws IOException {
        this(new InetSocketAddress(hostname, port), new HashMap<String, Object>(), null, false);
    }

    public BlockingConnection(String hostname, int port, StreamSocketConfiguration socketConfiguration) throws IOException {
        this(new InetSocketAddress(hostname, port), socketConfiguration.toOptions(), null, false);
    }

    public BlockingConnection(String hostname, int port, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(hostname, port), options, null, false);
    }

    public BlockingConnection(InetAddress address, int port) throws IOException {
        this(new InetSocketAddress(address, port), new HashMap<String, Object>(), null, false);
    }

    public BlockingConnection(InetAddress address, int port, StreamSocketConfiguration socketConf) throws IOException {
        this(new InetSocketAddress(address, port), socketConf.toOptions(), null, false);
    }

    public BlockingConnection(InetAddress address, int port, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), options, null, false);
    }

    public BlockingConnection(InetAddress address, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), new HashMap<String, Object>(), sslContext, sslOn);
    }

    public BlockingConnection(InetAddress address, int port, StreamSocketConfiguration socketConf, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), socketConf.toOptions(), sslContext, sslOn);
    }

    public BlockingConnection(InetAddress address, int port, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), options, sslContext, sslOn);
    }

    public BlockingConnection(String hostname, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), new HashMap<String, Object>(), sslContext, sslOn);
    }

    public BlockingConnection(String hostname, int port, StreamSocketConfiguration socketConf, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), socketConf.toOptions(), sslContext, sslOn);
    }

    public BlockingConnection(String hostname, int port, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), options, sslContext, sslOn);
    }

    private BlockingConnection(InetSocketAddress remoteAddress, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        super(new IoHandlerContext(null, null), remoteAddress, options, sslContext, sslOn);
        this.setReceiveTimeoutMillis(60000L);
        this.setFlushmode(IConnection.FlushMode.SYNC);
        this.init();
    }

    @Override
    void reset() throws IOException {
        super.reset();
        this.setReceiveTimeoutMillis(60000L);
        this.setFlushmode(IConnection.FlushMode.SYNC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte readByte() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.extractByteFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    @Override
    public final void setReceiveTimeoutMillis(long timeout) {
        this.receiveTimeout = timeout;
    }

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.readByteBufferByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, SocketTimeoutException, MaxReadSizeExceededException {
        return this.readByteBufferByDelimiter(delimiter, this.getDefaultEncoding(), maxLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    LinkedList<ByteBuffer> result = this.extractBytesByDelimiterFromReadQueue(delimiter.getBytes(encoding), maxLength);
                    return result.toArray(new ByteBuffer[result.size()]);
                }
                catch (MaxReadSizeExceededException mee) {
                    throw mee;
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        if (length <= 0) {
            return null;
        }
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    LinkedList<ByteBuffer> result = this.extractBytesByLength(length);
                    return result.toArray(new ByteBuffer[result.size()]);
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    @Override
    public byte[] readBytesByDelimiter(String delimiter) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.readBytesByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    @Override
    public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, SocketTimeoutException, MaxReadSizeExceededException {
        return this.readBytesByDelimiter(delimiter, this.getDefaultEncoding(), maxLength);
    }

    @Override
    public byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException {
        return DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, encoding, maxLength));
    }

    @Override
    public byte[] readBytesByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return DataConverter.toBytes(this.readByteBufferByLength(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double readDouble() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.extractDoubleFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readInt() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.extractIntFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short readShort() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.extractShortFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int read(ByteBuffer buffer) throws IOException {
        int size = buffer.remaining();
        if (size < 1) {
            return 0;
        }
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            do {
                int availableSize;
                if ((availableSize = this.getReadQueue().getSize()) > 0) {
                    ByteBuffer[] bufs;
                    if (size > availableSize) {
                        size = availableSize;
                    }
                    for (ByteBuffer buf : bufs = this.readByteBufferByLength(size)) {
                        buffer.put(buf);
                    }
                    return size;
                }
                try {
                    this.readGuard.wait(remainingTime);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            } while ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long readLong() throws IOException, ClosedConnectionException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.extractLongFromReadQueue();
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    @Override
    public String readStringByDelimiter(String delimiter) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    @Override
    public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException, MaxReadSizeExceededException {
        return this.readStringByDelimiter(delimiter, this.getDefaultEncoding(), maxLength);
    }

    @Override
    public String readStringByDelimiter(String delimiter, String encoding) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, ClosedConnectionException, UnsupportedEncodingException, SocketTimeoutException, MaxReadSizeExceededException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    LinkedList<ByteBuffer> extracted = this.extractBytesByDelimiterFromReadQueue(delimiter.getBytes(encoding), maxLength);
                    return DataConverter.toString(extracted, encoding);
                }
                catch (MaxReadSizeExceededException mle) {
                    throw mle;
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    @Override
    public int getIndexOf(String str) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.getIndexOf(str, Integer.MAX_VALUE);
    }

    @Override
    public int getIndexOf(String str, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.getIndexOf(str, this.getDefaultEncoding(), maxLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIndexOf(String str, String encoding, int maxLength) throws IOException, ClosedConnectionException, MaxReadSizeExceededException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    return this.readIndexOf(str.getBytes(encoding), maxLength);
                }
                catch (MaxReadSizeExceededException mle) {
                    throw mle;
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    @Override
    public String readStringByLength(int length) throws IOException, ClosedConnectionException, SocketTimeoutException {
        return this.readStringByLength(length, this.getDefaultEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readStringByLength(int length, String encoding) throws IOException, ClosedConnectionException, SocketTimeoutException {
        if (length <= 0) {
            return null;
        }
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeout;
        Object object = this.readGuard;
        synchronized (object) {
            while (true) {
                try {
                    LinkedList<ByteBuffer> extracted = this.extractBytesByLength(length);
                    return DataConverter.toString(extracted, encoding);
                }
                catch (BufferUnderflowException bue) {
                    try {
                        this.readGuard.wait(remainingTime);
                        continue;
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if ((remainingTime = start + this.receiveTimeout - System.currentTimeMillis()) > 0L) continue;
                }
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached. throwsing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + DataConverter.toFormatedDuration(this.receiveTimeout) + " reached");
    }

    @Override
    public IBlockingConnection setOption(String name, Object value) throws IOException {
        return (IBlockingConnection)super.setOption(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int onDataEvent() {
        int addSize = super.onDataEvent();
        if (addSize > 0) {
            Object object = this.readGuard;
            synchronized (object) {
                this.readGuard.notify();
            }
        }
        return addSize;
    }
}

